/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control.skin;

import java.util.function.Function;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import tornadofx.control.ListMenu;

public class ListMenuSkin
extends SkinBase<ListMenu> {
    public ListMenuSkin(ListMenu control) {
        super((Control)control);
    }

    private double acc(Function<Node, Double> fn) {
        double val = 0.0;
        for (Node node : this.getChildren()) {
            val += fn.apply(node).doubleValue();
        }
        return val;
    }

    private double biggest(Function<Node, Double> fn) {
        double val = 0.0;
        for (Node node : this.getChildren()) {
            double nval = fn.apply(node);
            if (!(nval > val)) continue;
            val = nval;
        }
        return val;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ListMenu)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.biggest(n -> n.minWidth(height));
        }
        return this.acc(n -> n.minWidth(height));
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ListMenu)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.acc(n -> n.minHeight(width));
        }
        return this.biggest(n -> n.minHeight(width));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = ((ListMenu)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.biggest(n -> n.prefWidth(height)) + leftInset + rightInset : this.acc(n -> n.prefWidth(height)) + leftInset + rightInset;
        return Math.max(prefWidth, ((ListMenu)this.getSkinnable()).getPrefWidth());
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight = ((ListMenu)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.acc(n -> n.prefHeight(width)) + topInset + bottomInset : this.biggest(n -> n.prefHeight(width)) + topInset + bottomInset;
        return Math.max(prefHeight, ((ListMenu)this.getSkinnable()).getPrefHeight());
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        for (Node node : this.getChildren()) {
            if (((ListMenu)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                double prefHeight = node.prefHeight(-1.0);
                node.resizeRelocate(x, y, w, prefHeight);
                y += prefHeight;
                continue;
            }
            double prefWidth = node.prefWidth(-1.0);
            node.resizeRelocate(x, y, prefWidth, h);
            x += prefWidth;
        }
    }
}

