/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.AuthContext;
import tornadofx.HttpURLEngine;
import tornadofx.HttpURLResponse;
import tornadofx.JsonModel;
import tornadofx.Rest;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0019H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010(\u001a\u00020\u0019H\u0016J\b\u0010-\u001a\u00020'H\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006."}, d2={"Ltornadofx/HttpURLRequest;", "Ltornadofx/Rest$Request;", "engine", "Ltornadofx/HttpURLEngine;", "seq", "", "method", "Ltornadofx/Rest$Request$Method;", "uri", "Ljava/net/URI;", "entity", "", "(Ltornadofx/HttpURLEngine;JLtornadofx/Rest$Request$Method;Ljava/net/URI;Ljava/lang/Object;)V", "connection", "Ljava/net/HttpURLConnection;", "getConnection", "()Ljava/net/HttpURLConnection;", "setConnection", "(Ljava/net/HttpURLConnection;)V", "getEngine", "()Ltornadofx/HttpURLEngine;", "getEntity", "()Ljava/lang/Object;", "headers", "", "", "getHeaders", "()Ljava/util/Map;", "getMethod", "()Ltornadofx/Rest$Request$Method;", "properties", "getProperties", "setProperties", "(Ljava/util/Map;)V", "getSeq", "()J", "getUri", "()Ljava/net/URI;", "addHeader", "", "name", "value", "execute", "Ltornadofx/Rest$Response;", "getHeader", "reset", "tornadofx"})
public final class HttpURLRequest
implements Rest.Request {
    @NotNull
    public HttpURLConnection connection;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private Map<Object, Object> properties;
    @NotNull
    private final HttpURLEngine engine;
    private final long seq;
    @NotNull
    private final Rest.Request.Method method;
    @NotNull
    private final URI uri;
    @Nullable
    private final Object entity;

    @NotNull
    public final HttpURLConnection getConnection() {
        HttpURLConnection httpURLConnection = this.connection;
        if (httpURLConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
        }
        return httpURLConnection;
    }

    public final void setConnection(@NotNull HttpURLConnection httpURLConnection) {
        Intrinsics.checkParameterIsNotNull((Object)httpURLConnection, (String)"<set-?>");
        this.connection = httpURLConnection;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void reset() {
        URL url = this.getUri().toURL();
        URLConnection uRLConnection = this.engine.getRest().getProxy() != null ? url.openConnection(this.engine.getRest().getProxy()) : url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        this.connection = (HttpURLConnection)uRLConnection;
        Map<String, String> map = this.headers;
        Pair pair = TuplesKt.to((Object)"Accept-Encoding", (Object)"gzip, deflate");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
        map = this.headers;
        pair = TuplesKt.to((Object)"Content-Type", (Object)"application/json");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
        map = this.headers;
        pair = TuplesKt.to((Object)"Accept", (Object)"application/json");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
        map = this.headers;
        pair = TuplesKt.to((Object)"User-Agent", (Object)("TornadoFX/Java " + System.getProperty("java.version")));
        map.put((String)pair.getFirst(), (String)pair.getSecond());
        map = this.headers;
        pair = TuplesKt.to((Object)"Connection", (Object)"Keep-Alive");
        map.put((String)pair.getFirst(), (String)pair.getSecond());
    }

    @Override
    @NotNull
    public Rest.Response execute() {
        Object modifiedResponse;
        block27: {
            Object object;
            AuthContext authContext = this.engine.getRest().getAuthContext();
            if (authContext != null) {
                authContext.interceptRequest(this);
            }
            Function1<Rest.Request, Unit> function1 = this.engine.getRequestInterceptor();
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
            }
            Object object2 = this.headers;
            Object object3 = object2.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = object3.next();
                String key2 = entry2.getKey();
                entry2 = entry;
                String value = entry2.getValue();
                HttpURLConnection httpURLConnection = this.connection;
                if (httpURLConnection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection.addRequestProperty(key2, value);
            }
            HttpURLConnection httpURLConnection = this.connection;
            if (httpURLConnection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            }
            httpURLConnection.setRequestMethod(this.getMethod().toString());
            if (this.getEntity() != null) {
                byte[] byArray;
                Charset charset;
                if (this.headers.get("Content-Type") == null) {
                    HttpURLConnection httpURLConnection2 = this.connection;
                    if (httpURLConnection2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    }
                    httpURLConnection2.addRequestProperty("Content-Type", "application/json");
                }
                HttpURLConnection httpURLConnection3 = this.connection;
                if (httpURLConnection3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection3.setDoOutput(true);
                object3 = this.getEntity();
                if (object3 instanceof JsonModel) {
                    object2 = ((JsonModel)this.getEntity()).toJSON().toString();
                    Charset charset2 = StandardCharsets.UTF_8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"UTF_8");
                    charset = charset2;
                    Object object4 = object2;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray2 = ((String)object4).getBytes(charset);
                    byArray = byArray2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                } else if (object3 instanceof JsonValue) {
                    object2 = this.getEntity().toString();
                    Charset charset3 = StandardCharsets.UTF_8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"UTF_8");
                    charset = charset3;
                    Object object5 = object2;
                    if (object5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray3 = ((String)object5).getBytes(charset);
                    byArray = byArray3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
                } else if (object3 instanceof InputStream) {
                    byArray = ByteStreamsKt.readBytes$default((InputStream)((InputStream)this.getEntity()), (int)0, (int)1, null);
                } else {
                    throw (Throwable)new IllegalArgumentException("Don't know how to handle entity of type " + this.getEntity().getClass());
                }
                byte[] data2 = byArray;
                HttpURLConnection httpURLConnection4 = this.connection;
                if (httpURLConnection4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection4.addRequestProperty("Content-Length", String.valueOf(data2.length));
                HttpURLConnection httpURLConnection5 = this.connection;
                if (httpURLConnection5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection5.connect();
                HttpURLConnection httpURLConnection6 = this.connection;
                if (httpURLConnection6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection6.getOutputStream().write(data2);
                HttpURLConnection httpURLConnection7 = this.connection;
                if (httpURLConnection7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection7.getOutputStream().flush();
                HttpURLConnection httpURLConnection8 = this.connection;
                if (httpURLConnection8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection8.getOutputStream().close();
            } else {
                HttpURLConnection httpURLConnection9 = this.connection;
                if (httpURLConnection9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                httpURLConnection9.connect();
            }
            HttpURLResponse response = new HttpURLResponse(this);
            HttpURLConnection httpURLConnection10 = this.connection;
            if (httpURLConnection10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            }
            if (httpURLConnection10.getDoOutput()) {
                response.bytes();
            }
            if ((object = this.engine.getRest().getAuthContext()) == null || (object = object.interceptResponse(response)) == null) {
                object = response;
            }
            modifiedResponse = object;
            Function1<Rest.Response, Unit> function12 = this.engine.getResponseInterceptor();
            if (function12 == null) break block27;
            Unit cfr_ignored_1 = (Unit)function12.invoke(modifiedResponse);
        }
        return modifiedResponse;
    }

    @Override
    public void addHeader(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map<String, String> map = this.headers;
        String string2 = value;
        map.put(name, string2);
    }

    @Override
    @Nullable
    public String getHeader(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.headers.get(name);
    }

    @Override
    @NotNull
    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(@NotNull Map<Object, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.properties = map;
    }

    @NotNull
    public final HttpURLEngine getEngine() {
        return this.engine;
    }

    @Override
    public long getSeq() {
        return this.seq;
    }

    @Override
    @NotNull
    public Rest.Request.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public Object getEntity() {
        return this.entity;
    }

    public HttpURLRequest(@NotNull HttpURLEngine engine, long seq, @NotNull Rest.Request.Method method, @NotNull URI uri, @Nullable Object entity) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.engine = engine;
        this.seq = seq;
        this.method = method;
        this.uri = uri;
        this.entity = entity;
        HttpURLRequest httpURLRequest = this;
        httpURLRequest.headers = map = (Map)new LinkedHashMap();
        this.reset();
        this.properties = new HashMap();
    }
}

