/*
 * Decompiled with CFR 0.152.
 */
package no.uis.nio.smb;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFilenameFilter;
import no.uis.nio.smb.SMBFileSystemProvider;
import no.uis.nio.smb.SMBPath;

public class SMBDirectoryStream
implements DirectoryStream<Path> {
    private final SMBPath smbFile;
    private final DirectoryStream.Filter<? super Path> filter;
    private final SMBFileSystemProvider provider;
    private boolean closed = false;

    public SMBDirectoryStream(SMBFileSystemProvider provider, SMBPath smbFile, DirectoryStream.Filter<? super Path> filter) {
        this.smbFile = smbFile;
        this.filter = filter;
        this.provider = provider;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        try {
            SmbFile[] files = this.smbFile.getSmbFile().listFiles();
            ArrayList<SMBPath> paths = new ArrayList<SMBPath>(files.length);
            for (SmbFile file : files) {
                SMBPath p = new SMBPath(this.provider, file.getURL().toURI());
                if (this.filter != null && !this.filter.accept(p)) continue;
                paths.add(p);
            }
            return paths.iterator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SmbFilenameFilter convertFilter(DirectoryStream.Filter<? super Path> srcFilter) {
        if (srcFilter == null) {
            return null;
        }
        return null;
    }
}

