/*
 * Decompiled with CFR 0.152.
 */
package no.uis.nio.smb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import jcifs.Config;
import jcifs.smb.SmbException;
import no.uis.nio.smb.SMBBasePath;
import no.uis.nio.smb.SMBByteChannel;
import no.uis.nio.smb.SMBDirectoryStream;
import no.uis.nio.smb.SMBFileAttributes;
import no.uis.nio.smb.SMBPath;

public class SMBFileSystemProvider
extends FileSystemProvider {
    public SMBFileSystemProvider() throws IOException {
        InputStream config;
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        Config.list((PrintStream)new PrintStream(outBuffer, true));
        if (outBuffer.size() > 0) {
            Logger.getLogger(this.getClass().getName()).warning("jcifs already configured with:\n" + outBuffer.toString());
        }
        if ((config = this.getClass().getResourceAsStream("/jcifs-config.properties")) != null) {
            Config.load((InputStream)config);
        }
    }

    @Override
    public String getScheme() {
        return "smb";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path getPath(URI uri) {
        try {
            return new SMBPath(this, uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        SMBPath smbPath = (SMBPath)SMBFileSystemProvider.toSMBPath(path);
        return new SMBByteChannel(smbPath);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Object smbFile = SMBFileSystemProvider.toSMBPath(dir);
        if (!((SMBBasePath)smbFile).isAbsolute()) {
            throw new IllegalArgumentException(dir.toString());
        }
        SMBDirectoryStream dirStream = new SMBDirectoryStream(this, (SMBPath)smbFile, filter);
        return dirStream;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        block2: {
            try {
                ((SMBBasePath)SMBFileSystemProvider.toSMBPath(dir)).getSmbFile().mkdirs();
            }
            catch (SmbException e) {
                if (e.getNtStatus() != -1073741771) break block2;
                throw new FileAlreadyExistsException(dir.toString(), null, e.getMessage());
            }
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        SMBPath smbPath = (SMBPath)SMBFileSystemProvider.toSMBPath(path);
        smbPath.getSmbFile().delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (!((SMBBasePath)SMBFileSystemProvider.toSMBPath(path)).getSmbFile().exists()) {
            throw new NoSuchFileException(path.toString());
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == SMBFileAttributes.class) {
            return (A)((SMBBasePath)SMBFileSystemProvider.toSMBPath(path)).getAttributes();
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static <A extends SMBBasePath> A toSMBPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof SMBBasePath)) {
            throw new ProviderMismatchException();
        }
        return (A)((SMBBasePath)path);
    }
}

