/*
 * Decompiled with CFR 0.152.
 */
package no.uis.nio.smb;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import jcifs.smb.Handler;
import jcifs.smb.SmbFile;
import no.uis.nio.smb.SMBBasePath;
import no.uis.nio.smb.SMBFileAttributes;
import no.uis.nio.smb.SMBFileSystemProvider;
import no.uis.nio.smb.SMBShare;

public class SMBPath
extends SMBBasePath {
    private final SmbFile file;
    private final SMBShare fileSystem;
    private final SMBFileSystemProvider provider;
    private final URI uri;

    public SMBPath(SMBFileSystemProvider provider, URI uri) throws IOException, URISyntaxException {
        super(SMBPath.toPublicString(uri));
        SmbFile _file = new SmbFile(new URL(null, uri.toString(), (URLStreamHandler)new Handler()));
        if (_file.getShare() == null) {
            throw new IllegalArgumentException(uri.toString());
        }
        this.file = _file;
        this.provider = provider;
        this.uri = uri;
        this.fileSystem = new SMBShare(provider, this.file.getServer(), this.file.getShare(), this.file.getPrincipal());
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public Path getParent() {
        String parent = this.file.getParent();
        try {
            URI parentUri = new URI(parent);
            return new SMBPath(this.provider, parentUri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public File toFile() {
        return new File(this.file.getUncPath());
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public Path relativize(Path other) {
        int i;
        int commonLevel;
        Object otherSmbPath = SMBFileSystemProvider.toSMBPath(other);
        if (!other.isAbsolute()) {
            throw new IllegalArgumentException(other.toString());
        }
        String thisUNC = this.file.getUncPath();
        String otherUNC = ((SMBBasePath)otherSmbPath).getSmbFile().getUncPath();
        String[] thisParts = thisUNC.split("\\\\");
        String[] otherParts = otherUNC.split("\\\\");
        for (commonLevel = 0; commonLevel < Math.min(thisParts.length, otherParts.length) && otherParts[commonLevel].equals(thisParts[commonLevel]); ++commonLevel) {
        }
        if (commonLevel < 4) {
            throw new IllegalArgumentException(other.toString());
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < thisParts.length - commonLevel; ++i) {
            sb.append("..\\");
        }
        for (i = commonLevel; i < otherParts.length; ++i) {
            sb.append(otherParts[i]);
            sb.append("\\");
        }
        return new SMBBasePath(sb.toString());
    }

    @Override
    public Path resolve(String other) {
        URI otherUri = this.uri.resolve(other);
        try {
            return new SMBPath(this.provider, otherUri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(other, e);
        }
    }

    @Override
    public Path resolve(Path other) {
        Object otherPath = SMBFileSystemProvider.toSMBPath(other);
        if (((SMBBasePath)otherPath).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return this.resolve(((SMBBasePath)otherPath).toString());
    }

    @Override
    public SmbFile getSmbFile() {
        return this.file;
    }

    @Override
    public SMBFileAttributes getAttributes() throws IOException {
        return new SMBFileAttributes(this.file.getUncPath(), this.file.getAttributes());
    }

    private static String toPublicString(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
    }
}

