/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.httpclient;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class TaskExecutor
implements Executor {
    private static TaskExecutor taskExecutor = null;
    private static final int INITIAL_POOL_SIZE = 5;
    private static final int MAX_POOL_SIZE = 5;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final ThreadPoolExecutor threadPoolExecutor;
    private final ThreadFactory threadFactory = new MyThreadFactory();

    private TaskExecutor() {
        this.threadPoolExecutor = new ThreadPoolExecutor(5, 5, 10L, KEEP_ALIVE_TIME_UNIT, this.workQueue, this.threadFactory);
    }

    protected static TaskExecutor getTaskExecutor() {
        if (taskExecutor == null) {
            taskExecutor = new TaskExecutor();
        }
        return taskExecutor;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException("Task to be execute cannot be null");
        }
        this.threadPoolExecutor.execute(command);
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private static final String THREAD_NAME = "HTTPClient_Spawned_Thread: ";
        private int counter = 0;

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, THREAD_NAME + this.counter++);
            return t;
        }
    }
}

