/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.presentation.view.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.android.imepaysdk.R;
import com.android.imepaysdk.UrlConfig;
import org.json.JSONException;
import org.json.JSONObject;

public class IMEPayWebActivity
extends AppCompatActivity {
    WebView webview;
    TextView tvNoData;
    Bundle data;
    private ArgsModel params;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_web_client);
        this.webview = (WebView)this.findViewById(R.id.webview);
        this.tvNoData = (TextView)this.findViewById(R.id.tv_nodata);
        this.webview.getSettings().setJavaScriptEnabled(true);
        this.data = this.getIntent().getExtras();
        this.init();
    }

    private void init() {
        this.params = new ArgsModel();
        if (this.data != null) {
            try {
                this.params.setAmount(this.data.getString("amount"));
                this.params.setMerchantCode(this.data.getString("merchantCode"));
                this.params.setMerchantName(this.data.getString("merchantName"));
                this.params.setMerchantUrl(this.data.getString("merchantUrl"));
                this.params.setModule(this.data.getString("module"));
                this.params.setPassword(this.data.getString("password"));
                this.params.setUser(this.data.getString("user"));
                this.params.setRefId(this.data.getString("refId"));
                this.params.setDeliveryUrl(this.data.getString("deliveryUrl"));
                this.tvNoData.setVisibility(8);
                this.webview.setVisibility(0);
                String url = UrlConfig.getWebBaseURL() + this.params.toString();
                this.webview.loadUrl(url);
                System.out.println("Web url = " + url);
            }
            catch (NullPointerException ex) {
                this.tvNoData.setText((CharSequence)"Incomplete data is sent.");
                this.tvNoData.setVisibility(0);
                this.webview.setVisibility(8);
                throw new IllegalArgumentException("Incomplete data is sent.");
            }
        } else {
            this.tvNoData.setText((CharSequence)"No data is sent.");
            this.tvNoData.setVisibility(0);
            this.webview.setVisibility(8);
            throw new IllegalArgumentException("No data is sent.");
        }
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress >= 80) {
                    // empty if block
                }
            }
        });
        this.webview.addJavascriptInterface((Object)new WebAppInterface((Context)this), "Android");
        this.webview.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void onBackPressed() {
        this.showExitDialog();
    }

    public void showExitDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)"Do you really want to abort the payment?");
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                IMEPayWebActivity.this.finish();
            }
        });
        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int i) {
                dialog.dismiss();
            }
        });
        builder.show();
    }

    public final class ArgsModel {
        private String merchantCode = "";
        private String merchantName = "";
        private String merchantUrl;
        private String user = "";
        private String password = "";
        private String module = "";
        private String msisdn = "";
        private String refId = "";
        private String amount = "";
        private String pin;
        private String otpCode;
        private String token = "";
        private String deliveryUrl = "";

        protected ArgsModel() {
        }

        public String getMerchantCode() {
            return this.merchantCode;
        }

        private void setMerchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
        }

        public String getMerchantName() {
            return this.merchantName;
        }

        private void setMerchantName(String merchantName) {
            this.merchantName = merchantName;
        }

        public String getMerchantUrl() {
            return this.merchantUrl;
        }

        private void setMerchantUrl(String merchantUrl) {
            this.merchantUrl = merchantUrl;
        }

        public String getUser() {
            return this.user;
        }

        private void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        private void setPassword(String password) {
            this.password = password;
        }

        public String getModule() {
            return this.module;
        }

        private void setModule(String module) {
            this.module = module;
        }

        public String getMsisdn() {
            return this.msisdn;
        }

        private void setMsisdn(String msisdn) {
            this.msisdn = msisdn;
        }

        public String getRefId() {
            return this.refId;
        }

        private void setRefId(String refId) {
            this.refId = refId;
        }

        public String getAmount() {
            return this.amount;
        }

        private void setAmount(String amount) {
            this.amount = amount;
        }

        public String getToken() {
            return this.token;
        }

        private void setToken(String token) {
            this.token = token;
        }

        private void setPin(String pin) {
            this.pin = pin;
        }

        public String getOtpCode() {
            return this.otpCode;
        }

        private void setOtpCode(String otpCode) {
            this.otpCode = otpCode;
        }

        public String getDeliveryUrl() {
            return this.deliveryUrl;
        }

        private void setDeliveryUrl(String deliveryUrl) {
            this.deliveryUrl = deliveryUrl;
        }

        private void resetTemporaryData() {
            this.otpCode = "";
            this.pin = "";
            this.token = "";
        }

        public String toString() {
            return "?MerchantCode=" + this.merchantCode + "&MerchantName=" + this.merchantName + "&MerchantUrl=" + this.merchantUrl + "&DeleveryUrl=" + this.deliveryUrl + "&Amount=" + this.amount + "&RefId=" + this.refId + "&Module=" + this.module + "&User=" + this.user + "&Password=" + this.password;
        }

        public String getValue() {
            String tempPin = this.pin;
            this.pin = "";
            return tempPin;
        }
    }

    public class WebAppInterface {
        Context mContext;

        WebAppInterface(Context c) {
            this.mContext = c;
        }

        @JavascriptInterface
        public void showToast(String toast) {
            Toast.makeText((Context)this.mContext, (CharSequence)toast, (int)0).show();
        }

        @JavascriptInterface
        public void onActionCallback(String data) {
            try {
                JSONObject obj = new JSONObject(data);
                if (obj.getString("action").equalsIgnoreCase("back")) {
                    IMEPayWebActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            IMEPayWebActivity.this.onBackPressed();
                        }
                    });
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            System.out.println("Button clicked =====" + data);
        }
    }
}

