/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.presentation.view.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.android.imepaysdk.R;
import com.android.imepaysdk.presentation.view.fragment.BaseFragment;

public class DownloadImePayFragment
extends BaseFragment
implements View.OnClickListener {
    Button download;
    TextView desc;
    Bundle bundle;
    int status;
    String description;
    private final String IMEPAY_PACKAGE_NAME = "com.swifttechnology.imepay";

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dowload_imepay, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.download = (Button)view.findViewById(R.id.btn_downloadImepay);
        this.desc = (TextView)view.findViewById(R.id.tv_desc);
        this.init();
    }

    public void init() {
        this.hideKeyboard();
        this.bundle = this.getArguments();
        this.status = this.bundle.getInt("Status");
        this.description = this.bundle.getString("Description");
        this.showDescription(this.status, this.description);
        this.download.setOnClickListener((View.OnClickListener)this);
    }

    private void showDescription(int status, String description) {
        switch (status) {
            case 104: {
                this.desc.setText((CharSequence)description);
                this.download.setVisibility(4);
                break;
            }
            case 105: {
                this.desc.setText((CharSequence)description);
                this.download.setVisibility(0);
                this.download.setText(R.string.add_now);
                break;
            }
            case 102: 
            case 103: {
                this.desc.setText((CharSequence)description);
                this.download.setVisibility(0);
            }
        }
    }

    public void onClick(View v) {
        try {
            if (this.isPackageInstalled(this.getContext())) {
                this.startActivity(this.getContext().getPackageManager().getLaunchIntentForPackage("com.swifttechnology.imepay"));
            } else {
                String url = "market://details?id=com.swifttechnology.imepay";
                Intent i = new Intent("android.intent.action.VIEW");
                i.addFlags(0x10000000);
                i.setData(Uri.parse((String)url));
                this.startActivity(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isPackageInstalled(Context mContext) {
        boolean found = true;
        try {
            mContext.getPackageManager().getPackageInfo("com.swifttechnology.imepay", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            found = false;
        }
        return found;
    }
}

