/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.httpclient;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.android.imepaysdk.httpclient.Callback;
import com.android.imepaysdk.httpclient.PostTask;
import com.android.imepaysdk.httpclient.TaskExecutor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public final class HTTPClient {
    private static Handler handler = null;

    static Handler getMainThreadHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                }
            };
        }
        return handler;
    }

    public static synchronized Runnable request(String url, Map<String, String> header, String method, String body, Callback listener) {
        URL urlObj;
        String method_string = method.toUpperCase().trim();
        try {
            urlObj = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid Url: " + url);
        }
        switch (method_string) {
            case "POST": {
                return new PostTask(urlObj, header, body, listener);
            }
        }
        throw new IllegalArgumentException("Undefined http method: " + method_string);
    }

    public static void enqueue(Runnable command) {
        if (!(command instanceof PostTask)) {
            throw new IllegalArgumentException("External task is forbidden, please use task provided by HTTPClient.request method");
        }
        TaskExecutor.getTaskExecutor().execute(command);
    }
}

