/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.network;

import android.util.Log;
import com.android.imepaysdk.UrlConfig;
import com.android.imepaysdk.httpclient.HTTPClient;
import com.android.imepaysdk.presentation.interactor.OTPValidationFragmentInteractor;
import com.android.imepaysdk.presentation.presenter.OTPValidationFragmentPresenterImpl;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class OTPValidationFragmentHTTPClient
implements OTPValidationFragmentInteractor.OTPValidationNetworkInteractor {
    private OTPValidationFragmentInteractor sajiloPayInteractor;
    private String TAG = "PAYMENTHTTP";

    public OTPValidationFragmentHTTPClient(OTPValidationFragmentInteractor caller) {
        this.sajiloPayInteractor = caller;
    }

    @Override
    public void performPayment(String auth, String merchantCode, String module, String amount, String refId, String msisdn, String pin, String tokenId, OTPValidationFragmentPresenterImpl.PaymentCallback paymentCallback) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("MerchantCode", (Object)merchantCode);
            jsonObject.put("Amount", (Object)amount);
            jsonObject.put("RefId", (Object)refId);
            jsonObject.put("Msisdn", (Object)msisdn);
            jsonObject.put("Pin", (Object)pin);
            jsonObject.put("TokenId", (Object)tokenId);
        }
        catch (JSONException ex) {
            Log.d((String)this.TAG, (String)ex.getMessage());
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", auth);
        header.put("module", module);
        header.put("Content-Type", "application/json;charset=UTF-8");
        Runnable paymentTask = HTTPClient.request(UrlConfig.getBaseURL() + "Web/Payment", header, "POST", jsonObject.toString(), paymentCallback);
        HTTPClient.enqueue(paymentTask);
    }

    @Override
    public void confirmPayment(String auth, String merchantCode, String module, String transactionId, String refId, String msisdn, OTPValidationFragmentPresenterImpl.ConfirmCallback confirmCallback) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("MerchantCode", (Object)merchantCode);
            jsonObject.put("TransactionId", (Object)transactionId);
            jsonObject.put("RefId", (Object)refId);
            jsonObject.put("Msisdn", (Object)msisdn);
        }
        catch (JSONException ex) {
            Log.d((String)this.TAG, (String)ex.getMessage());
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", auth);
        header.put("Module", module);
        header.put("Content-Type", "application/json;charset=UTF-8");
        Runnable confirmTask = HTTPClient.request(UrlConfig.getBaseURL() + "Web/Confirm", header, "POST", jsonObject.toString(), confirmCallback);
        HTTPClient.enqueue(confirmTask);
    }

    @Override
    public void validateOTP(String otp, String msisdn, String auth, String module, String merchantCode, OTPValidationFragmentPresenterImpl.OTPValidateCallback otpValidateCallback) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Otp", (Object)otp);
            jsonObject.put("Msisdn", (Object)msisdn);
            jsonObject.put("MerchantCode", (Object)merchantCode);
        }
        catch (JSONException ex) {
            Log.d((String)this.TAG, (String)ex.getMessage());
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", auth);
        header.put("Module", module);
        header.put("Content-Type", "application/json;charset=UTF-8");
        Runnable confirmTask = HTTPClient.request(UrlConfig.getBaseURL() + "Web/V2/ValidateOTP", header, "POST", jsonObject.toString(), otpValidateCallback);
        HTTPClient.enqueue(confirmTask);
    }
}

