/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.presentation.presenter;

import com.android.imepaysdk.httpclient.Callback;
import com.android.imepaysdk.httpclient.HTTPResponse;
import com.android.imepaysdk.network.ConfirmationFragmentHTTPClient;
import com.android.imepaysdk.presentation.abs.ConfirmationFragmentContract;
import com.android.imepaysdk.presentation.interactor.ConfirmationFragmentInteractor;
import com.android.imepaysdk.utils.GeneralUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfirmationFragmentPresenterImpl
implements ConfirmationFragmentContract,
ConfirmationFragmentInteractor {
    private ConfirmationFragmentContract.ConfirmationFragmentViewContract confirmationFragmentViewContract;
    private ConfirmationFragmentInteractor.ConfirmationNetworKInteractor confirmationNetworKInteractor;
    private String TAG = "PAYMENTHTTP";

    public ConfirmationFragmentPresenterImpl(ConfirmationFragmentContract.ConfirmationFragmentViewContract listener) {
        this.confirmationFragmentViewContract = listener;
        this.confirmationNetworKInteractor = new ConfirmationFragmentHTTPClient(this);
    }

    @Override
    public void proceedToRequestOTP(String msisdn, String walletPin, String merchantCode, String module, String uname, String password) {
        this.confirmationFragmentViewContract.showPaymentLoadingDialog(true, "Requesting for OTP Code...");
        String auth = "Basic " + GeneralUtils.getConvertedStringBase64(uname, password);
        String module_val = GeneralUtils.getConvertedStringBase64(module);
        this.confirmationNetworKInteractor.requestForOTP(msisdn, walletPin, merchantCode, auth, module_val, new OTPRequestCallback());
    }

    public class OTPRequestCallback
    implements Callback {
        @Override
        public void onSuccess(HTTPResponse response) {
            ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.showPaymentLoadingDialog(false, "");
            int appResponseCode = -1;
            String appResponseString = "";
            try {
                JSONObject jsonObject = new JSONObject(response.getResponseBody());
                appResponseCode = jsonObject.getInt("ResponseCode");
                appResponseString = jsonObject.getString("ResponseDescription");
            }
            catch (JSONException e) {
                e.printStackTrace();
                appResponseCode = -1;
            }
            switch (appResponseCode) {
                case -1: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", "Response could not be parsed.", -1);
                    break;
                }
                case 100: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", appResponseString, 1);
                    break;
                }
                case 101: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", appResponseString, -1);
                    break;
                }
                case 102: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", appResponseString, -1);
                    break;
                }
                case 115: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", appResponseString, -1);
                }
            }
        }

        @Override
        public void onFailed(int responseCode) {
            ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.showPaymentLoadingDialog(false, "");
            switch (responseCode) {
                case 403: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", "Connection Forbidden.", -1);
                    break;
                }
                case 500: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", "Internal Server Error.", -1);
                    break;
                }
                case 401: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", "Unauthorized.", -1);
                    break;
                }
                default: {
                    ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", "Your request could not be processed. Please contact IME pay support if you are getting this message frequently.", -1);
                }
            }
        }

        @Override
        public void onConnectionNotEstablished(String message) {
            ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.showPaymentLoadingDialog(false, "");
            ConfirmationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPRecieved("", "Connection could not be established.", -1);
        }
    }
}

