/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.presentation.view.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import androidx.annotation.Nullable;
import com.android.imepaysdk.R;
import com.android.imepaysdk.presentation.abs.BaseFragmentListener;
import com.android.imepaysdk.presentation.abs.IMEPayActivityContract;
import com.android.imepaysdk.presentation.abs.OTPValidationFragmentContract;
import com.android.imepaysdk.presentation.presenter.OTPValidationFragmentPresenterImpl;
import com.android.imepaysdk.presentation.view.activity.IMEPayActivity;
import com.android.imepaysdk.presentation.view.fragment.BaseFragment;

public class OtpValidationFragment
extends BaseFragment
implements View.OnClickListener,
OTPValidationFragmentContract.OTPValidationFragmentViewContract {
    EditText otpEditTxt;
    Button submitBtn;
    private IMEPayActivity.ArgsModel params;
    private OTPValidationFragmentContract presenter;
    private OTPNumberTextWatcher otpNumberTextWatcher;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_otp_validation, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.otpEditTxt = (EditText)view.findViewById(R.id.fragmentOTP_edTxtOtp);
        this.submitBtn = (Button)view.findViewById(R.id.fragmentOTP_submitBtn);
        this.init();
    }

    private void init() {
        this.presenter = new OTPValidationFragmentPresenterImpl(this);
        this.otpEditTxt.requestFocus();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                OtpValidationFragment.this.showKeyboard((View)OtpValidationFragment.this.otpEditTxt);
            }
        }, 200L);
        this.otpNumberTextWatcher = new OTPNumberTextWatcher();
    }

    public void onStart() {
        super.onStart();
        this.submitBtn.setOnClickListener((View.OnClickListener)this);
        this.otpEditTxt.addTextChangedListener((TextWatcher)this.otpNumberTextWatcher);
    }

    public void onStop() {
        super.onStop();
        this.submitBtn.setOnClickListener(null);
        this.otpEditTxt.removeTextChangedListener((TextWatcher)this.otpNumberTextWatcher);
    }

    public void onAttach(Context _context) {
        super.onAttach(_context);
        this.getDataFromActivity(_context);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.getDataFromActivity((Context)activity);
    }

    private void getDataFromActivity(Context context) {
        try {
            this.params = ((PaymentTransactionListener)context).getArguments();
        }
        catch (ClassCastException e) {
            Log.d((String)"", (String)(context.getClass().getSimpleName() + "didn't implement PaymentTransactionListener listener"));
        }
    }

    public void onClick(View v) {
        String msisdn = "";
        String uname = "";
        String module = "";
        String password = "";
        String merchantCode = "";
        msisdn = this.params.getMsisdn();
        uname = this.params.getUser();
        password = this.params.getPassword();
        module = this.params.getModule();
        merchantCode = this.params.getMerchantCode();
        this.presenter.validateOTP(this.otpEditTxt.getText().toString(), msisdn, module, merchantCode, uname, password);
    }

    @Override
    public void showMessage(String message) {
        ((IMEPayActivityContract)this.getActivity()).showToast(message);
    }

    @Override
    public void onPaymentResultRecieved(String transactionId, String resposneMessage, int STATUS) {
        this.hideKeyboard();
        switch (STATUS) {
            case 100: {
                ((PaymentTransactionListener)this.getActivity()).onPaymentProcessCompletion(true, STATUS, resposneMessage, transactionId);
                break;
            }
            case 101: {
                ((PaymentTransactionListener)this.getActivity()).onPaymentProcessCompletion(true, STATUS, resposneMessage, transactionId);
                break;
            }
            case -1: {
                ((PaymentTransactionListener)this.getActivity()).onPaymentProcessCompletion(false, STATUS, resposneMessage, "");
            }
        }
    }

    @Override
    public void onOTPValidation(boolean isValid, String errroMessage) {
        String token = "";
        String uname = "";
        String password = "";
        String merchantCode = "";
        String amount = "";
        String refId = "";
        String msisdn = "";
        String pin = "";
        String module = "";
        if (isValid) {
            token = this.params.getToken();
            uname = this.params.getUser();
            password = this.params.getPassword();
            merchantCode = this.params.getMerchantCode();
            amount = this.params.getAmount();
            refId = this.params.getRefId();
            msisdn = this.params.getMsisdn();
            module = this.params.getModule();
            pin = this.params.getValue();
            this.presenter.validatePaymentParams(uname, password, merchantCode, module, amount, refId, msisdn, pin, token);
        } else {
            ((PaymentTransactionListener)this.getActivity()).onPaymentProcessCompletion(false, -1, errroMessage, "");
        }
    }

    @Override
    public void showLoadingDialog(boolean action, String message) {
        ((IMEPayActivityContract)this.getActivity()).showProgressBar(action, message);
    }

    private class OTPNumberTextWatcher
    implements TextWatcher {
        private OTPNumberTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (s.toString().length() == 4) {
                OtpValidationFragment.this.hideKeyboard();
            }
        }
    }

    public static interface PaymentTransactionListener
    extends BaseFragmentListener {
        public void onPaymentProcessCompletion(boolean var1, int var2, String var3, String var4);
    }
}

