/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.presentation.view.fragment;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.android.imepaysdk.R;
import com.android.imepaysdk.presentation.abs.BaseFragmentListener;
import com.android.imepaysdk.presentation.abs.IMEPayActivityContract;
import com.android.imepaysdk.presentation.abs.SplashFragmentContract;
import com.android.imepaysdk.presentation.presenter.SplashFragmentPresenterImpl;
import com.android.imepaysdk.presentation.view.activity.IMEPayActivity;
import com.android.imepaysdk.presentation.view.fragment.BaseFragment;

public final class SplashFragment
extends BaseFragment
implements SplashFragmentContract.SplashFragmentViewContract {
    private Context context;
    private SplashFragmentListener caller;
    private SplashFragmentContract splashFragmentContract = new SplashFragmentPresenterImpl(this);
    private ImageView imgViewLogo;
    private ProgressBar progressBar;
    private View progressView;
    private IMEPayActivity.ArgsModel params;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_splash, container, false);
        this.imgViewLogo = (ImageView)view.findViewById(R.id.fragmentSplash_imgViewLogo);
        this.progressBar = (ProgressBar)view.findViewById(R.id.fragmentSplash_prgBarLoading);
        this.progressView = view.findViewById(R.id.fragmentSplash_prgView);
        this.setProgressBarRed();
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.animateLogo();
        String uname = "";
        String password = "";
        String merchantCode = "";
        String merchantUrl = "";
        String amount = "";
        String refId = "";
        String module = "";
        String deliveryUrl = "";
        if (this.params != null) {
            uname = this.params.getUser();
            password = this.params.getPassword();
            merchantCode = this.params.getMerchantCode();
            merchantUrl = this.params.getMerchantUrl();
            amount = this.params.getAmount();
            refId = this.params.getRefId();
            module = this.params.getModule();
            deliveryUrl = this.params.getDeliveryUrl();
        }
        this.splashFragmentContract.validateApplication(uname, password, merchantCode, merchantUrl, module, amount, refId, deliveryUrl);
        super.onViewCreated(view, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
    }

    public void onAttach(Context _context) {
        super.onAttach(this.context);
        this.context = _context;
        try {
            this.caller = (SplashFragmentListener)this.context;
            this.getDataFromActivity(_context);
        }
        catch (ClassCastException e) {
            Log.d((String)"", (String)(this.context.getClass().getSimpleName() + "didn't implement SplashFragmentListener listener"));
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.context = activity;
        try {
            this.caller = (SplashFragmentListener)this.context;
            this.getDataFromActivity((Context)activity);
        }
        catch (ClassCastException e) {
            Log.d((String)"", (String)(this.context.getClass().getSimpleName() + "didn't implement SplashFragmentListener listener"));
        }
    }

    private void getDataFromActivity(Context context) {
        try {
            this.caller = (SplashFragmentListener)context;
            this.params = this.caller.getArguments();
        }
        catch (ClassCastException e) {
            Log.d((String)"", (String)(context.getClass().getSimpleName() + "didn't implement SplashFragmentListener listener"));
        }
    }

    @Override
    public void showMessage(String message) {
        ((IMEPayActivityContract)this.getActivity()).showToast(message);
    }

    @Override
    public void showLoadingDialog(boolean action, String message) {
        if (action) {
            this.progressView.setVisibility(0);
        } else {
            this.progressView.setVisibility(8);
        }
    }

    @Override
    public void onApplicationValidated(String message, int STATUS) {
        switch (STATUS) {
            case 1: {
                this.caller.onSplashProcessCompletion(true, message);
                break;
            }
            case -1: {
                this.caller.onSplashProcessCompletion(false, message);
            }
        }
    }

    public void animateLogo() {
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)this.imgViewLogo, (String)"alpha", (float[])new float[]{1.0f, 0.3f});
        fadeOut.setDuration(1200L);
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat((Object)this.imgViewLogo, (String)"alpha", (float[])new float[]{0.3f, 1.0f});
        fadeIn.setDuration(1500L);
        fadeIn.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        fadeOut.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        final AnimatorSet mAnimationSet = new AnimatorSet();
        mAnimationSet.play((Animator)fadeIn).after((Animator)fadeOut);
        mAnimationSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                mAnimationSet.start();
            }
        });
        mAnimationSet.start();
    }

    private void setProgressBarRed() {
        if (Build.VERSION.SDK_INT < 23) {
            this.progressBar.getIndeterminateDrawable().setColorFilter(this.getResources().getColor(R.color.ime_paycolorPrimary), PorterDuff.Mode.SRC_IN);
        } else {
            this.progressBar.getIndeterminateDrawable().setColorFilter(this.getResources().getColor(R.color.ime_paycolorPrimary, null), PorterDuff.Mode.SRC_IN);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.splashFragmentContract.onFragmentDestroy();
    }

    public static interface SplashFragmentListener
    extends BaseFragmentListener {
        public void onSplashProcessCompletion(boolean var1, String var2);
    }
}

