/*
 * Decompiled with CFR 0.152.
 */
package com.android.imepaysdk.presentation.view.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.android.imepaysdk.R;
import com.android.imepaysdk.presentation.abs.BaseFragmentListener;
import com.android.imepaysdk.presentation.abs.ConfirmationFragmentContract;
import com.android.imepaysdk.presentation.abs.IMEPayActivityContract;
import com.android.imepaysdk.presentation.presenter.ConfirmationFragmentPresenterImpl;
import com.android.imepaysdk.presentation.view.activity.IMEPayActivity;
import com.android.imepaysdk.presentation.view.fragment.BaseFragment;
import com.android.imepaysdk.presentation.view.fragment.OtpValidationFragment;

public final class ConfirmationFragment
extends BaseFragment
implements ConfirmationFragmentContract.ConfirmationFragmentViewContract,
View.OnClickListener {
    OtpValidationFragment.PaymentTransactionListener caller;
    ConfirmationFragmentContract confirmationFragmentContract;
    Context context;
    IMEPayActivity.ArgsModel params;
    Button btnSubmit;
    TextView btnCancel;
    EditText edTxtWalletPin;
    TextView txtAmount;
    TextView txtMerchantName;
    TextView txtMobile;
    TextView cashbackValue;
    private String uname;
    private String password;
    private String msisdn;
    private String pin;
    private String module;
    private String merchantCode;
    private PinTextWatcher pinTextWatcher;
    private RelativeLayout cashbackLayout;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_confirmation, container, false);
        this.txtAmount = (TextView)view.findViewById(R.id.fragmentConfirmation_txtAmount);
        this.txtMerchantName = (TextView)view.findViewById(R.id.fragmentConfirmation_txtMerchantName);
        this.txtMobile = (TextView)view.findViewById(R.id.fragmentConfirmation_txtMobile);
        this.edTxtWalletPin = (EditText)view.findViewById(R.id.fragmentConfirmation_edTxtWalletPin);
        this.btnSubmit = (Button)view.findViewById(R.id.fragmentConfirmation_btnSubmit);
        this.btnCancel = (TextView)view.findViewById(R.id.fragmentConfirmation_btnCancel);
        this.cashbackLayout = (RelativeLayout)view.findViewById(R.id.rlCashbackLayout);
        this.cashbackValue = (TextView)view.findViewById(R.id.tv_cashback);
        this.cashbackLayout.setVisibility(8);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.btnSubmit.setOnClickListener((View.OnClickListener)this);
        this.confirmationFragmentContract = new ConfirmationFragmentPresenterImpl(this);
        this.pinTextWatcher = new PinTextWatcher();
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.txtAmount.setText((CharSequence)("Rs. " + this.params.getAmount()));
        this.txtMerchantName.setText((CharSequence)this.params.getMerchantName());
        this.txtMobile.setText((CharSequence)this.params.getMsisdn());
        this.edTxtWalletPin.requestFocus();
    }

    public void onAttach(Context _context) {
        super.onAttach(this.context);
        this.context = _context;
        this.getDataFromActivity(_context);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.context = activity;
        this.getDataFromActivity((Context)activity);
    }

    private void getDataFromActivity(Context context) {
        try {
            this.caller = (OtpValidationFragment.PaymentTransactionListener)context;
            this.params = this.caller.getArguments();
        }
        catch (ClassCastException e) {
            Log.d((String)"", (String)(context.getClass().getSimpleName() + "didn't implement PaymentTransactionListener listener"));
        }
        this.params = this.caller.getArguments();
    }

    public void onResume() {
        super.onResume();
    }

    public void onStart() {
        super.onStart();
        this.edTxtWalletPin.addTextChangedListener((TextWatcher)this.pinTextWatcher);
    }

    public void onStop() {
        super.onStop();
        this.edTxtWalletPin.removeTextChangedListener((TextWatcher)this.pinTextWatcher);
    }

    @Override
    public void showMessage(String message) {
        ((IMEPayActivityContract)this.getActivity()).showToast(message);
    }

    @Override
    public void showLoadingDialog(boolean action, String message) {
        ((IMEPayActivityContract)this.getActivity()).showProgressBar(action, message);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.fragmentConfirmation_btnSubmit) {
            this.uname = "";
            this.password = "";
            this.msisdn = "";
            this.pin = "";
            this.module = "";
            this.merchantCode = "";
            if (this.params != null) {
                this.uname = this.params.getUser();
                this.password = this.params.getPassword();
                this.msisdn = this.params.getMsisdn();
                this.module = this.params.getModule();
                this.merchantCode = this.params.getMerchantCode();
            }
            this.pin = this.edTxtWalletPin.getText().toString();
            if (this.pin.length() != 4) {
                this.showMessage("Pin must be of four digit length.");
                return;
            }
            this.hideKeyboard();
            this.confirmationFragmentContract.proceedToRequestOTP(this.msisdn, this.pin, this.merchantCode, this.module, this.uname, this.password);
        } else if (view.getId() == R.id.fragmentConfirmation_btnCancel) {
            this.caller.showExitDialog();
        }
    }

    @Override
    public void showPaymentLoadingDialog(boolean action, String message) {
        ((IMEPayActivityContract)this.getActivity()).showProgressBar(action, message);
    }

    @Override
    public void onOTPRecieved(String OtpCode, String responseMessage, int STATUS) {
        if (STATUS == 1) {
            ((OTPRequestListener)this.getActivity()).onOTPRequestCompletion(true, responseMessage, this.pin);
        } else {
            ((OTPRequestListener)this.getActivity()).onOTPRequestCompletion(false, responseMessage, this.pin);
        }
    }

    private void setCashBack() {
        double amount = Double.parseDouble(this.params.getAmount());
        int cashback = 0;
        if (amount > 49.0 && amount <= 124.0) {
            cashback = 10;
        } else if (amount > 124.0 && amount <= 249.0) {
            cashback = 40;
        } else if (amount > 249.0 && amount <= 250.0) {
            cashback = 100;
        }
        if (cashback > 0) {
            this.cashbackLayout.setVisibility(0);
            this.cashbackValue.setText((CharSequence)("Rs. " + cashback));
        }
    }

    private class PinTextWatcher
    implements TextWatcher {
        private PinTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (s.toString().length() == 4) {
                ConfirmationFragment.this.hideKeyboard();
            }
        }
    }

    public static interface OTPRequestListener
    extends BaseFragmentListener {
        public void onOTPRequestCompletion(boolean var1, String var2, String var3);
    }
}

