/*
 * Decompiled with CFR 0.152.
 */
package np.com.madanpokharel.embed.nats;

import de.flapdoodle.embed.process.config.DownloadConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import de.flapdoodle.embed.process.store.ContentHashExtractedFileSetStore;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.store.LocalDownloadCache;
import de.flapdoodle.embed.process.transitions.Directories;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.transitions.ExtractPackage;
import de.flapdoodle.embed.process.transitions.InitTempDirectory;
import de.flapdoodle.embed.process.transitions.PackageOfDistribution;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.transitions.Derive;
import de.flapdoodle.reverse.transitions.Start;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import np.com.madanpokharel.embed.nats.EmbeddedNatsConfig;
import np.com.madanpokharel.embed.nats.NatsPackageResolver;
import np.com.madanpokharel.embed.nats.NatsProcess;
import np.com.madanpokharel.embed.nats.NatsServerConfig;
import np.com.madanpokharel.embed.nats.NatsStarter;
import np.com.madanpokharel.embed.nats.ServerType;

public final class EmbeddedNatsServer {
    private final EmbeddedNatsConfig config;
    private TransitionWalker.ReachedState<NatsProcess> runningProcess;

    public EmbeddedNatsServer(EmbeddedNatsConfig config) {
        Objects.requireNonNull(config, "config cannot be null");
        this.config = config;
    }

    public void startServer() throws Exception {
        this.runningProcess = this.transitions().walker().initState(StateID.of(NatsProcess.class), new Listener[0]);
    }

    public boolean isServerRunning() {
        return !Objects.isNull(this.runningProcess) && ((NatsProcess)((Object)this.runningProcess.current())).isAlive();
    }

    public void stopServer() {
        this.runningProcess.close();
    }

    public int getRunningPort() {
        return this.config.getServerConfig().getPort();
    }

    public String getRunningHost() {
        return this.config.getServerConfig().getHost();
    }

    public String getNatsUrl() {
        return "nats://" + this.getRunningHost() + ":" + this.getRunningPort();
    }

    public String getClusterId() {
        return this.config.getServerConfig().getClusterId();
    }

    public NatsServerConfig getServerConfig() {
        return this.config.getServerConfig();
    }

    private Transitions transitions() {
        NatsPackageResolver resolver = new NatsPackageResolver(this.config.getServerConfig().getServerType());
        Transitions transitions = Transitions.from((Transition[])new Transition[]{InitTempDirectory.withPlatformTempRandomSubDir(), Start.to(EmbeddedNatsConfig.class).providedBy(() -> this.config), Derive.given(EmbeddedNatsConfig.class).state(PersistentDir.class).deriveBy(embeddedNatsConfig -> (PersistentDir)PersistentDir.inUserHome((String)embeddedNatsConfig.artifactStorePath).mapToUncheckedException(RuntimeException::new).get()), Derive.given(TempDir.class).state(ProcessWorkingDir.class).with(Directories.deleteOnTearDown((Function)TempDir.createDirectoryWith((String)"workingDir", (FileAttribute[])new FileAttribute[0]), ProcessWorkingDir::of)), Derive.given(PersistentDir.class).state(DownloadCache.class).deriveBy(storeBaseDir -> new LocalDownloadCache(((Path)storeBaseDir.value()).resolve("archives"))).withTransitionLabel("downloadCache"), Derive.given(PersistentDir.class).state(ExtractedFileSetStore.class).deriveBy(baseDir -> new ContentHashExtractedFileSetStore(((Path)baseDir.value()).resolve(this.config.extractDirectory))).withTransitionLabel("extractedFileSetStore"), Start.to(Name.class).initializedWith((Object)Name.of((String)"nats")).withTransitionLabel("create Name"), Start.to(SupportConfig.class).initializedWith((Object)SupportConfig.builder().name("nats-server").supportUrl("https://github.com/madansp/nats-embedded").messageOnException((clazz, ex) -> "Open a bug report at https://github.com/madansp/nats-embedded").build()).withTransitionLabel("create default"), Start.to(ProcessConfig.class).initializedWith((Object)ProcessConfig.defaults()).withTransitionLabel("create default"), Start.to(ProcessEnv.class).initializedWith((Object)ProcessEnv.of(Collections.emptyMap())).withTransitionLabel("create empty env"), Start.to(Version.class).initializedWith((Object)this.config.getServerConfig().version()).withTransitionLabel("set version"), Derive.given(Name.class).state(ProcessOutput.class).deriveBy(name -> ProcessOutput.builder().output(Processors.silent()).error(Processors.namedConsole((String)("[" + name.value() + " output]"))).commands(Processors.console()).build()).withTransitionLabel("create named console"), Start.to(ProgressListener.class).providedBy(StandardConsoleProgressListener::new).withTransitionLabel("progressListener"), Start.to(ProcessArguments.class).initializedWith((Object)ProcessArguments.of(this.config.getServerConfig().getConfigList())).withTransitionLabel("create arguments"), Start.to(ServerType.class).providedBy(() -> this.config.getServerConfig().getServerType()), Derive.given(Version.class).state(Distribution.class).deriveBy(version -> Distribution.detectFor((Collection)CommonOS.list(), (Version)version)).withTransitionLabel("version + platform"), Start.to(Platform.class).providedBy(() -> Platform.detect((Collection)CommonOS.list())), PackageOfDistribution.with(dist -> Package.builder().archiveType(ArchiveType.ZIP).fileSet(resolver.getExecutableFileSet(dist)).url(this.config.downloadPath + resolver.getPath(dist)).build()), DownloadPackage.builder().downloadConfig((DownloadConfig)DownloadConfig.builder().userAgent(this.config.downloadUserAgent).build()).build(), ExtractPackage.withDefaults().withExtractedFileSetStore(StateID.of(ExtractedFileSetStore.class)), NatsStarter.defaults()});
        return transitions;
    }
}

