/*
 * Decompiled with CFR 0.152.
 */
package np.com.madanpokharel.embed.nats;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.Platform;
import np.com.madanpokharel.embed.nats.ServerType;

final class NatsPackageResolver {
    private final ServerType serverType;

    NatsPackageResolver(ServerType serverType) {
        this.serverType = serverType;
    }

    public String getPath(Distribution distribution) {
        String version = distribution.version().asInDownloadPath();
        String arch = this.getArch(distribution.platform().architecture().bitSize());
        String platform = this.getPlatform(distribution.platform());
        return version + "/" + this.serverType.getServerName() + "-" + version + '-' + platform + '-' + arch + ".zip";
    }

    private String getPlatform(Platform platform) {
        switch (platform.operatingSystem().type()) {
            case OS_X: {
                return "darwin";
            }
            case Linux: {
                return "linux";
            }
            case Windows: {
                return "windows";
            }
        }
        throw new IllegalArgumentException("Unknown platform " + platform);
    }

    private String getArch(BitSize bitSize) {
        String arch;
        if (System.getProperty("os.arch").startsWith("arm")) {
            switch (bitSize) {
                case B32: {
                    arch = "arm7";
                    break;
                }
                case B64: {
                    arch = "arm64";
                    break;
                }
                default: {
                    arch = "arm6";
                    break;
                }
            }
        } else {
            switch (bitSize) {
                case B32: {
                    arch = "386";
                    break;
                }
                case B64: {
                    arch = "amd64";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown bit size " + bitSize);
                }
            }
        }
        return arch;
    }

    FileSet getExecutableFileSet(Distribution distribution) {
        String executableName = this.serverType.getServerName();
        switch (distribution.platform().operatingSystem().type()) {
            case OS_X: 
            case Linux: {
                break;
            }
            case Windows: {
                executableName = executableName + ".exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown platform " + distribution.platform());
            }
        }
        return FileSet.builder().addEntry(FileType.Executable, executableName).build();
    }
}

