/*
 * Decompiled with CFR 0.152.
 */
package np.com.madanpokharel.embed.nats;

import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.net.Net;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import np.com.madanpokharel.embed.nats.NatsStreamingVersion;
import np.com.madanpokharel.embed.nats.NatsVersion;
import np.com.madanpokharel.embed.nats.ServerType;
import org.apache.commons.lang3.StringUtils;

public final class NatsServerConfig {
    private final Version version;
    private final int port;
    private final String host;
    private final String clusterId;
    private final ServerType serverType;
    private final Map<String, String> params = new HashMap<String, String>();

    public NatsServerConfig(Version version, int port, String host, String clusterId, ServerType serverType, Map<String, String> configParams) {
        this.version = version;
        this.port = port;
        this.host = host;
        this.clusterId = clusterId;
        this.serverType = serverType;
        this.params.putAll(configParams);
    }

    public int getPort() {
        return this.port;
    }

    public Version version() {
        return this.version;
    }

    List<String> getConfigList() {
        ArrayList<String> configMap = new ArrayList<String>();
        configMap.add("--port");
        configMap.add(Integer.toString(this.port));
        configMap.add("--addr");
        configMap.add(this.host);
        if (StringUtils.isNotBlank((CharSequence)this.clusterId)) {
            configMap.add("-cid");
            configMap.add(this.clusterId);
        }
        this.params.forEach((k, v) -> {
            configMap.add((String)k);
            if (!v.isEmpty()) {
                configMap.add((String)v);
            }
        });
        return configMap;
    }

    public String getHost() {
        return this.host;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public static class Builder {
        private Version version;
        private int port = 4222;
        private String host = "0.0.0.0";
        private String clusterId;
        private ServerType serverType;
        private final Map<String, String> configParams = new HashMap<String, String>();

        public Builder withRandomPort() {
            try {
                InetAddress localHost = Net.getLocalHost();
                this.port = Net.freeServerPort((InetAddress)localHost);
            }
            catch (IOException ex) {
                throw new RuntimeException("unbale to allocate random port");
            }
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder withServerType(ServerType serverType) {
            this.serverType = serverType;
            return this;
        }

        public Builder withNatsVersion(NatsVersion version) {
            this.version = version;
            return this;
        }

        public Builder withNatsStreamingVersion(NatsStreamingVersion natsStreamingVersion) {
            this.version = natsStreamingVersion;
            return this;
        }

        public Builder withConfigParams(Map<String, String> params) {
            this.configParams.putAll(params);
            return this;
        }

        public Builder withConfigParam(String param, String value) {
            this.configParams.put(param, value);
            return this;
        }

        public Builder withEnableJetStream(String storeDir) {
            this.configParams.put("-js", "");
            this.configParams.put("-sd", storeDir);
            return this;
        }

        public Builder withEnableJetStream() {
            this.configParams.put("-js", "");
            return this;
        }

        public Builder withConfigurationFile(String filePath) {
            this.configParams.put("-c", filePath);
            return this;
        }

        public NatsServerConfig build() {
            if (this.serverType == null) {
                this.serverType = ServerType.NATS;
            }
            if (Objects.isNull(this.version)) {
                this.version = this.serverType == ServerType.NATS ? NatsVersion.LATEST : NatsStreamingVersion.LATEST;
            }
            if (this.serverType == ServerType.NATS) {
                if (StringUtils.isNotBlank((CharSequence)this.clusterId)) {
                    throw new IllegalArgumentException("cluster id is not applicable for nats server");
                }
                if (!(this.version instanceof NatsVersion)) {
                    throw new IllegalArgumentException("version do not match server type");
                }
            }
            if (this.serverType == ServerType.NATS_STREAMING && !(this.version instanceof NatsStreamingVersion)) {
                throw new IllegalArgumentException("version do not match server type");
            }
            return new NatsServerConfig(this.version, this.port, this.host, this.clusterId, this.serverType, this.configParams);
        }
    }
}

