/*
 * Decompiled with CFR 0.152.
 */
package np.com.madanpokharel.embed.nats;

import java.util.Objects;
import np.com.madanpokharel.embed.nats.NatsServerConfig;
import np.com.madanpokharel.embed.nats.ServerType;

public final class EmbeddedNatsConfig {
    final String downloadPath;
    final String downloadUserAgent;
    final String artifactStorePath;
    final String extractDirectory;
    private final NatsServerConfig serverConfig;

    private EmbeddedNatsConfig(String downloadPath, String downloadUserAgent, String artifactStorePath, String extractDirectory, NatsServerConfig serverConfig) {
        this.downloadPath = downloadPath;
        this.downloadUserAgent = downloadUserAgent;
        this.serverConfig = serverConfig;
        this.artifactStorePath = artifactStorePath;
        this.extractDirectory = extractDirectory;
    }

    public static EmbeddedNatsConfig defaultNatsServerConfig() {
        return new Builder().withNatsServerConfig(new NatsServerConfig.Builder().withServerType(ServerType.NATS).withRandomPort().build()).build();
    }

    public static EmbeddedNatsConfig defaultNatsStreamingConfig() {
        return new Builder().withNatsServerConfig(new NatsServerConfig.Builder().withServerType(ServerType.NATS_STREAMING).withRandomPort().build()).build();
    }

    public NatsServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public static class Builder {
        private String downloadUserAgent = "Mozilla/5.0 (compatible; Nats Embedded; +https://github.com/madansp/nats-embedded)";
        private String artifactStorePath = ".embedded-nats";
        private String extractDirectory = "extracted";
        private NatsServerConfig serverConfig;

        public Builder withDownloadUserAgent(String userAgent) {
            this.downloadUserAgent = userAgent;
            return this;
        }

        public Builder withArtifactStorePath(String artifactStorePath) {
            this.artifactStorePath = artifactStorePath;
            return this;
        }

        public Builder withExtractDirectory(String extractDirectory) {
            this.extractDirectory = extractDirectory;
            return this;
        }

        public Builder withNatsServerConfig(NatsServerConfig serverConfig) {
            this.serverConfig = serverConfig;
            return this;
        }

        public EmbeddedNatsConfig build() {
            Objects.requireNonNull(this.serverConfig, "Nats server config cannot be null");
            String downloadPath = "https://github.com/nats-io/" + this.serverConfig.getServerType().getServerName() + "/releases/download/";
            return new EmbeddedNatsConfig(downloadPath, this.downloadUserAgent, this.artifactStorePath, this.extractDirectory, this.serverConfig);
        }
    }
}

