/*
 * Decompiled with CFR 0.152.
 */
package np.com.madanpokharel.embed.nats;

import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ListeningStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.ReaderProcessor;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.SuccessMessageLineListener;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.embed.process.types.RunningProcessImpl;
import de.flapdoodle.os.Platform;
import de.flapdoodle.types.Try;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import np.com.madanpokharel.embed.nats.ServerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunningNatsProcess
extends RunningProcessImpl {
    private static Logger LOGGER = LoggerFactory.getLogger(RunningNatsProcess.class);
    private final String commandName;
    private final SupportConfig supportConfig;
    private final Platform platform;
    private final StreamProcessor commandOutput;
    private final int natsProcessId;
    private boolean shutDownCommandAlreadyExecuted = false;

    protected RunningNatsProcess(String commandName, ProcessControl process, Path pidFile, Runnable onStop, SupportConfig supportConfig, Platform platform, StreamProcessor commandOutput, int natsProcessId, ServerType serverType) {
        super(process, pidFile, 5000L, onStop);
        this.commandName = commandName;
        this.supportConfig = supportConfig;
        this.platform = platform;
        this.commandOutput = commandOutput;
        this.natsProcessId = natsProcessId;
    }

    public int stop() {
        try {
            this.stopInternal();
        }
        finally {
            return super.stop();
        }
    }

    private void stopInternal() {
        if (this.isAlive() && !this.sendKillToProcess()) {
            LOGGER.warn("could not stop " + this.commandName + ", try next");
            if (!this.sendTermToProcess()) {
                LOGGER.warn("could not stop " + this.commandName + ", try next");
                if (!this.tryKillToProcess()) {
                    LOGGER.warn("could not stop " + this.commandName + " the second time, try one last thing");
                }
            }
        }
    }

    private long getProcessId() {
        return this.natsProcessId;
    }

    protected boolean sendKillToProcess() {
        return this.getProcessId() > 0L && Processes.killProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected boolean sendTermToProcess() {
        return this.getProcessId() > 0L && Processes.termProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected boolean tryKillToProcess() {
        return this.getProcessId() > 0L && Processes.tryKillProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    static int getNatsProcessId(String output) {
        Pattern pattern = Pattern.compile("\\[\\d+]");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(0);
            return Integer.parseInt(value.replace("[", "").replace("]", ""));
        }
        return -1;
    }

    static <T extends RunningNatsProcess> RunningProcessFactory<T> factory(InstanceFactory<T> instanceFactory, SupportConfig supportConfig, Platform platform, ServerType serverType) {
        return (process, processOutput, pidFile, timeout) -> {
            SuccessMessageLineListener logWatch = SuccessMessageLineListener.of(RunningNatsProcess.successMessage(serverType), RunningNatsProcess.knownFailureMessages(), (String)"error");
            ReaderProcessor output = Processors.connect((Reader)process.getReader(), (StreamProcessor)new ListeningStreamProcessor(StreamToLineProcessor.wrap((StreamProcessor)processOutput.output()), arg_0 -> ((SuccessMessageLineListener)logWatch).inspect(arg_0)));
            ReaderProcessor error = Processors.connect((Reader)process.getError(), (StreamProcessor)new ListeningStreamProcessor(StreamToLineProcessor.wrap((StreamProcessor)processOutput.error()), arg_0 -> ((SuccessMessageLineListener)logWatch).inspect(arg_0)));
            Runnable closeAllOutputs = () -> ReaderProcessor.abortAll((ReaderProcessor[])new ReaderProcessor[]{output, error});
            logWatch.waitForResult(5000L);
            if (logWatch.successMessageFound()) {
                int pid = RunningNatsProcess.getNatsProcessId(logWatch.allLines());
                return instanceFactory.create(process, pidFile, closeAllOutputs, supportConfig, platform, processOutput.commands(), pid, serverType);
            }
            String failureFound = logWatch.errorMessage().isPresent() ? (String)logWatch.errorMessage().get() : logWatch.allLines();
            return (RunningNatsProcess)((Object)((Object)Try.supplier(() -> {
                throw new RuntimeException("Could not start process: " + failureFound);
            }).andFinally(() -> process.stop(timeout)).andFinally(closeAllOutputs).get()));
        };
    }

    private static List<String> successMessage(ServerType serverType) {
        if (serverType == ServerType.NATS) {
            return Collections.singletonList("Server is ready");
        }
        return Arrays.asList("Streaming Server is ready", "----------------------------------");
    }

    private static List<String> knownFailureMessages() {
        return Arrays.asList("(?<error>Error listening on port)", "(?<error>flag provided but not defined)", "(?<error>Error parsing command line:.*)", "(?<error>address already in use)");
    }

    static interface InstanceFactory<T extends RunningNatsProcess> {
        public T create(ProcessControl var1, Path var2, Runnable var3, SupportConfig var4, Platform var5, StreamProcessor var6, int var7, ServerType var8);
    }
}

