/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.ansel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import nu.mine.mosher.gedcom.ansel.AnselCharacterMap;

public class AnselCharsetDetector {
    private static final Set<Integer> forbidden = ((Supplier<Set>)() -> {
        int c;
        HashSet<Integer> s = new HashSet<Integer>();
        for (c = 128; c <= 135; ++c) {
            s.add(c);
        }
        for (c = 144; c <= 159; ++c) {
            s.add(c);
        }
        s.add(160);
        s.add(175);
        for (c = 201; c <= 204; ++c) {
            s.add(c);
        }
        for (c = 208; c <= 223; ++c) {
            s.add(c);
        }
        return Collections.unmodifiableSet(s);
    }).get();
    private static final Set<Integer> strong = ((Supplier<Set>)() -> {
        HashSet<Integer> s = new HashSet<Integer>();
        s.add(161);
        s.add(162);
        s.add(166);
        s.add(177);
        s.add(178);
        s.add(179);
        s.add(185);
        s.add(186);
        return Collections.unmodifiableSet(s);
    }).get();
    private final Map<Integer, Integer> mapForbidden = new TreeMap<Integer, Integer>();
    private int cForbidden;
    private final Map<Integer, Integer> mapAnsel = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> mapStrongAnsel = new TreeMap<Integer, Integer>();
    private int cAnsel;
    private int cAscii;
    private int cTotal;
    private static final int EOF = -1;

    public void handleData(BufferedInputStream stream) throws IOException {
        this.handleData(stream, Integer.MAX_VALUE);
    }

    public void handleData(BufferedInputStream stream, int len) throws IOException {
        while (0 < len--) {
            int b = stream.read();
            if (b == -1) {
                len = 0;
                continue;
            }
            ++this.cTotal;
            if (b < 128) {
                ++this.cAscii;
                continue;
            }
            if (AnselCharacterMap.map.containsKey(b)) {
                this.mapAnsel.merge(b, 1, Integer::sum);
                ++this.cAnsel;
                if (!strong.contains(b)) continue;
                this.mapStrongAnsel.merge(b, 1, Integer::sum);
                continue;
            }
            if (!forbidden.contains(b)) continue;
            this.mapForbidden.merge(b, 1, Integer::sum);
            ++this.cForbidden;
        }
    }

    public boolean detected() {
        return this.cForbidden <= 0 && (1 <= this.mapStrongAnsel.size() || 2 <= this.mapAnsel.size());
    }

    public int getForbiddenFound() {
        return this.cForbidden;
    }

    private int getForbiddenValuesFound() {
        return this.mapForbidden.size();
    }

    public int getAnselFound() {
        return this.cAnsel;
    }

    public int getAnselValuesFound() {
        return this.mapAnsel.size();
    }

    public int getStrongAnselValuesFound() {
        return this.mapStrongAnsel.size();
    }

    public int getAsciiFound() {
        return this.cAscii;
    }

    public int getTotalBytes() {
        return this.cTotal;
    }

    public static void main(String ... args) throws IOException {
        if (args.length <= 0) {
            System.err.println("missing file name argument");
            System.exit(1);
        }
        for (String arg : args) {
            File f = new File(arg).getCanonicalFile();
            if (!f.isFile()) continue;
            BufferedInputStream s = new BufferedInputStream(new FileInputStream(f));
            AnselCharsetDetector detector = new AnselCharsetDetector();
            detector.handleData(s);
            System.out.println(String.format("%s: detected=%b, forbidden=%d/%d, indicative=%d/%d+/%d, ascii=%d, read=%d", f, detector.detected(), detector.getForbiddenValuesFound(), detector.getForbiddenFound(), detector.getAnselValuesFound(), detector.getStrongAnselValuesFound(), detector.getAnselFound(), detector.getAsciiFound(), detector.getTotalBytes()));
        }
    }
}

