/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColorCSS1;
import org.w3c.css.values.CssColorCSS2;
import org.w3c.css.values.CssColorCSS21;
import org.w3c.css.values.CssColorCSS3;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.DeviceCMYK;
import org.w3c.css.values.HSL;
import org.w3c.css.values.HWB;
import org.w3c.css.values.LAB;
import org.w3c.css.values.LCH;
import org.w3c.css.values.RGB;
import org.w3c.css.values.RGBA;

public class CssColor
extends CssValue {
    public static final int type = 3;
    Object color = null;
    RGB rgb = null;
    RGBA rgba = null;
    HSL hsl = null;
    HWB hwb = null;
    LAB lab = null;
    LCH lch = null;
    DeviceCMYK cmyk = null;

    @Override
    public final int getType() {
        return 3;
    }

    public CssColor() {
    }

    public CssColor(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(ac, s);
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.charAt(0) == '#') {
            this.setShortRGBColor(ac, s.toLowerCase());
        } else {
            this.setIdentColor(ac, s);
        }
    }

    @Override
    public Object get() {
        if (this.color != null) {
            return this.color;
        }
        return this.rgb;
    }

    public String toString() {
        if (this.color != null) {
            return this.color.toString();
        }
        if (this.rgb != null) {
            return this.rgb.toString();
        }
        if (this.rgba != null) {
            return this.rgba.toString();
        }
        if (this.hsl != null) {
            return this.hsl.toString();
        }
        if (this.hwb != null) {
            return this.hwb.toString();
        }
        if (this.lab != null) {
            return this.lab.toString();
        }
        if (this.lch != null) {
            return this.lch.toString();
        }
        if (this.cmyk != null) {
            return this.cmyk.toString();
        }
        return "*invalid*";
    }

    public void setRGBColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        boolean isCss3;
        boolean bl = isCss3 = ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0;
        if (!isCss3) {
            this.setLegacyRGBColor(ac, exp);
        } else {
            this.setModernRGBColor(ac, exp);
        }
    }

    public void setLegacyRGBColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGB();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                this.rgb.setPercent(false);
                this.rgb.setRed(ac, val);
                break;
            }
            case 4: {
                this.rgb.setPercent(true);
                this.rgb.setRed(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                this.rgb.setGreen(ac, val);
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                this.rgb.setGreen(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                this.rgb.setBlue(ac, val);
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                this.rgb.setBlue(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setModernRGBColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        block30: {
            block32: {
                char op;
                CssValue val;
                block31: {
                    boolean separator_space;
                    val = exp.getValue();
                    op = exp.getOperator();
                    this.color = null;
                    this.rgba = new RGBA("rgb");
                    boolean bl = separator_space = op == ' ';
                    if (val == null || !separator_space && op != ',') {
                        throw new InvalidParamException("invalid-color", ac);
                    }
                    switch (val.getType()) {
                        case 5: {
                            this.rgba.setPercent(false);
                            this.rgba.setRed(ac, val);
                            break;
                        }
                        case 4: {
                            this.rgba.setPercent(true);
                            this.rgba.setRed(ac, val);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("rgb", val, ac);
                        }
                    }
                    exp.next();
                    val = exp.getValue();
                    op = exp.getOperator();
                    if (val == null || separator_space && op != ' ' || !separator_space && op != ',') {
                        throw new InvalidParamException("invalid-color", ac);
                    }
                    switch (val.getType()) {
                        case 5: {
                            if (this.rgba.isPercent()) {
                                throw new InvalidParamException("percent", val, ac);
                            }
                            this.rgba.setGreen(ac, val);
                            break;
                        }
                        case 4: {
                            if (!this.rgba.isPercent()) {
                                throw new InvalidParamException("integer", val, ac);
                            }
                            this.rgba.setGreen(ac, val);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("rgb", val, ac);
                        }
                    }
                    exp.next();
                    val = exp.getValue();
                    op = exp.getOperator();
                    if (val == null) {
                        throw new InvalidParamException("invalid-color", ac);
                    }
                    switch (val.getType()) {
                        case 5: {
                            if (this.rgba.isPercent()) {
                                throw new InvalidParamException("percent", val, ac);
                            }
                            this.rgba.setBlue(ac, val);
                            break;
                        }
                        case 4: {
                            if (!this.rgba.isPercent()) {
                                throw new InvalidParamException("integer", val, ac);
                            }
                            this.rgba.setBlue(ac, val);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("rgb", val, ac);
                        }
                    }
                    exp.next();
                    if (exp.end()) break block30;
                    if (op != ',' || separator_space) break block31;
                    val = exp.getValue();
                    switch (val.getType()) {
                        case 4: 
                        case 5: {
                            this.rgba.setAlpha(ac, val);
                            break block32;
                        }
                        default: {
                            throw new InvalidParamException("rgb", val, ac);
                        }
                    }
                }
                if (op != ' ') {
                    throw new InvalidParamException("invalid-color", ac);
                }
                val = exp.getValue();
                op = exp.getOperator();
                if (val.getType() != 14) {
                    throw new InvalidParamException("rgb", val, ac);
                }
                if (op != ' ') {
                    throw new InvalidParamException("invalid-color", ac);
                }
                exp.next();
                if (exp.end()) {
                    throw new InvalidParamException("rgb", exp.getValue(), ac);
                }
                val = exp.getValue();
                switch (val.getType()) {
                    case 4: 
                    case 5: {
                        this.rgba.setAlpha(ac, val);
                        break;
                    }
                    default: {
                        throw new InvalidParamException("rgb", val, ac);
                    }
                }
            }
            exp.next();
            if (!exp.end()) {
                throw new InvalidParamException("rgb", exp.getValue(), ac);
            }
        }
    }

    public void setHSLColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        block20: {
            block22: {
                char op;
                CssValue val;
                block21: {
                    boolean separator_space;
                    if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("hsl(").append(exp.toStringFromStart()).append(')');
                        throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
                    }
                    val = exp.getValue();
                    op = exp.getOperator();
                    this.color = null;
                    this.hsl = new HSL();
                    boolean bl = separator_space = op == ' ';
                    if (val == null || !separator_space && op != ',') {
                        throw new InvalidParamException("invalid-color", ac);
                    }
                    switch (val.getType()) {
                        case 5: 
                        case 7: {
                            this.hsl.setHue(ac, val);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("rgb", val, ac);
                        }
                    }
                    exp.next();
                    val = exp.getValue();
                    op = exp.getOperator();
                    if (val == null || separator_space && op != ' ' || !separator_space && op != ',') {
                        throw new InvalidParamException("invalid-color", ac);
                    }
                    if (val.getType() != 4) {
                        exp.starts();
                        throw new InvalidParamException("rgb", val, ac);
                    }
                    this.hsl.setSaturation(ac, val);
                    exp.next();
                    val = exp.getValue();
                    op = exp.getOperator();
                    if (val == null) {
                        throw new InvalidParamException("invalid-color", ac);
                    }
                    if (val.getType() != 4) {
                        exp.starts();
                        throw new InvalidParamException("rgb", val, ac);
                    }
                    this.hsl.setLightness(ac, val);
                    exp.next();
                    if (exp.end()) break block20;
                    if (op != ',' || separator_space) break block21;
                    val = exp.getValue();
                    switch (val.getType()) {
                        case 4: 
                        case 5: {
                            this.hsl.setAlpha(ac, val);
                            break block22;
                        }
                        default: {
                            throw new InvalidParamException("rgb", val, ac);
                        }
                    }
                }
                if (op != ' ') {
                    throw new InvalidParamException("invalid-color", ac);
                }
                val = exp.getValue();
                op = exp.getOperator();
                if (val.getType() != 14) {
                    throw new InvalidParamException("rgb", val, ac);
                }
                if (op != ' ') {
                    throw new InvalidParamException("invalid-color", ac);
                }
                exp.next();
                if (exp.end()) {
                    throw new InvalidParamException("rgb", exp.getValue(), ac);
                }
                val = exp.getValue();
                switch (val.getType()) {
                    case 4: 
                    case 5: {
                        this.hsl.setAlpha(ac, val);
                        break;
                    }
                    default: {
                        throw new InvalidParamException("rgb", val, ac);
                    }
                }
            }
            exp.next();
            if (!exp.end()) {
                throw new InvalidParamException("rgb", exp.getValue(), ac);
            }
        }
    }

    public void setShortRGBColor(ApplContext ac, String s) throws InvalidParamException {
        int b;
        int g;
        int r;
        boolean hasAlpha = false;
        boolean isCss3 = ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0;
        int idx = 1;
        int a = 0;
        switch (s.length()) {
            case 5: {
                a = Character.digit(s.charAt(4), 16);
                if (!isCss3 || a < 0) {
                    throw new InvalidParamException("rgb", s, ac);
                }
                hasAlpha = true;
            }
            case 4: {
                r = Character.digit(s.charAt(idx++), 16);
                g = Character.digit(s.charAt(idx++), 16);
                b = Character.digit(s.charAt(idx++), 16);
                if (r >= 0 && g >= 0 && b >= 0) break;
                throw new InvalidParamException("rgb", s, ac);
            }
            case 9: {
                a = Character.digit(s.charAt(7), 16);
                int v = Character.digit(s.charAt(8), 16);
                if (!isCss3 || a < 0 || v < 0) {
                    throw new InvalidParamException("rgb", s, ac);
                }
                a = (a << 4) + v;
                hasAlpha = true;
            }
            case 7: {
                r = Character.digit(s.charAt(idx++), 16);
                int v = Character.digit(s.charAt(idx++), 16);
                if (r < 0 || v < 0) {
                    throw new InvalidParamException("rgb", s, ac);
                }
                r = (r << 4) + v;
                g = Character.digit(s.charAt(idx++), 16);
                v = Character.digit(s.charAt(idx++), 16);
                if (g < 0 || v < 0) {
                    throw new InvalidParamException("rgb", s, ac);
                }
                g = (g << 4) + v;
                b = Character.digit(s.charAt(idx++), 16);
                v = Character.digit(s.charAt(idx++), 16);
                if (b < 0 || v < 0) {
                    throw new InvalidParamException("rgb", s, ac);
                }
                b = (b << 4) + v;
                break;
            }
            default: {
                throw new InvalidParamException("rgb", s, ac);
            }
        }
        this.color = null;
        if (hasAlpha) {
            this.rgba = new RGBA(isCss3, r, g, b, a);
            this.rgba.setRepresentationString(s);
        } else {
            this.rgb = new RGB(isCss3, r, g, b);
            this.rgb.setRepresentationString(s);
        }
    }

    protected void setIdentColor(ApplContext ac, String s) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        switch (ac.getCssVersion()) {
            case CSS1: {
                this.rgb = CssColorCSS1.getRGB(lower_s);
                if (this.rgb == null) {
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS2: {
                this.rgb = CssColorCSS2.getRGB(lower_s);
                if (this.rgb == null) {
                    this.color = CssColorCSS2.getSystem(lower_s);
                    if (this.color != null) break;
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS21: {
                this.rgb = CssColorCSS21.getRGB(lower_s);
                if (this.rgb == null) {
                    this.color = CssColorCSS21.getSystem(lower_s);
                    if (this.color != null) break;
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS3: 
            case CSS_2015: 
            case CSS: {
                this.rgb = CssColorCSS3.getRGB(lower_s);
                if (this.rgb != null) {
                    this.color = lower_s;
                    break;
                }
                this.rgba = CssColorCSS3.getRGBA(lower_s);
                if (this.rgba != null) {
                    this.color = lower_s;
                    break;
                }
                this.color = CssColorCSS3.getSystem(lower_s);
                if (this.color != null) {
                    ac.getFrame().addWarning("deprecated", s);
                    break;
                }
                this.color = CssColorCSS3.getIdentColor(lower_s);
                if (this.color != null) break;
                throw new InvalidParamException("value", s, "color", ac);
            }
            default: {
                throw new InvalidParamException("value", s, "color", ac);
            }
        }
    }

    @Override
    public boolean equals(Object cssColor) {
        if (!(cssColor instanceof CssColor)) {
            return false;
        }
        CssColor otherColor = (CssColor)cssColor;
        if (this.color != null && otherColor.color != null) {
            return this.color.equals(otherColor.color);
        }
        if (this.rgb != null && otherColor.rgb != null) {
            return this.rgb.equals(otherColor.rgb);
        }
        if (this.rgba != null && otherColor.rgba != null) {
            return this.rgba.equals(otherColor.rgba);
        }
        if (this.hsl != null && otherColor.hsl != null) {
            return this.hsl.equals(otherColor.hsl);
        }
        if (this.hwb != null && otherColor.hwb != null) {
            return this.hwb.equals(otherColor.hwb);
        }
        if (this.lab != null && otherColor.lab != null) {
            return this.lab.equals(otherColor.lab);
        }
        if (this.lch != null && otherColor.lch != null) {
            return this.lch.equals(otherColor.lch);
        }
        if (this.cmyk != null && otherColor.cmyk != null) {
            return this.cmyk.equals(otherColor.cmyk);
        }
        return false;
    }

    public void setATSCRGBAColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        this.rgba = new RGBA("atsc-rgba");
        this.__setRGBAColor(ac, exp, this.rgba);
    }

    public void setRGBAColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("rgba(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.setModernRGBColor(ac, exp);
    }

    private void __setRGBAColor(ApplContext ac, CssExpression exp, RGBA rgba) throws InvalidParamException {
        this.color = null;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                rgba.setRed(ac, val);
                rgba.setPercent(false);
                break;
            }
            case 4: {
                rgba.setRed(ac, val);
                rgba.setPercent(true);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("percent", val, ac);
                }
                rgba.setGreen(ac, val);
                break;
            }
            case 4: {
                if (!rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("integer", val, ac);
                }
                rgba.setGreen(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("percent", val, ac);
                }
                rgba.setBlue(ac, val);
                break;
            }
            case 4: {
                if (!rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("integer", val, ac);
                }
                rgba.setBlue(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                rgba.setAlpha(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
    }

    public void setHWBColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("hwb(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.hwb = new HWB();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ' ') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: 
            case 7: {
                this.hwb.setHue(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ' ') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hwb.setWhiteness(ac, val);
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ' ' && exp.getRemainingCount() > 1) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hwb.setBlackness(ac, val);
        this.hwb.normalize();
        exp.next();
        if (!exp.end()) {
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            val = exp.getValue();
            op = exp.getOperator();
            if (val.getType() != 14) {
                throw new InvalidParamException("rgb", val, ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            exp.next();
            val = exp.getValue();
            if (val == null) {
                throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
            }
            switch (val.getType()) {
                case 4: 
                case 5: {
                    this.hwb.setAlpha(ac, val);
                    break;
                }
                default: {
                    exp.starts();
                    throw new InvalidParamException("rgb", val, ac);
                }
            }
            exp.next();
        }
        if (!exp.end()) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.toStringFromStart(), ac);
        }
    }

    public void setLABColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("lab(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.lab = new LAB();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ' ') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                this.lab.setL(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ' ') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.lab.setA(ac, val);
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.lab.setB(ac, val);
        exp.next();
        if (!exp.end()) {
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            val = exp.getValue();
            op = exp.getOperator();
            if (val.getType() != 14) {
                throw new InvalidParamException("rgb", val, ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            exp.next();
            val = exp.getValue();
            if (val == null) {
                throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
            }
            switch (val.getType()) {
                case 4: 
                case 5: {
                    this.lab.setAlpha(ac, val);
                    break;
                }
                default: {
                    exp.starts();
                    throw new InvalidParamException("rgb", val, ac);
                }
            }
            exp.next();
        }
        if (!exp.end()) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.toStringFromStart(), ac);
        }
    }

    public void setGrayColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("gray(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.lab = new LAB();
        this.lab.setGray(true);
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                this.lab.setL(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        CssNumber n = new CssNumber();
        n.setValue(BigDecimal.ZERO);
        this.lab.setA(ac, n);
        this.lab.setB(ac, n);
        exp.next();
        if (!exp.end()) {
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            val = exp.getValue();
            op = exp.getOperator();
            if (val.getType() != 14) {
                throw new InvalidParamException("rgb", val, ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            exp.next();
            val = exp.getValue();
            if (val == null) {
                throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
            }
            switch (val.getType()) {
                case 4: 
                case 5: {
                    this.lab.setAlpha(ac, val);
                    break;
                }
                default: {
                    exp.starts();
                    throw new InvalidParamException("rgb", val, ac);
                }
            }
            exp.next();
        }
        if (!exp.end()) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.toStringFromStart(), ac);
        }
    }

    public void setLCHColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("lch(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.lch = new LCH();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ' ') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                this.lch.setL(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ' ') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.lch.setC(ac, val);
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
        }
        if (val.getType() != 5) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.lch.setH(ac, val);
        exp.next();
        if (!exp.end()) {
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            val = exp.getValue();
            op = exp.getOperator();
            if (val.getType() != 14) {
                throw new InvalidParamException("rgb", val, ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("invalid-color", ac);
            }
            exp.next();
            val = exp.getValue();
            if (val == null) {
                throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
            }
            switch (val.getType()) {
                case 4: 
                case 5: {
                    this.lch.setAlpha(ac, val);
                    break;
                }
                default: {
                    exp.starts();
                    throw new InvalidParamException("rgb", val, ac);
                }
            }
            exp.next();
        }
        if (!exp.end()) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.toStringFromStart(), ac);
        }
    }

    public void setDeviceCMYKColor(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("device-cmyk(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.cmyk = new DeviceCMYK();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        boolean gotFallback = false;
        if (val == null || op != ' ') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                this.cmyk.setC(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ' ') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                this.cmyk.setM(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                this.cmyk.setY(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                this.cmyk.setK(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (!exp.end()) {
            if (op == ' ') {
                val = exp.getValue();
                op = exp.getOperator();
                if (val.getType() != 14) {
                    throw new InvalidParamException("rgb", val, ac);
                }
                if (op != ' ') {
                    throw new InvalidParamException("invalid-color", ac);
                }
                exp.next();
                val = exp.getValue();
                if (val == null) {
                    throw new InvalidParamException("invalid-color", exp.toStringFromStart(), ac);
                }
                switch (val.getType()) {
                    case 4: 
                    case 5: {
                        this.cmyk.setAlpha(ac, val);
                        break;
                    }
                    default: {
                        exp.starts();
                        throw new InvalidParamException("rgb", val, ac);
                    }
                }
                op = exp.getOperator();
                exp.next();
            }
            if (op == ',') {
                if (exp.end()) {
                    throw new InvalidParamException("rgb", exp.toStringFromStart(), ac);
                }
                val = exp.getValue();
                this.cmyk.setFallbackColor(ac, val);
                exp.next();
            }
        }
        if (!exp.end()) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.toStringFromStart(), ac);
        }
    }
}

