/* CssParser.java */
/* Generated By:JavaCC: Do not edit this line. CssParser.java */
package org.w3c.css.parser.analyzer;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.net.URL;

import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssAttr;
import org.w3c.css.values.CssBracket;
import org.w3c.css.values.CssCalc;
import org.w3c.css.values.CssClamp;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssComparator;
import org.w3c.css.values.CssFlexibleLength;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssHashIdent;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssImage;
import org.w3c.css.values.CssMax;
import org.w3c.css.values.CssMin;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssSwitch;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssUnicodeRange;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssRatio;
import org.w3c.css.values.CssSemitone;
import org.w3c.css.values.CssTypes;
import org.w3c.css.values.CssVolume;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.AtRule;
import org.w3c.css.atrules.svg.AtRuleColorProfile;
import org.w3c.css.atrules.css.AtRuleCounterStyle;
import org.w3c.css.atrules.css.AtRuleFontFace;
import org.w3c.css.atrules.css.AtRuleKeyframes;
import org.w3c.css.atrules.css.AtRuleMedia;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.atrules.css.media.MediaRangeFeature;
import org.w3c.css.atrules.css.AtRulePage;
import org.w3c.css.atrules.css.AtRulePhoneticAlphabet;
import org.w3c.css.atrules.css.AtRulePreference;
import org.w3c.css.atrules.css.AtRuleSupports;
import org.w3c.css.atrules.css.supports.SupportsFeature;
import org.w3c.css.atrules.css.AtRuleViewport;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.util.Util;

import org.w3c.css.selectors.AdjacentSiblingSelector;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ChildSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.DescendantSelector;
import org.w3c.css.selectors.GeneralSiblingSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;

/**
 * A CSS parser  
 *
 * @author Philippe Le Hegaret, Sijtsche Smeman, Yves Lafon
 */
public abstract class CssParser implements CssParserConstants {

    private static char hexdigits[] = { '0', '1', '2', '3',
                                        '4', '5', '6', '7',
                                        '8', '9', 'a', 'b',
                                        'c', 'd', 'e', 'f' };
    // the current atRule
    protected AtRule atRule;
    protected boolean mediaDeclaration = false;

    /**
     * The URL of the document
     */
    protected URL url;

    protected ApplContext ac;

    protected boolean incompatible_error;

    /**
     * The current context recognized by the parser (for errors).
     */
    protected ArrayList<CssSelectors> currentContext;

    /**
     * The current property recognized by the parser (for errors).
     */
    protected String currentProperty;

    /**
     * <code>true</code> if the parser should recognized Aural properties, 
     * <code>false</code> otherwise.
     */
    protected boolean mode;

    /**
     * <code>true</code> if the parser had recognize a rule,
     * <code>false</code> otherwise.
     */
    protected boolean markRule;

    private boolean reinited = false;
    private boolean charsetdeclared = false;

    // to be able to remove a ruleset if the selector is not valid
    protected boolean validSelector = true;

    /**
     * The ac for handling errors and warnings.
     * 
     * @param ac the new ac for the parser.
     */
    public final void setApplContext(ApplContext ac) {
        this.ac = ac;
    }

    /**
     * Set the attribute atRule
     *
     * @param atRule the new value for the attribute
     */
    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    /**
     * Set the attribute mediaDeclaration
     *
     * @param mediadeclaration indicator if in a media expression list or not
     */
    public void setMediaDeclaration(boolean mediadeclaration) {
        this.mediaDeclaration = mediadeclaration;
    }

    /**
     * Returns the attribute mediaDeclaration
     *
     * @return the value of the attribute
     */
    public boolean hasMediaDeclaration() {
        return mediaDeclaration;
    }

    /**
     * Returns the attribute atRule
     *
     * @return the value of the attribute
     */
    public AtRule getAtRule() {
        return atRule;
    }

    /**
     * Reinitialized the parser.
     *
     * @param stream the stream data to parse.
     * @param ac  the new ac to use for parsing.
     */
    public void ReInitWithAc(InputStream stream, ApplContext ac,
                             String charset)
    {
        InputStream is = /*new  CommentSkipperInputStream(stream);*/stream;
        if (charset == null) {
            charset = "iso-8859-1";
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, charset);
        } catch (UnsupportedEncodingException uex) {
            isr = new InputStreamReader(is);
        }
        // reinit, it can not happen...
        // ...in theory ;)
        ReInit(isr);
        markRule = false;
        reinited = true;
        setApplContext(ac);
    }

    /* utilities for a parser */

    /**
     * Call by the import statement.
     *
     * @param url  The style sheet where this import statement appears.
     * @param file the file name in the import
     */
    public abstract void handleImport(URL url, String file,
                                      boolean is_url, AtRuleMedia media);

    /**
     * Call by the namespace declaration statement.
     *
     * @param url  The style sheet where this namespace statement appears.
     * @param file the file/url name in the namespace declaration
     */
    public abstract void handleNamespaceDeclaration(URL url, String prefix,
                                                    String file,
                                                    boolean is_url);

    /**
     * Call by the at-rule statement.
     *
     * @param ident  The ident for this at-rule (for example: 'font-face')
     * @param string The string associate to this at-rule
     * @see          org.w3c.css.parser.analyzer.Couple
     */
    public abstract void handleAtRule(String ident, String string);

    /* added by Sijtsche Smeman */
    public abstract void addCharSet(String charset) throws ParseException;
    public abstract void newAtRule(AtRule atRule);
    public abstract void endOfAtRule();
    public abstract void setImportant(boolean important);
    public abstract void setSelectorList(ArrayList<CssSelectors> selectors);
    public abstract void addProperty(ArrayList<CssProperty> properties);
    public abstract void endOfRule();
    public abstract void removeThisRule();
    public abstract void removeThisAtRule();

    /**
     * Assign an expression to a property.  This function create a new property
     * with <code>property</code> and assign to it the expression with the
     * importance. Don't forget to set informations too.
     * <p>
     * A subclass must provide an implementation of this method. 
     *
     * @param  property  the name of the property
     * @param  values    the expression representation of values
     * @param  important <code>true</code> if values are important
     *
     * @return           <code>null</code>or a property
     * 
     * @see              org.w3c.css.properties.css.CssProperty
     */
    public abstract CssProperty handleDeclaration(String property,
                                                  CssExpression values,
                                                  boolean important)
        throws InvalidParamException;

    /**
     * Assign an expression to a mediafeature.
     * This function create a new mediafeature
     * with <code>mediaFeature</code> and assign to it the expression.
     * <p>
     * A subclass must provide an implementation of this method.
     *
     * @param  mediaFeature  the name of the media feature
     * @param  expr          the expression representation of values
     *
     * @return           <code>null</code>or a property
     *
     * @see              org.w3c.css.properties.css.CssProperty
     */
    public abstract MediaFeature handleMediaFeature(AtRuleMedia rule,
                                                    String mediaFeature,
                                                                            CssExpression expr)
               throws InvalidParamException;



    /**
     * Adds a ArrayList of properties to a selector.
     * <p>
     * A subclass must provide an implementation of this method. 
     *
     * @param selector     the selector
     * @param declarations Properties to associate with contexts
     */
    public abstract void handleRule(CssSelectors selector,
                                    ArrayList<CssProperty> declarations);

    /*Added by Sijtsche Smeman */

    /**
     * Returns the source file of the style sheet
     */
    public final String getSourceFile() {
        return getURL().toString();
    }

    /**
     * Returns the current line in the style sheet
     */
    public final int getLine() {
        //return token.beginLine;
        return 0;
    }

    /**
     * Returns the beginLine in the style sheet
     */
    public final int getBeginLine() {
        return token.beginLine;
    }

    /**
     * Returns the beginColumn in the style sheet
     */
    public final int getBeginColumn() {
        return token.beginColumn;
    }

    /**
     * Returns the endLine in the style sheet
     */
    public final int getEndLine() {
        return token.endLine;
    }

    /**
     * Returns the endColumn in the style sheet
     */
    public final int getEndColumn() {
        return token.endColumn;
    }

    /**
     * Set the URL of the style sheet.
     *
     * @param url The URL for the style sheet
     */
    public final void setURL(URL url) {
        this.url = url;
    }

    public final URL getURL() {
        return url;
    }

    /**
     * Return the next selector from the inputstream
     */
    public CssSelectors parseSelector() throws ParseException {
            return externalSelector();
    }

    /**
     * Return the next @media rule from the inputstream
     */
    public AtRuleMedia parseMediaDeclaration()  throws ParseException {
        AtRuleMedia newRule = AtRuleMedia.getInstance(ac.getCssVersion());
            mediaquerylist(newRule);
            return newRule;
    }
    /*
     * Add a value to an expression
     */
    private void setValue(CssValue v, CssExpression expr,
                          char operator, Token n, int token)
        throws ParseException {

        if ( token == FUNCTION ) {
            if ( v.getType() == CssTypes.CSS_FUNCTION ) {
                CssFunction f = (CssFunction) v;
                if (f.getParameters().hasVendorExtensions()) {
                    expr.markVendorExtension();
                }
                if (f.getParameters().hasCssHack()) {
                    expr.markCssHack();
                }
            }
        }
        if (n != null) {
            if (ac.getCssVersion() == CssVersion.CSS1 &&
                                          (n.image).equals("inherit")) {
                    incompatible_error = true;
            }
            String val = addOperator(operator, n.image);

            if (n.kind == CssParserConstants.IDENT) {
                String s = convertIdent(val);
            if ('-' == s.charAt(0)) {
                expr.markVendorExtension();
            }
                    v.set(convertIdent(val), ac);
            } else if (n.kind == CssParserConstants.STRING) {
                    v.set(val, ac);
            } else {
                    v.set(val, ac);
            }
        }
        expr.addValue(v);
    }

    /*
     * Error control
     */
    private void addError(Exception e, String skippedText) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setSkippedString(skippedText);
        ex.setProperty(currentProperty);
        ex.setContexts(currentContext);
        CssError error = new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(), ex);
        ac.getFrame().addError(error);
    }

    /*
     * Error control 2
     */
    private void addError(Exception e, CssExpression exp) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }

        //	if ((exp != null) && (exp.getCount() != 0)) {
        CssParseException ex = new CssParseException(e);
        ex.setExp(exp);
        ex.setProperty(currentProperty);
        ex.setContexts(currentContext);
        CssError error = new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(), ex);
        ac.getFrame().addError(error);
        //	}
    }

    private void addParseError(ParseException e, String skipped) {
          if (Util.onDebug) {
              System.err.println(e.getMessage());
              e.printStackTrace();
          }
          CssErrorToken err = new CssErrorToken(e, skipped);
          ac.getFrame().addError(err);
    }

    private static String addOperator(char operator, String value) {
        return (' ' == operator) ? value : operator+value;
    }

//<DEFAULT, IN_COMMENT>
//TOKEN :
//{ /* avoid token manager error */
//   < UNKNOWN : ~[] >
//}

/*
 * The grammar of CSS2
 */

/**
 * The main entry for the parser.
 *
 * @exception ParseException exception during the parse
 */
  final public void parserUnit() throws ParseException {Token n = null;
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HTMLSTARTTAG:
        case HTMLENDTAG:{
          ;
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HTMLSTARTTAG:{
          n = jj_consume_token(HTMLSTARTTAG);
          break;
          }
        case HTMLENDTAG:{
          n = jj_consume_token(HTMLENDTAG);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
addError (new ParseException(ac.getMsg().getString("generator.dontmixhtml")), n.image);
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CHARSET_SYM:{
          ;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        charset();
      }
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          ;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          break label_4;
        }
        importDeclaration();
        ignoreStatement();
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAMESPACE_SYM:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
        namespaceDeclaration();
        ignoreStatement();
      }
      afterImportDeclaration();
      jj_consume_token(0);
    } catch (TokenMgrError err) {
addError (new ParseException(ac.getMsg().getString("generator.unrecognize")),
            err.getMessage());
    }
  }

  final public Token ident() throws ParseException {Token n = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
      break;
      }
    case AND:{
      n = jj_consume_token(AND);
      break;
      }
    case OR:{
      n = jj_consume_token(OR);
      break;
      }
    case NOT:{
      n = jj_consume_token(NOT);
      break;
      }
    case ONLY:{
      n = jj_consume_token(ONLY);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

  final public void charset() throws ParseException {Token n = null;
    Token charsetToken = null;
    Token space1Token = null;
    Token space2Token = null;
    Token semicolonToken = null;
    int nb_S = 0;
    CssVersion version = ac.getCssVersion();
    try {
      charsetToken = jj_consume_token(CHARSET_SYM);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          break label_6;
        }
        space1Token = jj_consume_token(S);
nb_S++;
      }
      n = jj_consume_token(STRING);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_7;
        }
        space2Token = jj_consume_token(S);
      }
      semicolonToken = jj_consume_token(SEMICOLON);
if (charsetdeclared && !reinited) {
                    {if (true) throw new ParseException(
                                     ac.getMsg().getString("parser.charset"));}
                }
                // the @charset must be at the beginning of the document
                if(charsetToken.beginLine != 1 ||
                   charsetToken.beginColumn != 1) {
                    {if (true) throw new ParseException(
                                  ac.getMsg().getString("parser.charset"));}
                }
                if (version == CssVersion.CSS1) {
                    {if (true) throw new ParseException(ac.getMsg().getString(
                                                         "parser.charsetcss1"));}
                }
                // stricter rule for CSS21 and soon for CSS3
                // if equal of above CSS21
                if (version.compareTo(CssVersion.CSS21) >= 0) {
                    // single space before
                    // case sensitive
                    // no space before ;
                    // no comments
                    // string must start with "
                    if ( (nb_S != 1) ||
                         (!"@charset".equals(charsetToken.image)) ||
                         (!" ".equals(space1Token.image)) ||
                         (space2Token != null &&
                          !"".equals(space2Token.image)) ||
                         (space1Token.specialToken != null) ||
                         (n.specialToken != null) ||
                         (semicolonToken.specialToken != null) ||
                         (n.image.charAt(0) != '\"')
                        ) {
                        {if (true) throw new ParseException(ac.getMsg().getString(
                                                     "parser.charsetspecial"));}
                    }
                }
                if (!charsetdeclared) {
                    addCharSet(n.image.substring(1, n.image.length()-1));
                    charsetdeclared = true;
                } else {
                    reinited = false;
                }
    } catch (Exception e) {
String skip = charsetToken +
            ((space1Token == null) ? "" : space1Token.image) +
            n +
            ((space2Token == null) ? "" : space2Token.image) +
            ";";
        addError(e, skip);
    }
  }

  final public void nested_at_rules() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MEDIA_SYM:{
      media();
      break;
      }
    case PAGE_SYM:{
      page();
      break;
      }
    case FONT_FACE_SYM:{
      fontFace();
      break;
      }
    case KEYFRAMES_SYM:{
      keyframes();
      break;
      }
    case PREF_SYM:{
      preference();
      break;
      }
    case VIEWPORT_SYM:{
      viewport();
      break;
      }
    case COLOR_PROFILE:{
      colorprofile();
      break;
      }
    case COUNTER_STYLE_SYM:{
      counterstyle();
      break;
      }
    case PHONETIC_ALPHABET_SYM:{
      phoneticAlphabet();
      break;
      }
    case SUPPORTS_SYM:{
      supports();
      break;
      }
    case ATKEYWORD:{
      atRuleDeclaration();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void afterImportDeclaration() throws ParseException {String ret;
    label_8:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case LBRACKET:
      case ANY:
      case COLON:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case ANGLE:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN:
      case PSEUDOELEMENT_SYM:
      case CLASS:
      case FUNCTIONNOT:
      case 136:{
        ruleSet();
        break;
        }
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEYFRAMES_SYM:
      case PREF_SYM:
      case COLOR_PROFILE:
      case COUNTER_STYLE_SYM:
      case PHONETIC_ALPHABET_SYM:
      case SUPPORTS_SYM:
      case VIEWPORT_SYM:
      case ATKEYWORD:{
        nested_at_rules();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        ret = skipStatement();
if ((ret == null) || (ret.length() == 0)) {
                {if ("" != null) return;}
            }
          // quite ugly but necessary to avoid probably a lot of changes in the
          // grammar, still having a beautiful error message
            else if (ret.startsWith("@charset")) {
                ParseException e =
                new ParseException(ac.getMsg().getString("parser.charset"));
                addError(e, ret);
            } else if (ret.startsWith("@import")) {
                ParseException e =
                new ParseException(ac.getMsg().getString("parser.import_not_allowed"));
                addError(e, ret);
            } else {
                ParseException e =
             new ParseException(ac.getMsg().getString("generator.unrecognize"));
                addError(e, ret);
            }
      }
      ignoreStatement();
    }
  }

  final public void ignoreStatement() throws ParseException {
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CDO:
      case CDC:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CDO:{
        jj_consume_token(CDO);
        break;
        }
      case CDC:{
        jj_consume_token(CDC);
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[14] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
    }
  }

  final public void namespaceDeclaration() throws ParseException {Token n=null;
    Token v=null;
    boolean is_url; /* for formatting */
    String nsname;
    String prefix = null;
    CssValue val;
    jj_consume_token(NAMESPACE_SYM);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_11;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
prefix = convertIdent(n.image);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      v = jj_consume_token(STRING);
is_url = false;
              nsname = v.image.substring(1, v.image.length()-1);
      break;
      }
    case URL:{
      v = jj_consume_token(URL);
is_url = true;
              val = new CssURL();
              ((CssURL) val).set(v.image, ac, url);
              nsname = (String) val.get();
              if ((nsname.charAt(0) == '"')
                  || (nsname.charAt(0) == '\'')) {
                  nsname = nsname.substring(1, nsname.length()-1);
              }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_13;
      }
      jj_consume_token(S);
    }
    jj_consume_token(SEMICOLON);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_14;
      }
      jj_consume_token(S);
    }
// If less than CSS 3
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            addError(new InvalidParamException("at-rule", "@namespace", ac),
                     (n==null)?"default":n.toString());
        } else {
            if (v != null) {
                handleNamespaceDeclaration(getURL(), prefix, nsname, is_url);
            }
        }
  }

/**
 * The import statement
 *
 * @exception ParseException exception during the parse
 */
  final public void importDeclaration() throws ParseException {Token n;
    AtRuleMedia media = AtRuleMedia.getInstance(ac.getCssVersion());
    CssValue val;
    String importFile;
    boolean is_url = false;
    try {
      jj_consume_token(IMPORT_SYM);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
importFile = n.image.substring(1, n.image.length() -1);
                is_url = false;
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
val = new CssURL();
                ((CssURL) val).set(n.image, ac, url);
                importFile = (String) val.get();
                if ((importFile.charAt(0) == '"')
                    || (importFile.charAt(0) == '\'')) {
                    importFile = importFile.substring(1, importFile.length()-1);
                }
                is_url = true;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_16;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONLY:
      case NOT:
      case IDENT:
      case RPARAN:{
        mediaquerylist(media);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_17;
        }
        jj_consume_token(S);
      }
handleImport(getURL(), importFile, is_url, media);
    } catch (ParseException e) {
addError(e, skipStatement());
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public AtRuleMedia media() throws ParseException {AtRule old = getAtRule();
    AtRuleMedia newRule = AtRuleMedia.getInstance(ac.getCssVersion());
    setAtRule(newRule);
    Token n;
    CssProperty p = null;
    boolean isCss1 =  (ac.getCssVersion() == CssVersion.CSS1);
    boolean emptyList = true;
    int begl = 0, begc = 0, endl = 0, endc = 0;
    try {
      n = jj_consume_token(MEDIA_SYM);
begl = getBeginLine();
            begc = getBeginColumn();
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_18;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONLY:
      case NOT:
      case IDENT:
      case RPARAN:{
        mediaquerylist(newRule);
String media = getAtRule().toString();
                    emptyList = false;
                    if (ac.getMedium() != null &&
                        !(media.equals(ac.getMedium())) &&
                        !(ac.getMedium().equals("all"))) {

                        ac.getFrame().addWarning("noothermedium", getAtRule().toString());
                    }
                    if (isCss1) {
                        skipStatement();
                        addError(new InvalidParamException("noatruleyet", "", ac),
                                 getAtRule().toString());
                    } else {
                        newAtRule(getAtRule());
                    }
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
endl = getEndLine() ; endc = getEndColumn() ;
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:
        case CLASS:
        case FUNCTIONNOT:
        case 136:{
          ;
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          break label_20;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:
        case 136:{
          ruleSet();
          break;
          }
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:{
          nested_at_rules();
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                         endOfAtRule();
                     }
    } catch (ParseException e) {
if (!isCss1) {
                addError(e, skipStatement());
            }
            newRule = null;
    } finally {
if (emptyList && ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            ac.getFrame().addError(new CssError(getSourceFile(), begl, begc, endl, endc,
                                                new InvalidParamException("emptymedia", ac)));
        }
        setAtRule(old);
        {if ("" != null) return newRule;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void ratio(CssExpression exp, char operator) throws ParseException {Token w,h,n;
    w = jj_consume_token(NUMBER);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_22;
      }
      jj_consume_token(S);
    }
    jj_consume_token(DIV);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_23;
      }
      jj_consume_token(S);
    }
    h = jj_consume_token(NUMBER);
StringBuilder sb = new StringBuilder();
     sb.append(w.image).append('/').append(h.image);
     n = Token.newToken(w.kind, sb.toString());
     setValue(new CssRatio(), exp, operator, n, NUMBER);
  }

  final public void mediaquerylist(AtRuleMedia mediaRule) throws ParseException {
    mediaquery(mediaRule);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
      mediaquery(mediaRule);
    }
  }

  final public void mediaquery(AtRuleMedia mediaRule) throws ParseException {Token n;
  String mediarestrictor = null;
    if (jj_2_1(3)) {
      mediacondition(mediaRule, true, null);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONLY:
      case NOT:
      case IDENT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ONLY:
        case NOT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NOT:{
            n = jj_consume_token(NOT);
            break;
            }
          case ONLY:{
            n = jj_consume_token(ONLY);
            break;
            }
          default:
            jj_la1[36] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
mediarestrictor = convertIdent(n.image);
          label_26:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[37] = jj_gen;
              break label_26;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          ;
        }
        n = jj_consume_token(IDENT);
mediaRule.addMedia(mediarestrictor, convertIdent(n.image), ac);
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[39] = jj_gen;
            break label_27;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          n = jj_consume_token(AND);
mediarestrictor = convertIdent(n.image);
          label_28:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[40] = jj_gen;
              break label_28;
            }
            jj_consume_token(S);
          }
          mediaconditionwithoutor(mediaRule, false, mediarestrictor);
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void mediacondition(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {Token n;
    String combinator = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      n = jj_consume_token(NOT);
combinator = convertIdent(n.image);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
      mediainparens(mediaRule, defaultMedia, combinator);
      break;
      }
    case RPARAN:{
      mediainparens(mediaRule, defaultMedia, null);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          label_30:
          while (true) {
            n = jj_consume_token(AND);
combinator = convertIdent(n.image);
            label_31:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[44] = jj_gen;
                break label_31;
              }
              jj_consume_token(S);
            }
            mediainparens(mediaRule, false, combinator);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AND:{
              ;
              break;
              }
            default:
              jj_la1[45] = jj_gen;
              break label_30;
            }
          }
          break;
          }
        case OR:{
          label_32:
          while (true) {
            n = jj_consume_token(OR);
combinator = convertIdent(n.image);
            label_33:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[46] = jj_gen;
                break label_33;
              }
              jj_consume_token(S);
            }
            mediainparens(mediaRule, false, combinator);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case OR:{
              ;
              break;
              }
            default:
              jj_la1[47] = jj_gen;
              break label_32;
            }
          }
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void mediaconditionwithoutor(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {Token n;
    String mediarestrictor = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      n = jj_consume_token(NOT);
mediarestrictor = convertIdent(n.image);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
      mediainparens(mediaRule, defaultMedia, mediarestrictor);
      break;
      }
    case RPARAN:{
      mediainparens(mediaRule, defaultMedia, comb);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          break label_35;
        }
        n = jj_consume_token(AND);
mediarestrictor = convertIdent(n.image);
        label_36:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[53] = jj_gen;
            break label_36;
          }
          jj_consume_token(S);
        }
        mediainparens(mediaRule, defaultMedia, mediarestrictor);
      }
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void mediainparens(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {CssExpression val = null;
  String mediaFeatureName = null;
  Token n;
    if (jj_2_2(4)) {
      jj_consume_token(RPARAN);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_37;
        }
        jj_consume_token(S);
      }
      mediacondition(mediaRule, defaultMedia, comb);
      jj_consume_token(LPARAN);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
    } else if (jj_2_3(5)) {
      mediarange(mediaRule, defaultMedia, comb);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RPARAN:{
        mediaexpression(mediaRule, defaultMedia, comb);
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void mediaexpression(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {CssExpression val = null;
  String mediaFeatureName = null;
  Token n;
    jj_consume_token(RPARAN);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        break label_39;
      }
      jj_consume_token(S);
    }
    n = jj_consume_token(IDENT);
// here we add the default media if not present
       if (defaultMedia) {
           mediaRule.addMedia(null, null, ac);
       }
       mediaFeatureName = convertIdent(n.image);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_40;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          break label_41;
        }
        jj_consume_token(S);
      }
      val = mediaexpr();
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    jj_consume_token(LPARAN);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_42;
      }
      jj_consume_token(S);
    }
MediaFeature mf = handleMediaFeature(mediaRule, mediaFeatureName, val);
        if (mf != null) {
            mediaRule.addMediaFeature(mf, ac);
            mf.setCombinator(comb);
            // mf.setParens();
        }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void supports() throws ParseException {AtRule old = getAtRule();
    AtRuleSupports newRule = new AtRuleSupports();
    setAtRule(newRule);
    Token n;
    CssProperty p = null;
    CssVersion version = ac.getCssVersion();
    boolean isCss1 =  (version == CssVersion.CSS1);
    SupportsFeature sf;
    try {
      n = jj_consume_token(SUPPORTS_SYM);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          break label_43;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) < 0) {
                skipStatement();
                addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
            }
      //
              // handle supports rules
              //
              sf = supports_condition(newRule);
newRule.addFeature(sf, ac); newAtRule(getAtRule());
      jj_consume_token(LBRACE);
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          break label_44;
        }
        jj_consume_token(S);
      }
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:
        case CLASS:
        case FUNCTIONNOT:
        case 136:{
          ;
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          break label_45;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:
        case 136:{
          ruleSet();
          break;
          }
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:{
          nested_at_rules();
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_46;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                 endOfAtRule();
             }
    } catch (ParseException e) {
if (!isCss1) {
              addError(e, skipStatement());
          }
          newRule = null;
    } finally {
setAtRule(old);
    }
  }

  final public SupportsFeature supports_condition(AtRuleSupports supportsRule) throws ParseException {Token t;
    SupportsFeature f = null;
    SupportsFeature nf, mf;
    boolean got_multi = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
      label_47:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[68] = jj_gen;
          break label_47;
        }
      }
      nf = supports_condition_in_parens(supportsRule);
nf.setNot(true); {if ("" != null) return nf;}
      break;
      }
    case RPARAN:{
      nf = supports_condition_in_parens(supportsRule);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          label_48:
          while (true) {
            jj_consume_token(AND);
            label_49:
            while (true) {
              jj_consume_token(S);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[69] = jj_gen;
                break label_49;
              }
            }
            mf = supports_condition_in_parens(supportsRule);
if (f == null) {
                                                               f = new SupportsFeature();
                                                               f.addFeature(nf);
                                                           }
                                                           mf.setAnd(true);
                                                           f.addFeature(mf);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AND:{
              ;
              break;
              }
            default:
              jj_la1[70] = jj_gen;
              break label_48;
            }
          }
          break;
          }
        case OR:{
          label_50:
          while (true) {
            jj_consume_token(OR);
            label_51:
            while (true) {
              jj_consume_token(S);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[71] = jj_gen;
                break label_51;
              }
            }
            mf = supports_condition_in_parens(supportsRule);
if (f == null) {
                                                               f = new SupportsFeature();
                                                               f.addFeature(nf);
                                                           }
                                                           mf.setOr(true);
                                                           f.addFeature(mf);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case OR:{
              ;
              break;
              }
            default:
              jj_la1[72] = jj_gen;
              break label_50;
            }
          }
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
if (f == null) {
            {if ("" != null) return nf;}
        }
        {if ("" != null) return f;}
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SupportsFeature supports_condition_in_parens(AtRuleSupports supportsRule) throws ParseException {CssProperty p;
    SupportsFeature f = new SupportsFeature();
    SupportsFeature nf;
    jj_consume_token(RPARAN);
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        break label_52;
      }
      jj_consume_token(S);
    }
    if (jj_2_4(3)) {
      nf = supports_condition(supportsRule);
f.addFeature(nf);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case COMMA:
      case TILDE:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case HASHIDENT:
      case CUSTOM_PROPERTY_NAME:
      case EQ:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case ANY:
      case LPARAN:
      case RPARAN:
      case COLON:
      case ATKEYWORD:
      case CLASS:
      case 129:
      case 130:
      case 131:
      case 132:
      case 133:
      case 134:
      case 135:
      case 136:{
        p = declaration();
f.setProperty(p);
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(LPARAN);
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        break label_53;
      }
      jj_consume_token(S);
    }
{if ("" != null) return f;}
    throw new Error("Missing return statement in function");
  }

  final public void general_enclosed(AtRuleSupports supportsRule) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      break;
      }
    case RPARAN:{
      jj_consume_token(RPARAN);
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        break label_54;
      }
      jj_consume_token(S);
    }
    label_55:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_55;
      }
      ident();
    }
    jj_consume_token(LPARAN);
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        break label_56;
      }
      jj_consume_token(S);
    }
  }

  final public void unused_production_generic_syntax() throws ParseException {CssExpression values = new CssExpression();
    jj_consume_token(RPARAN);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_57;
      }
      jj_consume_token(S);
    }
    term(values);
    jj_consume_token(LPARAN);

  }

  final public void unused_production_definition() throws ParseException {CssExpression values = new CssExpression();
    jj_consume_token(LBRACKET);
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        break label_58;
      }
      jj_consume_token(S);
    }
    term(values);
    jj_consume_token(RBRACKET);

  }

/**
 * @exception ParseException exception during the parse
 */
  final public void page() throws ParseException {Token        n        = null                ;
    ArrayList<CssProperty>       collectv = new ArrayList<CssProperty>();
    CssSelectors s        = new CssSelectors(ac);
    AtRule       old      = getAtRule()         ;
    AtRulePage   newRule  = AtRulePage.getInstance(ac.getCssVersion());
    setAtRule(newRule);
    s.setAtRule(getAtRule());
    boolean isCss1 = (ac.getCssVersion() == CssVersion.CSS1);
    boolean gotContent = false;
    try {
      jj_consume_token(PAGE_SYM);
if (!isCss1) newAtRule(newRule);
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          break label_59;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case COLON:{
        page_selector_list(newRule);
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_60:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_60;
        }
        jj_consume_token(S);
      }
      gotContent = pageContent();
      jj_consume_token(RBRACE);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          break label_61;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                    if (gotContent) {
                        endOfRule();
                    }
                    endOfAtRule();
                }
    } catch (InvalidParamException ie) {
if (!isCss1) {
            skipStatement();
            removeThisAtRule();
            ac.getFrame()
                .addError(new CssError(getSourceFile(), getBeginLine(),
                    getBeginColumn(), getEndLine(), getEndColumn(), ie));
        }
    } catch (ParseException e) {
if (!isCss1) {
            removeThisAtRule();
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public boolean pageContent() throws ParseException {CssProperty prop;
    ArrayList<CssProperty> v = null;
    ArrayList<CssProperty> allv = new ArrayList<CssProperty>();
    CssSelectors s        = new CssSelectors(ac);
    boolean gotContent = false;
    v = declarations();
if ( v != null ) {
             gotContent = true;
             allv.addAll(v);
         }
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PAGE_TOP_LEFT_CORNER:
      case PAGE_TOP_LEFT:
      case PAGE_TOP_CENTER:
      case PAGE_TOP_RIGHT:
      case PAGE_TOP_RIGHT_CORNER:
      case PAGE_BOTTOM_LEFT_CORNER:
      case PAGE_BOTTOM_LEFT:
      case PAGE_BOTTOM_CENTER:
      case PAGE_BOTTOM_RIGHT:
      case PAGE_BOTTOM_RIGHT_CORNER:
      case PAGE_LEFT_TOP:
      case PAGE_LEFT_MIDDLE:
      case PAGE_LEFT_BOTTOM:
      case PAGE_RIGHT_TOP:
      case PAGE_RIGHT_MIDDLE:
      case PAGE_RIGHT_BOTTOM:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_62;
      }
      prefAtRule();
gotContent = true;
      v = declarations();
if ( v != null ) {
                             allv.addAll(v);
                          }
    }
if ( allv.isEmpty() ) {
               if (!gotContent) ac.getFrame().addWarning("no-declaration");
           } else {
               addProperty(allv);
               handleRule(s, allv);
           }
           {if ("" != null) return gotContent;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<CssProperty> prefAtRule() throws ParseException {Token n;
    ArrayList<CssProperty> v;
    AtRulePage newRule = AtRulePage.getInstance(ac.getCssVersion());
    AtRule       old      = getAtRule();
    CssSelectors s = new CssSelectors(ac);
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PAGE_TOP_LEFT_CORNER:{
        n = jj_consume_token(PAGE_TOP_LEFT_CORNER);
        break;
        }
      case PAGE_TOP_LEFT:{
        n = jj_consume_token(PAGE_TOP_LEFT);
        break;
        }
      case PAGE_TOP_CENTER:{
        n = jj_consume_token(PAGE_TOP_CENTER);
        break;
        }
      case PAGE_TOP_RIGHT:{
        n = jj_consume_token(PAGE_TOP_RIGHT);
        break;
        }
      case PAGE_TOP_RIGHT_CORNER:{
        n = jj_consume_token(PAGE_TOP_RIGHT_CORNER);
        break;
        }
      case PAGE_BOTTOM_LEFT_CORNER:{
        n = jj_consume_token(PAGE_BOTTOM_LEFT_CORNER);
        break;
        }
      case PAGE_BOTTOM_LEFT:{
        n = jj_consume_token(PAGE_BOTTOM_LEFT);
        break;
        }
      case PAGE_BOTTOM_CENTER:{
        n = jj_consume_token(PAGE_BOTTOM_CENTER);
        break;
        }
      case PAGE_BOTTOM_RIGHT:{
        n = jj_consume_token(PAGE_BOTTOM_RIGHT);
        break;
        }
      case PAGE_BOTTOM_RIGHT_CORNER:{
        n = jj_consume_token(PAGE_BOTTOM_RIGHT_CORNER);
        break;
        }
      case PAGE_LEFT_TOP:{
        n = jj_consume_token(PAGE_LEFT_TOP);
        break;
        }
      case PAGE_LEFT_MIDDLE:{
        n = jj_consume_token(PAGE_LEFT_MIDDLE);
        break;
        }
      case PAGE_LEFT_BOTTOM:{
        n = jj_consume_token(PAGE_LEFT_BOTTOM);
        break;
        }
      case PAGE_RIGHT_TOP:{
        n = jj_consume_token(PAGE_RIGHT_TOP);
        break;
        }
      case PAGE_RIGHT_MIDDLE:{
        n = jj_consume_token(PAGE_RIGHT_MIDDLE);
        break;
        }
      case PAGE_RIGHT_BOTTOM:{
        n = jj_consume_token(PAGE_RIGHT_BOTTOM);
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
((org.w3c.css.atrules.css3.AtRulePage) newRule).setKeyword(convertIdent(n.image).substring(1));
            setAtRule(newRule);
            s.setAtRule(getAtRule());
            newAtRule(getAtRule());
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          break label_63;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_64:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          break label_64;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
if ( v == null ) {
                        ac.getFrame().addWarning("no-declaration");
                    } else {
                        addProperty(v);
                        handleRule(s, v);
                    }
                    endOfRule();
                    endOfAtRule();
      label_65:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[93] = jj_gen;
          break label_65;
        }
        jj_consume_token(S);
      }
// FIXME
                {if ("" != null) return v;}
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
    throw new Error("Missing return statement in function");
  }

  final public void page_selector_list(AtRulePage pageRule) throws ParseException {Token n = null;
    Token p = null;
    Token o = null;
    boolean gotFirst = false;
    String ns = null;
    ArrayList<String> ps = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
ns = convertIdent(n.image);
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          ;
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          break label_66;
        }
        jj_consume_token(COLON);
        p = ident();
if (ps == null) { ps = new ArrayList(); } ps.add(":"+convertIdent(p.image));
      }
pageRule.addSelector(ns, ps, ac);
        ns = null; ps = null;
      break;
      }
    case COLON:{
      label_67:
      while (true) {
        jj_consume_token(COLON);
        p = ident();
if (ps == null) { ps = new ArrayList(); } ps.add(":"+convertIdent(p.image));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          ;
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          break label_67;
        }
      }
pageRule.addSelector(null, ps, ac);
        ps = null;
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_68:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        break label_68;
      }
      jj_consume_token(S);
    }
    label_69:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        break label_69;
      }
      jj_consume_token(COMMA);
      label_70:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          break label_70;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
ns = convertIdent(n.image);
        label_71:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COLON:{
            ;
            break;
            }
          default:
            jj_la1[100] = jj_gen;
            break label_71;
          }
          jj_consume_token(COLON);
          p = ident();
if (ps == null) { ps = new ArrayList(); } ps.add(":"+convertIdent(p.image));
        }
pageRule.addSelector(ns, ps, ac);
        ns = null; ps = null;
        break;
        }
      case COLON:{
        label_72:
        while (true) {
          jj_consume_token(COLON);
          p = ident();
if (ps == null) { ps = new ArrayList(); } ps.add(":"+convertIdent(p.image));
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COLON:{
            ;
            break;
            }
          default:
            jj_la1[101] = jj_gen;
            break label_72;
          }
        }
pageRule.addSelector(null, ps, ac);
        ps = null;
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_73:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[103] = jj_gen;
          break label_73;
        }
        jj_consume_token(S);
      }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors keyframe_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
    selector.setAtRule(getAtRule());
    Token n;
    Token op = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
CssIdent ident = new CssIdent();
      ident.set(convertIdent(n.image), ac);
      AtRuleKeyframes.checkSelectorValue(ident, ac);
      selector.addType(new TypeSelector(ident.toString()));
        break;
        }
      case PLUS:
      case MINUS:
      case PERCENTAGE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:{
            op = jj_consume_token(PLUS);
            break;
            }
          case MINUS:{
            op = jj_consume_token(MINUS);
            break;
            }
          default:
            jj_la1[104] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          ;
        }
        n = jj_consume_token(PERCENTAGE);
CssPercentage p = new CssPercentage();
      if (op == null) {
        p.set(n.image, ac);
      } else {
        p.set(op.image+n.image, ac);
      }
      AtRuleKeyframes.checkSelectorValue(p, ac);
      selector.addType(new TypeSelector(n.image));
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_74:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          break label_74;
        }
        jj_consume_token(S);
      }
{if ("" != null) return selector;}
    } catch (InvalidParamException ie) {
ac.getFrame()
            .addError(new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(), ie));
        Token t = getToken(1);
        StringBuilder s = new StringBuilder();
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        {if ("" != null) return null;}
    } catch (ParseException e) {
// TODO fix the error
        Token t = getToken(1);
        int _line = t.beginLine;
        int _col  = t.beginColumn;
        StringBuilder s = new StringBuilder();
        s.append(" [");
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        s.append(']');
        addParseError(e, s.toString());
        validSelector = true;
        {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void keyframes() throws ParseException {Token n;
  ArrayList<CssProperty> v;
  AtRule old = getAtRule();
  AtRuleKeyframes krule = new AtRuleKeyframes("-internal-");
  setAtRule(krule);
  CssSelectors s;
  ArrayList<CssSelectors> sl;
  CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(KEYFRAMES_SYM);
      label_75:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[108] = jj_gen;
          break label_75;
        }
      }
      n = ident();
      label_76:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[109] = jj_gen;
          break label_76;
        }
        jj_consume_token(S);
      }
krule.setName(convertIdent(n.image));
      if (version.compareTo(CssVersion.CSS3) < 0) {
        skipStatement();
        addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
      } else {
        newAtRule(getAtRule());
      }
      jj_consume_token(LBRACE);
      label_77:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[110] = jj_gen;
          break label_77;
        }
        jj_consume_token(S);
      }
      label_78:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case PERCENTAGE:{
          ;
          break;
          }
        default:
          jj_la1[111] = jj_gen;
          break label_78;
        }
        s = keyframe_selector(null);
sl = new ArrayList<CssSelectors>();
        if (s != null) {
          s.setAtRule(getAtRule());
          sl.add(s);
        }
        label_79:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[112] = jj_gen;
            break label_79;
          }
          jj_consume_token(COMMA);
          label_80:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[113] = jj_gen;
              break label_80;
            }
            jj_consume_token(S);
          }
          s = keyframe_selector(null);
if (s != null) {
         s.setAtRule(getAtRule());
         sl.add(s);
       }
        }
        jj_consume_token(LBRACE);
        label_81:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[114] = jj_gen;
            break label_81;
          }
          jj_consume_token(S);
        }
        v = declarations();
        jj_consume_token(RBRACE);
        label_82:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[115] = jj_gen;
            break label_82;
          }
          jj_consume_token(S);
        }
validSelector = (sl.size() != 0);
        if (validSelector) {
          if (v == null) {
            ac.getFrame().addWarning("no-declaration");
          } else {
            boolean first = true;
            for (CssSelectors _s : sl) {
              if (first) {
                 handleRule(_s, v);
                 first = false;
              } else {
                 ArrayList<CssProperty> vcopy = new ArrayList<CssProperty>(v.size());
                 for (CssProperty p : v) {
                   vcopy.add(p.duplicate());
                 }
                 handleRule(_s, vcopy);
              }
            }
          }
          setSelectorList(sl);
          endOfRule();
        }
      }
      jj_consume_token(RBRACE);
      label_83:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          break label_83;
        }
        jj_consume_token(S);
      }
endOfAtRule();
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
  }

  final public void fontFace() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleFontFace());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    boolean isCss1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_84:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          break label_84;
        }
        jj_consume_token(S);
      }
if (isCss1) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_85:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[118] = jj_gen;
          break label_85;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_86:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          break label_86;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }
                 if (v == null) {
                     ac.getFrame().addWarning("no-declaration");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (!isCss1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void colorprofile() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleColorProfile());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    CssProfile profile = ac.getCssProfile();
    boolean isSVG = ((profile == CssProfile.SVG) ||
                     (profile == CssProfile.SVGBASIC) ||
                     (profile == CssProfile.SVGTINY));
    try {
      jj_consume_token(COLOR_PROFILE);
      label_87:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          break label_87;
        }
        jj_consume_token(S);
      }
if (!isSVG) {
                    skipStatement();
                    addError(new InvalidParamException("onlysvg", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_88:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          break label_88;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_89:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          break label_89;
        }
        jj_consume_token(S);
      }
if (isSVG) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     //ac.getFrame().addWarning("medialist");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (isSVG) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void viewport() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleViewport());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(VIEWPORT_SYM);
      label_90:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          break label_90;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) < 0) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_91:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          break label_91;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_92:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[125] = jj_gen;
          break label_92;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) >= 0) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     ac.getFrame().addWarning("no-declaration");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (version.compareTo(CssVersion.CSS3) < 0) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void counterstyle() throws ParseException {Token n;
  ArrayList<CssProperty> v;
  AtRule old = getAtRule();
  AtRuleCounterStyle csrule = new AtRuleCounterStyle();
  setAtRule(csrule);
  CssSelectors s = new CssSelectors(ac);;
  CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(COUNTER_STYLE_SYM);
      label_93:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          break label_93;
        }
      }
      n = ident();
      label_94:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          break label_94;
        }
        jj_consume_token(S);
      }
csrule.setName(convertIdent(n.image));
      if (version.compareTo(CssVersion.CSS3) < 0) {
        skipStatement();
        addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
      } else {
        newAtRule(getAtRule());
      }
      jj_consume_token(LBRACE);
      label_95:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          break label_95;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_96:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          break label_96;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) >= 0) {
            addProperty(v);
            endOfRule();
            endOfAtRule();
         }
         if (v == null) {
            ac.getFrame().addWarning("no-declaration");
         } else {
            handleRule(s, v);
         }
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
  }

  final public void preference() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRulePreference());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    boolean isCSS1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(PREF_SYM);
      label_97:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          break label_97;
        }
        jj_consume_token(S);
      }
if (isCSS1) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_98:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          break label_98;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_99:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[132] = jj_gen;
          break label_99;
        }
        jj_consume_token(S);
      }
if (!isCSS1) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     ac.getFrame().addWarning("medialist");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (!isCSS1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void phoneticAlphabet() throws ParseException {AtRule old = getAtRule();
    AtRulePhoneticAlphabet alphabetrule = new AtRulePhoneticAlphabet();
    setAtRule(alphabetrule);
    Token n;
    CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(PHONETIC_ALPHABET_SYM);
      label_100:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[133] = jj_gen;
          break label_100;
        }
        jj_consume_token(S);
      }
      n = jj_consume_token(STRING);
      label_101:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[134] = jj_gen;
          break label_101;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
// FIXME comparison > CSS3
                if (version.compareTo(CssVersion.CSS3) < 0) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                }

                alphabetrule.addAlphabet(convertIdent(n.image), ac);

                if ((version != CssVersion.CSS1) && (version != CssVersion.CSS2)) {
                    newAtRule(getAtRule());
                }
    } catch (ParseException e) {
if (version != CssVersion.CSS1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void atRuleDeclaration() throws ParseException {Token n;
    n = jj_consume_token(ATKEYWORD);
if (n.toString().charAt(1) == '-') {
                        if (ac.getTreatVendorExtensionsAsWarnings()) {
                                ac.getFrame() //
                                        .addWarning("at-rule", //
                                                n.toString());
                        } else {
                                addAtRuleError();
                        }
                } else {
                        addAtRuleError();
                }
            skipStatement();
  }

  void addAtRuleError() throws ParseException {//
        ac.getFrame()
            .addError(new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(),
                    new InvalidParamException("at-rule", token, ac)));
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void operator(CssExpression expr) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
if (expr.getCount() > 0) expr.setOperator(',');
      label_102:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[135] = jj_gen;
          break label_102;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[136] = jj_gen;
      ;
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char combinator() throws ParseException {char connector = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case TILDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
connector = '+' ;
        break;
        }
      case GREATER:{
        jj_consume_token(GREATER);
connector = '>' ;
        break;
        }
      case TILDE:{
        jj_consume_token(TILDE);
connector = '~' ;
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_103:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[138] = jj_gen;
          break label_103;
        }
        jj_consume_token(S);
      }
      break;
      }
    case S:{
      label_104:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[139] = jj_gen;
          break label_104;
        }
      }
connector = ' ' ;
      break;
      }
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return connector;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
{if ("" != null) return '-';}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return '+';}
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String property() throws ParseException {Token n;
 Token hack= null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case COMMA:
    case TILDE:
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case CUSTOM_PROPERTY_NAME:
    case EQ:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case ANY:
    case LPARAN:
    case RPARAN:
    case COLON:
    case 129:
    case 130:
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case COMMA:
      case TILDE:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case EQ:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case ANY:
      case LPARAN:
      case RPARAN:
      case COLON:
      case 129:
      case 130:
      case 131:
      case 132:
      case 133:
      case 134:
      case 135:
      case 136:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case GREATER:
        case COMMA:
        case TILDE:
        case EQ:
        case DIV:
        case LBRACKET:
        case RBRACKET:
        case ANY:
        case LPARAN:
        case RPARAN:
        case COLON:
        case 129:
        case 130:
        case 131:
        case 132:
        case 133:
        case 134:
        case 135:
        case 136:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 129:{
            hack = jj_consume_token(129);
            break;
            }
          case 130:{
            hack = jj_consume_token(130);
            break;
            }
          case 131:{
            hack = jj_consume_token(131);
            break;
            }
          case 132:{
            hack = jj_consume_token(132);
            break;
            }
          case 133:{
            hack = jj_consume_token(133);
            break;
            }
          case 134:{
            hack = jj_consume_token(134);
            break;
            }
          case 135:{
            hack = jj_consume_token(135);
            break;
            }
          case 136:{
            hack = jj_consume_token(136);
            break;
            }
          case ANY:{
            hack = jj_consume_token(ANY);
            break;
            }
          case EQ:{
            hack = jj_consume_token(EQ);
            break;
            }
          case RBRACKET:{
            hack = jj_consume_token(RBRACKET);
            break;
            }
          case LBRACKET:{
            hack = jj_consume_token(LBRACKET);
            break;
            }
          case LPARAN:{
            hack = jj_consume_token(LPARAN);
            break;
            }
          case RPARAN:{
            hack = jj_consume_token(RPARAN);
            break;
            }
          case COLON:{
            hack = jj_consume_token(COLON);
            break;
            }
          case TILDE:{
            hack = jj_consume_token(TILDE);
            break;
            }
          case PLUS:{
            hack = jj_consume_token(PLUS);
            break;
            }
          case COMMA:{
            hack = jj_consume_token(COMMA);
            break;
            }
          case GREATER:{
            hack = jj_consume_token(GREATER);
            break;
            }
          case DIV:{
            hack = jj_consume_token(DIV);
            break;
            }
          default:
            jj_la1[142] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[143] = jj_gen;
          ;
        }
        n = ident();
        break;
        }
      case CUSTOM_PROPERTY_NAME:{
        n = jj_consume_token(CUSTOM_PROPERTY_NAME);
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_105:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          break label_105;
        }
        jj_consume_token(S);
      }
currentProperty = convertIdent(n.image);
                 if (hack != null && !"".equals(hack)) {
                   String hackp = hack.image+currentProperty;
                   if (ac.getTreatCssHacksAsWarnings()) {
                     ac.getFrame().addWarning("css-hack", hackp);
                     {if ("" != null) return null;}
                   } else {
                     {if (true) throw new ParseException(String.format(ac.getMsg().getString("warning.css-hack"), hackp));}
                   }
                }
                {if ("" != null) return currentProperty;}
      break;
      }
    case HASHIDENT:
    case ATKEYWORD:
    case CLASS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case HASHIDENT:{
        n = jj_consume_token(HASHIDENT);
        break;
        }
      case CLASS:{
        n = jj_consume_token(CLASS);
        break;
        }
      case ATKEYWORD:{
        n = jj_consume_token(ATKEYWORD);
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (ac.getTreatCssHacksAsWarnings()) {
                              ac.getFrame().addWarning("css-hack", n.image);
                              // should we continue and validate the content, or skip ?
                              currentProperty = convertIdent(n.image).substring(1);
                              {if ("" != null) return null;}
         }
        {if (true) throw new ParseException(String.format(ac.getMsg().getString("warning.css-hack"), n.image));}
      label_106:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[147] = jj_gen;
          break label_106;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void ruleSet() throws ParseException {CssSelectors contextual;
    ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
    ArrayList<CssProperty> value_set = null;
    currentContext = context_set;
    try {
      contextual = selector();
if (contextual != null) {
                    context_set.add(contextual);
                }
      label_107:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[149] = jj_gen;
          break label_107;
        }
        jj_consume_token(COMMA);
        label_108:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[150] = jj_gen;
            break label_108;
          }
          jj_consume_token(S);
        }
        contextual = selector();
if (contextual != null) {
                    context_set.add(contextual);
                }
      }
      jj_consume_token(LBRACE);
validSelector = (context_set.size() > 0);
      label_109:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          break label_109;
        }
        jj_consume_token(S);
      }
      value_set = declarations();
      jj_consume_token(RBRACE);
      label_110:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[152] = jj_gen;
          break label_110;
        }
        jj_consume_token(S);
      }
markRule = true;

                /*      if (value_set == null) {
			ac.getFrame().addWarning("no-declaration");
			} else {*/
                if (value_set != null) {
                    boolean first = true;
                    for (CssSelectors sel : context_set) {
                        if (first) {
                            handleRule(sel, value_set);
                            first = false;
                        } else {
                            // we need to duplicate properties in that case
                            // as property holds reference to the selectors and it interact
                            // badly with conflict detection
                            int vsize = value_set.size();
                            ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                            for (CssProperty p : value_set) {
                                v.add(p.duplicate());
                            }
                            handleRule(sel, v);
                        }
                    }
                    setSelectorList(context_set);
                    endOfRule();
                }
                currentContext = null;
    } catch (ParseException e) {
if ((ac.getCssProfile() != CssProfile.MOBILE) && !context_set.isEmpty()) {
                addError(e, skipStatement());
        }
    } catch (TokenMgrError e) {
addError(new ParseException(e.getMessage()), skipStatement());
    }
  }

  final public ArrayList<CssProperty> declarations() throws ParseException {if(!validSelector) {
        validSelector = true;
        skip_to_matching_brace();
        return null;
    }

    CssProperty values;
    ArrayList<CssProperty> value_set   = new ArrayList<CssProperty>();
    boolean wrong_value = true;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case COMMA:
    case TILDE:
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case HASHIDENT:
    case CUSTOM_PROPERTY_NAME:
    case EQ:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case ANY:
    case LPARAN:
    case RPARAN:
    case COLON:
    case ATKEYWORD:
    case CLASS:
    case 129:
    case 130:
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:{
      values = declaration();
if (values != null) {
                value_set.add(values);
                wrong_value = false;
            } /* else {
		 wrong_value = true;
		 } */
          currentProperty = null;
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      ;
    }
    label_111:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[154] = jj_gen;
        break label_111;
      }
      jj_consume_token(SEMICOLON);
      label_112:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[155] = jj_gen;
          break label_112;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case COMMA:
      case TILDE:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case HASHIDENT:
      case CUSTOM_PROPERTY_NAME:
      case EQ:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case ANY:
      case LPARAN:
      case RPARAN:
      case COLON:
      case ATKEYWORD:
      case CLASS:
      case 129:
      case 130:
      case 131:
      case 132:
      case 133:
      case 134:
      case 135:
      case 136:{
        values = declaration();
if (values != null) {
                      value_set.add(values);
                      wrong_value = false;
                  }/* else {
		      wrong_value = true;
		      }*/
                currentProperty = null;
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        ;
      }
    }
if (!wrong_value) {
                addProperty(value_set);
                {if ("" != null) return value_set;}
            } else {
                {if ("" != null) return null;}
            }
    throw new Error("Missing return statement in function");
  }

/** 
 * Used only when HTML is parsed, as otherwise parsing <S>* is missed 
 */
  final public ArrayList<CssProperty> attributeDeclarations() throws ParseException {ArrayList<CssProperty> p = null;
    try {
      label_113:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[157] = jj_gen;
          break label_113;
        }
        jj_consume_token(S);
      }
      p = declarations();
{if ("" != null) return p;}
    } catch (TokenMgrError tokenerror) {
{if (true) throw new ParseException(ac.getMsg().getString("generator.unrecognize"));}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors selector() throws ParseException {char comb;
    CssSelectors current;
    try {
      current = simple_selector(null);
      label_114:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case PLUS:
        case GREATER:
        case TILDE:{
          ;
          break;
          }
        default:
          jj_la1[158] = jj_gen;
          break label_114;
        }
        comb = combinator();
if ((ac.getCssProfile() == CssProfile.MOBILE) ||
                        getAtRule().toString().equals("@media atsc-tv") ||
                        (ac.getCssVersion() == CssVersion.CSS1)) {
                        if (comb == '+') {
                            {if (true) throw new InvalidParamException("nocomb", "+", ac);}
                        }
                        if (comb == '>') {
                            {if (true) throw new InvalidParamException("nocomb", ">", ac);}
                        }
                } else if (ac.getCssProfile() == CssProfile.TV) {
                        if (comb == '+') {
                            {if (true) throw new InvalidParamException("nocomb", "+", ac);}
                    }
                }
                // if version < CSS3, ~ is undefined
                if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                    if (comb == '~') {
                            {if (true) throw new InvalidParamException("nocomb", "~", ac);}
                    }
                }
                switch(comb) {
                case '+':
                current.addAdjacentSibling(new AdjacentSiblingSelector());
                break;
                case '>':
                current.addChild(new ChildSelector());
                break;
                case '~':
                current.addGeneralSibling(new GeneralSiblingSelector());
                break;
                default:
                current.addDescendant(new DescendantSelector());
                }
                //current.setConnector(comb); 

        current = simple_selector(current);
      }
{if ("" != null) return current;}
    } catch (InvalidParamException ie) {
//	skipStatement();
        //	removeThisRule();
        ac.getFrame()
           .addError(new CssError(getSourceFile(), getBeginLine(),
               getBeginColumn(), getEndLine(), getEndColumn(), ie));
        Token t = getToken(1);
        StringBuilder s = new StringBuilder();
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        {if ("" != null) return null;}
    } catch (ParseException e) {
//	validSelector = false;
        Token t = getToken(1);
        StringBuilder s = new StringBuilder("[");
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        s.append(']');
        //	if (validSelector) {
        addError(e, s.toString());
            //	} else {
            //  addError(e,"");
            //	}
        validSelector = true;
        {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * I made this rule to parse a selector from a document. Combinator are avoid.
 * @exception ParseException exception during the parse
 */
  final public CssSelectors externalSelector() throws ParseException {CssSelectors current;
    current = simple_selector(null);
    label_115:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_115;
      }
      label_116:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[160] = jj_gen;
          break label_116;
        }
      }
      current = simple_selector(current);
    }
{if ("" != null) return current;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors simple_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
    selector.setAtRule(getAtRule());
    //selector.setUserMedium(getUserMedium());

    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case ANY:
    case 136:{
      element_name(selector);
      label_117:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:{
          ;
          break;
          }
        default:
          jj_la1[161] = jj_gen;
          break label_117;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:{
          hash(selector);
          break;
          }
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case CLASS:{
          _class(selector);
          break;
          }
        case LBRACKET:{
          attrib(selector);
          break;
          }
        case COLON:
        case PSEUDOELEMENT_SYM:{
          pseudo(selector);
          break;
          }
        case FUNCTIONNOT:{
          negation(selector);
          break;
          }
        default:
          jj_la1[162] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return selector;}
      break;
      }
    case HASHIDENT:
    case HASH:
    case LBRACKET:
    case COLON:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case PSEUDOELEMENT_SYM:
    case CLASS:
    case FUNCTIONNOT:{
      label_118:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:{
          hash(selector);
          break;
          }
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case CLASS:{
          _class(selector);
          break;
          }
        case LBRACKET:{
          attrib(selector);
          break;
          }
        case COLON:
        case PSEUDOELEMENT_SYM:{
          pseudo(selector);
          break;
          }
        case FUNCTIONNOT:{
          negation(selector);
          break;
          }
        default:
          jj_la1[163] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:{
          ;
          break;
          }
        default:
          jj_la1[164] = jj_gen;
          break label_118;
        }
      }
{if ("" != null) return selector;}
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void _class(CssSelectors s) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLASS:{
      /*  "." n=<IDENT> { */
          n = jj_consume_token(CLASS);
try {
            s.addClass(new ClassSelector(convertClassIdent(n.image.substring(1))));
            //        s.addAttribute("class", convertIdent(n.image.substring(1)),
            //           CssSelectors.ATTRIBUTE_CLASS_SEL);
        } catch (InvalidParamException e) {
            //	    removeThisRule();
             ac.getFrame()
                .addError(new CssError(getSourceFile(), getBeginLine(),
                    getBeginColumn(), getEndLine(), getEndColumn(), e));
            {if (true) throw new ParseException(e.getMessage());}
        }
      break;
      }
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:{
      n = deprecated_class();
if (n.image.charAt(0) == '.') {
            n.image = n.image.substring(1);

            // the class with the first digit escaped
            String cl = "."+hexEscapeFirst(n.image);

        CssVersion version = ac.getCssVersion();
//	    String profile = ac.getProfile();
//	    if(profile == null || profile.equals("") || profile.equals("none")) {
//		profile = ac.getCssVersionString();
//	    }

            if(version != CssVersion.CSS1) {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> param_err = new ArrayList<String>(2);
                param_err.add(n.image);
                param_err.add(cl);
                sb.append(ac.getMsg().getString("parser.old_class", param_err));
                {if (true) throw new ParseException(sb.toString());}
                //		s.addClass(new ClassSelector(n.image));                            
                // removeThisRule();              
            }
            else {
                CssLength length = new CssLength();
                boolean isLength = false;
                try {
                    length.set(n.image, ac);
                    isLength = true;
                }
                catch(Exception e) {
                    isLength = false;
                }
                if(isLength) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ac.getMsg().getString("parser.class_dim"));
                    sb.append(n.image);
                    {if (true) throw new ParseException(sb.toString());}
                    //		    s.addClass(new ClassSelector(n.image));                            
                    // removeThisRule();
                }
                else {
                    try {
                        // for css > 1, we add the rule to have a context, 
                        // and we then remove it
                        s.addClass(new ClassSelector(n.image));
                        ac.getFrame().addWarning("old_class");
                    } catch (InvalidParamException e) {
                        {if (true) throw new ParseException(e.getMessage());}
                        //ac.getFrame().addError(new CssError(e));
                        //removeThisRule();
                    }
                }
            }
        } else {
            {if (true) throw new ParseException("Unrecognized ");}
        }
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token deprecated_class() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RELFONTLENGTH:{
      n = jj_consume_token(RELFONTLENGTH);
      break;
      }
    case RELVIEWLENGTH:{
      n = jj_consume_token(RELVIEWLENGTH);
      break;
      }
    case ABSOLUTLENGTH:{
      n = jj_consume_token(ABSOLUTLENGTH);
      break;
      }
    case ANGLE:{
      n = jj_consume_token(ANGLE);
      break;
      }
    case TIME:{
      n = jj_consume_token(TIME);
      break;
      }
    case FREQ:{
      n = jj_consume_token(FREQ);
      break;
      }
    case RESOLUTION:{
      n = jj_consume_token(RESOLUTION);
      break;
      }
    case DIMEN:{
      n = jj_consume_token(DIMEN);
      break;
      }
    default:
      jj_la1[167] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void element_name(CssSelectors s) throws ParseException {Token n=null;
    Token p=null;
    String prefix = null;
    if (jj_2_5(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case ANY:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:{
          n = ident();
          break;
          }
        case ANY:{
          n = jj_consume_token(ANY);
          break;
          }
        default:
          jj_la1[168] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        ;
      }
      p = jj_consume_token(136);
    } else {
      ;
    }
// FIXME namespace, check versions of CSS in a better way.
        if (p != null) {
            // FIXME should be > CSS3
            if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                StringBuilder sb = new StringBuilder("namespace \"");
                if (n != null) sb.append(n.toString());
                sb.append("\"");
                ac.getFrame()
                   .addError(new CssError(getSourceFile(), getBeginLine(),
                       getBeginColumn(), getEndLine(), getEndColumn(),
                           new InvalidParamException("notversion",
                               "namespace", ac.getCssVersionString(), ac)));
                removeThisRule();
            } else if (n!=null) {
                prefix = convertIdent(n.image);
                if (!ac.isNamespaceDefined(getURL(), prefix)) {
                    // ns is not defined
                    addError(new ParseException("Undefined namespace"),
                             ": The namespace \""+prefix
                             +"\" is not defined. "
                             + prefix );
                    removeThisRule();
                }
            } else {
                prefix = "";
            }
        }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
//              s.setElement(convertIdent(n.image), ac);
        s.addType(new TypeSelector(prefix, convertIdent(n.image)));
      break;
      }
    case ANY:{
      jj_consume_token(ANY);
if (ac.getCssVersion() != CssVersion.CSS1) {
            //          s.setElement(null);
            s.addUniversal(new UniversalSelector(prefix));
        } else {
            ac.getFrame()
               .addError(new CssError(getSourceFile(), getBeginLine(),
                   getBeginColumn(), getEndLine(), getEndColumn(),
                       new InvalidParamException("notversion", "*",
                           ac.getCssVersionString(), ac)));
        }
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void attrib(CssSelectors s) throws ParseException {Token att = null;
    Token val = null;
    int selectorType = CssSelectors.ATTRIBUTE_ANY;
    jj_consume_token(LBRACKET);
    label_119:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[171] = jj_gen;
        break label_119;
      }
      jj_consume_token(S);
    }
    att = ident();
    label_120:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        break label_120;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INCLUDES:
    case DASHMATCH:
    case PREFIXMATCH:
    case SUFFIXMATCH:
    case SUBSTRINGMATCH:
    case EQ:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
selectorType = CssSelectors.ATTRIBUTE_EXACT;
        break;
        }
      case INCLUDES:{
        jj_consume_token(INCLUDES);
selectorType = CssSelectors.ATTRIBUTE_ONE_OF;
        break;
        }
      case DASHMATCH:{
        jj_consume_token(DASHMATCH);
selectorType = CssSelectors.ATTRIBUTE_BEGIN;
        break;
        }
      case PREFIXMATCH:{
        jj_consume_token(PREFIXMATCH);
selectorType = CssSelectors.ATTRIBUTE_START;
        break;
        }
      case SUFFIXMATCH:{
        jj_consume_token(SUFFIXMATCH);
selectorType = CssSelectors.ATTRIBUTE_SUFFIX;
        break;
        }
      case SUBSTRINGMATCH:{
        jj_consume_token(SUBSTRINGMATCH);
selectorType = CssSelectors.ATTRIBUTE_SUBSTR;
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_121:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[174] = jj_gen;
          break label_121;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        val = ident();
val.image = convertIdent(val.image);
        break;
        }
      case STRING:{
        val = jj_consume_token(STRING);
val.image = convertStringIndex(val.image, 1, val.image.length() -1, false);
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_122:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          break label_122;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
if (ac.getCssVersion() == CssVersion.CSS1) {
              StringBuilder reason;
              CssParseException cp;
              ParseException p;
              reason = new StringBuilder(" [");
              if (att != null) {
                  reason.append(convertIdent(att.image));
              }
              if (val != null ) {
                  reason.append('=').append(val.image);
              }
              reason.append(']');
              p = new ParseException(ac.getMsg().getString("parser.attrcss1")+
                                     reason.toString());
              cp = new CssParseException(p);
              ac.getFrame()
                 .addError(new CssError(getSourceFile(), getBeginLine(),
                     getBeginColumn(), getEndLine(), getEndColumn(), cp));
              removeThisRule();
          }
          if (selectorType == CssSelectors.ATTRIBUTE_ANY) {
              try {
                  s.addAttribute(new AttributeAny(att.image.toLowerCase()));
//                s.addAttribute(att.image.toLowerCase(), null, selectorType);
              } catch (InvalidParamException e) {
                  removeThisRule();
                  ac.getFrame()
                     .addError(new CssError(getSourceFile(), getBeginLine(),
                         getBeginColumn(), getEndLine(), getEndColumn(), e));
              }
          } else {
              AttributeSelector attribute;
              switch(selectorType) {
              case CssSelectors.ATTRIBUTE_BEGIN:
                  attribute = new AttributeBegin(att.image.toLowerCase(), val.image);
                  break;
              case CssSelectors.ATTRIBUTE_EXACT:
                  attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                  break;
              case CssSelectors.ATTRIBUTE_ONE_OF:
                  attribute = new AttributeOneOf(ac, att.image.toLowerCase(), val.image);
                  break;
              case CssSelectors.ATTRIBUTE_START:
                  attribute = new AttributeStart(att.image.toLowerCase(), val.image);
                  break;
              case CssSelectors.ATTRIBUTE_SUBSTR:
                  attribute = new AttributeSubstr(att.image.toLowerCase(), val.image);
                  break;
              case CssSelectors.ATTRIBUTE_SUFFIX:
                  attribute = new AttributeSuffix(att.image.toLowerCase(), val.image);
                  break;
              default:
                  attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                  break;
              }
              try {
                  s.addAttribute(attribute);
//	      	  s.addAttribute(att.image.toLowerCase(), val.image, 
//			     selectorType);
              } catch (InvalidParamException e) {
                  removeThisRule();
                  ac.getFrame()
                     .addError(new CssError(getSourceFile(), getBeginLine(),
                         getBeginColumn(), getEndLine(), getEndColumn(), e));
              }
          }
  }

  final public void negation(CssSelectors s) throws ParseException {Token n;
    CssSelectors ns = new CssSelectors(ac, null);
    jj_consume_token(FUNCTIONNOT);
    label_123:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[178] = jj_gen;
        break label_123;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case ANY:
    case 136:{
      element_name(ns);
      break;
      }
    case HASHIDENT:
    case HASH:{
      hash(ns);
      break;
      }
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case CLASS:{
      _class(ns);
      break;
      }
    case LBRACKET:{
      attrib(ns);
      break;
      }
    case COLON:
    case PSEUDOELEMENT_SYM:{
      pseudo(ns);
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_124:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        break label_124;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LPARAN);
s.setPseudoFun("not", ns.toString());
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void pseudo(CssSelectors s) throws ParseException {Token n;
Token language = null;
CssExpression param = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PSEUDOELEMENT_SYM:{
      jj_consume_token(PSEUDOELEMENT_SYM);
      n = ident();
try {
            // should be >CSS3
                if (ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0) {
                    s.addPseudoElement(convertIdent(n.image).toLowerCase());
                } else {
                    {if (true) throw new InvalidParamException("pseudo-element",
                                                    "::" + convertIdent(n.image).toLowerCase() ,
                                                    ac.getCssVersionString() ,ac);}
                }
            } catch(InvalidParamException e) {
                //	removeThisRule();
                //		ac.getFrame().addError(new CssError(e));
                validSelector = false;
                {if (true) throw new ParseException(e.getMessage());}
            }
      break;
      }
    case COLON:{
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
try {
                    s.addPseudoClass(convertIdent(n.image).toLowerCase());
                } catch(InvalidParamException e) {
                    removeThisRule();
                    ac.getFrame()
                       .addError(new CssError(getSourceFile(), getBeginLine(),
                           getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONLANG:
      case FUNCTION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONLANG:{
          n = jj_consume_token(FUNCTIONLANG);
          label_125:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[181] = jj_gen;
              break label_125;
            }
            jj_consume_token(S);
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NUMBER:{
            language = jj_consume_token(NUMBER);
            break;
            }
          case AND:
          case OR:
          case ONLY:
          case NOT:
          case IDENT:{
            language = ident();
            break;
            }
          case STRING:{
            language = jj_consume_token(STRING);
            break;
            }
          default:
            jj_la1[182] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_126:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[183] = jj_gen;
              break label_126;
            }
            jj_consume_token(S);
          }
try {
                    s.setPseudoFun(convertStringIndex(n.image, 0,
                                                      n.image.length() -1, false).toLowerCase(),
                                   convertIdent(language.image));
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame()
                           .addError(new CssError(getSourceFile(), getBeginLine(),
                               getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
          break;
          }
        case FUNCTION:{
          n = jj_consume_token(FUNCTION);
          label_127:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[184] = jj_gen;
              break label_127;
            }
            jj_consume_token(S);
          }
          param = expression();
try {
                    s.setPseudoFun(convertStringIndex(n.image, 0,
                                                      n.image.length() -1,
                                                      false).toLowerCase(),
                                   param.toString());
                } catch(InvalidParamException e) {
                    removeThisRule();
                    ac.getFrame()
                       .addError(new CssError(getSourceFile(), getBeginLine(),
                           getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
          break;
          }
        default:
          jj_la1[185] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPARAN);
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void hash(CssSelectors s) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:{
      n = jj_consume_token(HASHIDENT);
n.image = n.image.substring(1);
      if(Character.isDigit(n.image.charAt(0))) {

      CssVersion version = ac.getCssVersion();

      if (version != CssVersion.CSS1) {
              // the id with the first digit escaped
              String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
              cl += n.image.substring(1);

              addError(new ParseException(ac.getMsg().getString(
                "parser.old_id")),
                "To make \"." + n.image + "\" a valid id, CSS2" +
                " requires the first digit to be escaped " +
                "(\"#" + cl + "\")");
              // for css > 1, we add the rule to have a context, 
              // and we then remove it
              s.addId(new IdSelector(n.image));
              removeThisRule();
          }
          else {
              CssLength length = new CssLength();
              boolean isLength = false;
              try {
                  length.set(n.image, ac);
                  isLength = true;
              }
              catch(Exception e) {
                  isLength = false;
              }
              if(isLength) {
                  addError(new ParseException(ac.getMsg().getString(
                  "parser.id_dim")), n.image);
                  // we add the rule to have a context, and then we remove it
                  s.addId(new IdSelector(n.image));
                  removeThisRule();
              }
              else {
                  try {
                      s.addId(new IdSelector(n.image));
                      ac.getFrame().addWarning("old_id");
                  } catch (InvalidParamException e) {
                      ac.getFrame()
                         .addError(new CssError(getSourceFile(), getBeginLine(),
                             getBeginColumn(), getEndLine(), getEndColumn(), e));
                      removeThisRule();
                  }
              }
          }
      }
      else {
          try {
              s.addId(new IdSelector(n.image));
          } catch (InvalidParamException e) {
              ac.getFrame()
                 .addError(new CssError(getSourceFile(), getBeginLine(),
                     getBeginColumn(), getEndLine(), getEndColumn(), e));
              removeThisRule();
          }
      }
      break;
      }
    case HASH:{
      n = jj_consume_token(HASH);
{if (true) throw new ParseException(ac.getMsg().getString("parser.invalid_id_selector"));}
      break;
      }
    default:
      jj_la1[188] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssProperty mediadeclaration() throws ParseException {String string_property;
  CssExpression values = null;
  boolean important = false;
  setMediaDeclaration(true);
    try {
      string_property = property();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        label_128:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[189] = jj_gen;
            break label_128;
          }
          jj_consume_token(S);
        }
        values = expr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORTANT_SYM:{
          important = prio();
          break;
          }
        default:
          jj_la1[190] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[191] = jj_gen;
        ;
      }
try {
            if ( string_property == null) { // hack return code
                {if ("" != null) return null;}
            }
            setImportant(important);

            if (incompatible_error) {
                {if (true) throw new InvalidParamException("notforcss1", "inherit", ac);}
            }

            CssProperty p = handleDeclaration(string_property.toLowerCase(),
                                                  values, important);
            {if ("" != null) return p;}

        } catch (InvalidParamException e) {
                incompatible_error = false;
                if (null != values) {
                        values.starts();
                }
                addError(e, (CssExpression) values);
        }
        {if ("" != null) return null;}
    } catch (NumberFormatException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (ParseException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } finally {
setMediaDeclaration(false);
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssProperty declaration() throws ParseException {String string_property;
  CssExpression values;
  boolean important = false;
    try {
      string_property = property();
      jj_consume_token(COLON);
      label_129:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[192] = jj_gen;
          break label_129;
        }
        jj_consume_token(S);
      }
      values = expr();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORTANT_SYM:{
        important = prio();
        break;
        }
      default:
        jj_la1[193] = jj_gen;
        ;
      }
try {
            if (string_property == null) {
              {if ("" != null) return null;}
            }
            setImportant(important);

            if (incompatible_error) {
                {if (true) throw new InvalidParamException("notforcss1", "inherit", ac);}
            }

            if (values.getCount() != 0) {
                CssProperty p = handleDeclaration(string_property.toLowerCase(),
                                                  values, important);
                // Did the property recognize all values in the expression ?

                if (!values.end() && ac.getMedium() == null) {
                        addError(new InvalidParamException("unrecognize", "", ac),
                             values);
                } else {
                    // ok, return the new property
                    {if ("" != null) return p;}
                }
            }
        } catch (InvalidParamException e) {
            incompatible_error = false;
            if (e instanceof WarningParamException) {
                WarningParamException warningException =
                    (WarningParamException) e;
                ac.getFrame().addWarning(warningException.getMessage(),
                                         warningException.getMessageArgs());
            } else {
                values.starts();
                addError(e, (CssExpression) values);
            }
        }
        {if ("" != null) return null;}
    } catch (NumberFormatException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (ParseException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (NullPointerException e) {
// NullPointerException happen if in handling a property
        // something bad happen (like setting values on sub properties
        // that had not been initialized (for an unknown reason yet).
     skipAfterExpression(e);
     {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_130:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        break label_130;
      }
      jj_consume_token(S);
    }
{if ("" != null) return true;}
    throw new Error("Missing return statement in function");
  }

  final public CssExpression expression() throws ParseException {CssExpression exp = new CssExpression();
    char operator = ' ';
    Token n = null;
    label_131:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
operator = '+' ;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
operator = '-';
        break;
        }
      case NUMBER:{
        n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n, PERCENTAGE);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
setValue(new CssIdent(), exp, operator, n, IDENT);
        break;
        }
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
setValue(new CssIdent(), exp, operator, n, IDENT);
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_132:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[196] = jj_gen;
          break label_132;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case STRING:
      case IDENT:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:{
        ;
        break;
        }
      default:
        jj_la1[197] = jj_gen;
        break label_131;
      }
    }
{if ("" != null) return exp;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssExpression expr() throws ParseException {CssExpression values = new CssExpression();
    try {
      term(values);
      label_133:
      while (true) {
        if (jj_2_6(2)) {
          ;
        } else {
          break label_133;
        }
        operator(values);
        term(values);
      }
    } catch (WarningParamException e) {
ac.getFrame().addWarning(e.getMessage(), e.getMessageArgs());
    }
{if ("" != null) return values;}
    throw new Error("Missing return statement in function");
  }

  final public void mediarange(AtRuleMedia mediaRule, boolean defaultMedia, String combinator) throws ParseException {Token n;
  Token c1 = null;
  Token c2 = null;
  CssValue func;
  String mediaFeatureName;
  CssExpression val1 = null;
  CssExpression val2 = null;
  CssComparator comp1 = null;
  CssComparator comp2 = null;
  boolean nameIsFirst = false;
    jj_consume_token(RPARAN);
    label_134:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[198] = jj_gen;
        break label_134;
      }
      jj_consume_token(S);
    }
    if (jj_2_7(3)) {
      n = ident();
nameIsFirst = true;
      label_135:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[199] = jj_gen;
          break label_135;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GREATER:{
        c1 = jj_consume_token(GREATER);
        break;
        }
      case GREATEREQ:{
        c1 = jj_consume_token(GREATEREQ);
        break;
        }
      case EQ:{
        c1 = jj_consume_token(EQ);
        break;
        }
      case 135:{
        c1 = jj_consume_token(135);
        break;
        }
      case 137:{
        c1 = jj_consume_token(137);
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_136:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[201] = jj_gen;
          break label_136;
        }
        jj_consume_token(S);
      }
      val1 = mediaexpr();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case STRING:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case URL:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case SPL:
      case ST:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN_9:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case IMPORTANT_NOT:
      case UNICODERANGE:
      case FUNCTIONCALC:
      case FUNCTIONMIN:
      case FUNCTIONMAX:
      case FUNCTIONCLAMP:
      case FUNCTION:{
        val1 = mediaexpr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case GREATER:{
          c1 = jj_consume_token(GREATER);
          break;
          }
        case GREATEREQ:{
          c1 = jj_consume_token(GREATEREQ);
          break;
          }
        case EQ:{
          c1 = jj_consume_token(EQ);
          break;
          }
        case 135:{
          c1 = jj_consume_token(135);
          break;
          }
        case 137:{
          c1 = jj_consume_token(137);
          break;
          }
        default:
          jj_la1[202] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_137:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[203] = jj_gen;
            break label_137;
          }
          jj_consume_token(S);
        }
        n = ident();
        label_138:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[204] = jj_gen;
            break label_138;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case GREATER:
        case GREATEREQ:
        case EQ:
        case 135:
        case 137:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case GREATER:{
            c2 = jj_consume_token(GREATER);
            break;
            }
          case GREATEREQ:{
            c2 = jj_consume_token(GREATEREQ);
            break;
            }
          case EQ:{
            c2 = jj_consume_token(EQ);
            break;
            }
          case 135:{
            c2 = jj_consume_token(135);
            break;
            }
          case 137:{
            c2 = jj_consume_token(137);
            break;
            }
          default:
            jj_la1[205] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_139:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[206] = jj_gen;
              break label_139;
            }
            jj_consume_token(S);
          }
          val2 = mediaexpr();
          break;
          }
        default:
          jj_la1[207] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[208] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(LPARAN);
    label_140:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[209] = jj_gen;
        break label_140;
      }
      jj_consume_token(S);
    }
if (defaultMedia) {
            mediaRule.addMedia(null, null, ac);
          }
          mediaFeatureName = convertIdent(n.image);
          // c1 should always be not null.
          if (c1 != null) {
              comp1 = new CssComparator();
              comp1.set(c1.image, val1, ac);
          }
          if (c2 != null) {
              comp2 = new CssComparator();
              comp2.set(c2.image, val2, ac);
          }
          // we construct a fake one that starts with comparator then expression (doubled if necessary)
          CssExpression nex = new CssExpression();
          nex.addValue(comp1);
          if (comp2 != null) {
              nex.addValue(comp2);
          }
          MediaFeature mf = handleMediaFeature(mediaRule, mediaFeatureName, nex);
          ((MediaRangeFeature)mf).comparatorNameFirst = nameIsFirst;
          if (mf != null) {
              mediaRule.addMediaFeature(mf, ac);
              mf.setCombinator(combinator);
            // mf.setParens();
          }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssExpression mediaexpr() throws ParseException {CssExpression values = new CssExpression();
    mediaterm(values);
    label_141:
    while (true) {
      if (jj_2_8(2)) {
        ;
      } else {
        break label_141;
      }
      operator(values);
      mediaterm(values);
    }
{if ("" != null) return values;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void term(CssExpression exp) throws ParseException {Token n;
  char operator = ' ';
  CssValue func;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case PROGID:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case SPL:
    case ST:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN_9:
    case DIMEN:
    case PERCENTAGE:
    case NUMBER:
    case IMPORTANT_NOT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n, PERCENTAGE);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
setValue(new CssLength(), exp, operator, n, RELFONTLENGTH);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
setValue(new CssLength(), exp, operator, n, RELVIEWLENGTH);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
setValue(new CssLength(), exp, operator, n, ABSOLUTLENGTH);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
setValue(new CssFlexibleLength(), exp, operator, n, FLEX);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
setValue(new CssAngle(), exp, operator, n, ANGLE);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
setValue(new CssTime(), exp, operator, n, TIME);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
setValue(new CssFrequency(), exp, operator, n, FREQ);
        break;
        }
      case RESOLUTION:{
        n = jj_consume_token(RESOLUTION);
setValue(new CssResolution(), exp, operator, n, RESOLUTION);
        break;
        }
      case ST:{
        n = jj_consume_token(ST);
setValue(new CssSemitone(), exp, operator, n, ST);
        break;
        }
      case SPL:{
        n = jj_consume_token(SPL);
setValue(new CssVolume(), exp, operator, n, SPL);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
String dimen = n.image.trim();
            if ("0\\0".equals(dimen) && ac.getTreatCssHacksAsWarnings()) {
                exp.markCssHack();
                ac.getFrame().addWarning("css-hack", dimen);
            } else {
                addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), dimen);
            }
        break;
        }
      case PROGID:{
        n = jj_consume_token(PROGID);
if (ac.getTreatVendorExtensionsAsWarnings()) {
                 {if (true) throw new WarningParamException("vendor-extension", n.image);}
             } else {
                 {if (true) throw new ParseException(String.format(ac.getMsg()
                         .getString("warning.vendor-extension"), n.image));}
             }
        break;
        }
      case IMPORTANT_NOT:{
        n = jj_consume_token(IMPORTANT_NOT);
if (ac.getTreatCssHacksAsWarnings()) {
               {if (true) throw new WarningParamException("css-hack", n.image.trim());}
           } else {
               {if (true) throw new ParseException(String.format(ac.getMsg()
                       .getString("warning.css-hack"), n.image.trim()));}
           }
        break;
        }
      case DIMEN_9:{
        n = jj_consume_token(DIMEN_9);
if (ac.getTreatCssHacksAsWarnings()) {
                ac.getFrame().addWarning("css-hack", n.image.trim());
                exp.markCssHack();
            } else {
                addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), n.image);
            }
        break;
        }
      default:
        jj_la1[211] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case STRING:
    case IDENT:
    case HASHIDENT:
    case HASH:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case URL:
    case UNICODERANGE:
    case FUNCTIONCALC:
    case FUNCTIONMIN:
    case FUNCTIONMAX:
    case FUNCTIONCLAMP:
    case FUNCTIONATTR:
    case FUNCTIONVAR:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FUNCTIONCALC:{
        func = mathcalc();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONMAX:{
        func = mathmax();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONMIN:{
        func = mathmin();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONCLAMP:{
        func = mathclamp();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONATTR:{
        func = attr();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONVAR:{
        n = jj_consume_token(FUNCTIONVAR);
        label_142:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[212] = jj_gen;
            break label_142;
          }
          jj_consume_token(S);
        }
        jj_consume_token(CUSTOM_PROPERTY_NAME);
        label_143:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[213] = jj_gen;
            break label_143;
          }
          jj_consume_token(COMMA);
          label_144:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[214] = jj_gen;
              break label_144;
            }
            jj_consume_token(S);
          }
          expr();
        }
        label_145:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[215] = jj_gen;
            break label_145;
          }
          jj_consume_token(S);
        }
        jj_consume_token(LPARAN);
        break;
        }
      case FUNCTION:{
        func = function();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case DIV:{
        n = jj_consume_token(DIV);
setValue(new CssSwitch(), exp, operator, n, DIV);
        break;
        }
      case LBRACKET:
      case RBRACKET:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case RBRACKET:{
          n = jj_consume_token(RBRACKET);
          break;
          }
        case LBRACKET:{
          n = jj_consume_token(LBRACKET);
          break;
          }
        default:
          jj_la1[216] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
setValue(new CssBracket(), exp, operator, n, RBRACKET);
        break;
        }
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
/*
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 */
            Token t = getToken(1);
            Token semicolon = new Token();
            semicolon.kind = SEMICOLON;
            semicolon.image = ";";
            if (t.kind == COLON) {
                /* @@SEEME. (generate a warning?) */
                /* @@SEEME if expression is a single ident, 
		   generate an error ? */
                addError(new ParseException(String.format(ac.getMsg().getString("parser.semi-colon"), n)),
                         (CssExpression) null);
                rejectToken(semicolon);
            } else {
                setValue(new CssIdent(), exp, operator, n, IDENT);
            }
        break;
        }
      case HASHIDENT:
      case HASH:{
        hashident(exp);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
CssURL _u = new CssURL();
            _u.set(n.image, ac, url);
            exp.addValue(_u);
        break;
        }
      case UNICODERANGE:{
        n = jj_consume_token(UNICODERANGE);
setValue(new CssUnicodeRange(), exp, operator, n, UNICODERANGE);
        break;
        }
      default:
        jj_la1[217] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[218] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_146:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_146;
      }
      jj_consume_token(S);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void mediaterm(CssExpression exp) throws ParseException {Token n;
  char operator = ' ';
  CssValue func;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case SPL:
    case ST:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN_9:
    case DIMEN:
    case PERCENTAGE:
    case NUMBER:
    case IMPORTANT_NOT:
    case FUNCTIONCALC:
    case FUNCTIONMIN:
    case FUNCTIONMAX:
    case FUNCTIONCLAMP:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        if (jj_2_10(2147483647)) {
          ratio(exp, operator);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NUMBER:{
            n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
            break;
            }
          default:
            jj_la1[220] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n,
                                PERCENTAGE);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
setValue(new CssLength(), exp, operator, n, RELFONTLENGTH);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
setValue(new CssLength(), exp, operator, n, RELVIEWLENGTH);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
setValue(new CssLength(), exp, operator, n, ABSOLUTLENGTH);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
setValue(new CssFlexibleLength(), exp, operator, n, FLEX);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
setValue(new CssAngle(), exp, operator, n, ANGLE);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
setValue(new CssTime(), exp, operator, n, TIME);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
setValue(new CssFrequency(), exp, operator, n, FREQ);
        break;
        }
      case RESOLUTION:{
        n = jj_consume_token(RESOLUTION);
setValue(new CssResolution(), exp, operator, n, RESOLUTION);
        break;
        }
      case ST:{
        n = jj_consume_token(ST);
setValue(new CssSemitone(), exp, operator, n, ST);
        break;
        }
      case SPL:{
        n = jj_consume_token(SPL);
setValue(new CssVolume(), exp, operator, n, SPL);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
String dimen = n.image.trim();
          if ("0\\0".equals(dimen) && ac.getTreatCssHacksAsWarnings()) {
              exp.markCssHack();
              ac.getFrame().addWarning("css-hack", dimen);
          } else {
              addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), dimen);
          }
        break;
        }
      case IMPORTANT_NOT:{
        n = jj_consume_token(IMPORTANT_NOT);
if (ac.getTreatCssHacksAsWarnings()) {
           {if (true) throw new WarningParamException("css-hack", n.image.trim());}
       } else {
           {if (true) throw new ParseException(String.format(ac.getMsg()
                   .getString("warning.css-hack"), n.image.trim()));}
       }
        break;
        }
      case DIMEN_9:{
        n = jj_consume_token(DIMEN_9);
if (ac.getTreatCssHacksAsWarnings()) {
                exp.markCssHack();
                ac.getFrame().addWarning("css-hack", n.image.trim());
            } else {
                addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), n.image.trim());
            }
        break;
        }
      case FUNCTIONCALC:
      case FUNCTIONMIN:
      case FUNCTIONMAX:
      case FUNCTIONCLAMP:
      case FUNCTION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTION:{
          func = function();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        case FUNCTIONCALC:{
          func = mathcalc();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        case FUNCTIONMAX:{
          func = mathmax();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        case FUNCTIONMIN:{
          func = mathmin();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        case FUNCTIONCLAMP:{
          func = mathclamp();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        default:
          jj_la1[221] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[222] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_147:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[223] = jj_gen;
          break label_147;
        }
        jj_consume_token(S);
      }
      break;
      }
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case STRING:
    case IDENT:
    case HASHIDENT:
    case HASH:
    case URL:
    case UNICODERANGE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
/*
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 */
        Token t = getToken(1);
        Token semicolon = new Token();
        semicolon.kind = SEMICOLON;
        semicolon.image = ";";
        if (t.kind == COLON) {
            /* @@SEEME. (generate a warning?) */
            /* @@SEEME if expression is a single ident,
	       generate an error ? */
            addError(new ParseException(String.format(ac.getMsg().getString("parser.semi-colon"), n)),
                     (CssExpression) null);
            rejectToken(semicolon);
        } else {
            setValue(new CssIdent(), exp, operator, n, IDENT);
        }
        break;
        }
      case HASHIDENT:
      case HASH:{
        hashident(exp);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
CssURL _u = new CssURL();
        _u.set(n.image, ac, url);
        exp.addValue(_u);
        break;
        }
      case UNICODERANGE:{
        n = jj_consume_token(UNICODERANGE);
setValue(new CssUnicodeRange(), exp, operator, n,
                                UNICODERANGE);
        break;
        }
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_148:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[225] = jj_gen;
          break label_148;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[226] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public CssCheckableValue mathmin() throws ParseException {CssCheckableValue v;
    CssMin c;
    Token n;
    n = jj_consume_token(FUNCTIONMIN);
    label_149:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[227] = jj_gen;
        break label_149;
      }
      jj_consume_token(S);
    }
    v = mathsum();
if (v.getRawType() != CssTypes.CSS_MIN) {
           c = new CssMin(v);
        } else {
           c = (CssMin) v;
        }
    label_150:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[228] = jj_gen;
        break label_150;
      }
      jj_consume_token(S);
    }
    label_151:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        break label_151;
      }
      jj_consume_token(COMMA);
      label_152:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[230] = jj_gen;
          break label_152;
        }
        jj_consume_token(S);
      }
      v = mathsum();
c.addValue(v);
      label_153:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[231] = jj_gen;
          break label_153;
        }
        jj_consume_token(S);
      }
    }
    jj_consume_token(LPARAN);
c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathmax() throws ParseException {CssCheckableValue v;
    CssMax c;
    Token n;
    n = jj_consume_token(FUNCTIONMAX);
    label_154:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[232] = jj_gen;
        break label_154;
      }
      jj_consume_token(S);
    }
    v = mathsum();
if (v.getRawType() != CssTypes.CSS_MAX) {
           c = new CssMax(v);
        } else {
           c = (CssMax) v;
        }
    label_155:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        break label_155;
      }
      jj_consume_token(S);
    }
    label_156:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        break label_156;
      }
      jj_consume_token(COMMA);
      label_157:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[235] = jj_gen;
          break label_157;
        }
        jj_consume_token(S);
      }
      v = mathsum();
c.addValue(v);
      label_158:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[236] = jj_gen;
          break label_158;
        }
        jj_consume_token(S);
      }
    }
    jj_consume_token(LPARAN);
c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathclamp() throws ParseException {CssCheckableValue v1, v2, v3;
CssClamp c;
Token n;
    n = jj_consume_token(FUNCTIONCLAMP);
    label_159:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        break label_159;
      }
      jj_consume_token(S);
    }
    v1 = mathsum();
    label_160:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[238] = jj_gen;
        break label_160;
      }
      jj_consume_token(S);
    }
    jj_consume_token(COMMA);
    label_161:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        break label_161;
      }
      jj_consume_token(S);
    }
    v2 = mathsum();
    label_162:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[240] = jj_gen;
        break label_162;
      }
      jj_consume_token(S);
    }
    jj_consume_token(COMMA);
    label_163:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        break label_163;
      }
      jj_consume_token(S);
    }
    v3 = mathsum();
    label_164:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        break label_164;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LPARAN);
c = new CssClamp(ac, v1, v2, v3);
        c.validate();
        {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathcalc() throws ParseException {CssCheckableValue v;
CssCalc c;
Token n;
    n = jj_consume_token(FUNCTIONCALC);
    label_165:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[243] = jj_gen;
        break label_165;
      }
      jj_consume_token(S);
    }
    v = mathsum();
    label_166:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        break label_166;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LPARAN);
String funcname = n.image.toLowerCase();
    if (funcname.charAt(0) == '-') {
        if (ac.getTreatVendorExtensionsAsWarnings()) {
            ac.getFrame().addWarning("vendor-extension",
                    funcname.substring(0, funcname.length() - 1));
        } else {
            addError(new ParseException(ac.getMsg()
                    .getString("warning.vendor-extension")),
                funcname);
        }
    }
    if (v.getRawType() != CssTypes.CSS_CALC) {
       c = new CssCalc(v);
    } else {
       c = (CssCalc) v;
    }
    c.validate();
    c.setImplicitFunction(false);
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathsum() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  boolean concat = false;
  int nb_pre_sp;
    v1 = mathproduct();
c = new CssCalc(ac, v1);
                          nb_pre_sp = 0;
    label_167:
    while (true) {
      if (jj_2_11(2)) {
        ;
      } else {
        break label_167;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        o = jj_consume_token(PLUS);
        break;
        }
      case S:
      case MINUS:{
        label_168:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[245] = jj_gen;
            break label_168;
          }
          jj_consume_token(S);
nb_pre_sp++;
        }
        o = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[246] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (o.image.length() < 2 && nb_pre_sp == 0) {
                {if (true) throw new ParseException(ac.getMsg().getString("parser.calcwhitespace"));}
            }
      label_169:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[247] = jj_gen;
          break label_169;
        }
      }
      v2 = mathproduct();
nb_pre_sp = 0;
            if (concat) {
                nc = new CssCalc(ac, c);
                nc.addRightSide(o.image.trim(), v2);
                c = nc;
            } else {
                c.addRightSide(o.image.trim(), v2);
                concat = true;
            }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathproduct() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  char operator = ' ';
  boolean concat = false;
    v1 = mathunit();
c = new CssCalc(ac, v1);
    label_170:
    while (true) {
      if (jj_2_12(2)) {
        ;
      } else {
        break label_170;
      }
      label_171:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[248] = jj_gen;
          break label_171;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANY:{
        o = jj_consume_token(ANY);
        label_172:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[249] = jj_gen;
            break label_172;
          }
          jj_consume_token(S);
        }
        v2 = mathunit();
        break;
        }
      case DIV:{
        o = jj_consume_token(DIV);
        label_173:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[250] = jj_gen;
            break label_173;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          operator = unaryOperator();
          break;
          }
        default:
          jj_la1[251] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NUMBER:{
          n = jj_consume_token(NUMBER);
v2 = new CssNumber(); v2.set(addOperator(operator, n.image), ac);
          break;
          }
        case FUNCTIONVAR:{
          n = jj_consume_token(FUNCTIONVAR);
          label_174:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[252] = jj_gen;
              break label_174;
            }
            jj_consume_token(S);
          }
          jj_consume_token(CUSTOM_PROPERTY_NAME);
          label_175:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[253] = jj_gen;
              break label_175;
            }
            jj_consume_token(COMMA);
            label_176:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[254] = jj_gen;
                break label_176;
              }
              jj_consume_token(S);
            }
            expr();
          }
          label_177:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[255] = jj_gen;
              break label_177;
            }
            jj_consume_token(S);
          }
          jj_consume_token(LPARAN);
          break;
          }
        default:
          jj_la1[256] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (concat) {
                              nc = new CssCalc(ac, c);
                              nc.addRightSide(o.image, v2);
                              c = nc;
                          } else {
                              c.addRightSide(o.image, v2);
                              concat = true;
                          }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathunit() throws ParseException {Token n;
CssCheckableValue v = null;
char operator = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case TIME:
    case FREQ:
    case PERCENTAGE:
    case NUMBER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[258] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
v = new CssNumber(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
v = new CssPercentage(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
v = new CssFlexibleLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
v = new CssAngle(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
v = new CssTime(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
v= new CssFrequency(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case RPARAN:{
      jj_consume_token(RPARAN);
      label_178:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[260] = jj_gen;
          break label_178;
        }
        jj_consume_token(S);
      }
      v = mathsum();
      label_179:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[261] = jj_gen;
          break label_179;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LPARAN);
((CssCalc) v).setParenthesis();
      break;
      }
    case FUNCTIONCALC:{
      v = mathcalc();
      break;
      }
    case FUNCTIONMAX:{
      v = mathmax();
      break;
      }
    case FUNCTIONMIN:{
      v = mathmin();
      break;
      }
    case FUNCTIONCLAMP:{
      v = mathclamp();
      break;
      }
    case FUNCTIONATTR:{
      v = attr();
      break;
      }
    case FUNCTIONVAR:{
      n = jj_consume_token(FUNCTIONVAR);
      label_180:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[262] = jj_gen;
          break label_180;
        }
        jj_consume_token(S);
      }
      jj_consume_token(CUSTOM_PROPERTY_NAME);
      label_181:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[263] = jj_gen;
          break label_181;
        }
        jj_consume_token(COMMA);
        label_182:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[264] = jj_gen;
            break label_182;
          }
          jj_consume_token(S);
        }
        expr();
      }
      label_183:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[265] = jj_gen;
          break label_183;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LPARAN);
      break;
      }
    default:
      jj_la1[266] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue attr() throws ParseException {CssAttr v = null;
Token n = null;
CssExpression exp = null;
    jj_consume_token(FUNCTIONATTR);
    label_184:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        break label_184;
      }
      jj_consume_token(S);
    }
    n = ident();
    label_185:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[268] = jj_gen;
        break label_185;
      }
      jj_consume_token(S);
    }
exp = new CssExpression();
            setValue(new CssIdent(), exp, ' ', n, IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case 131:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
        break;
        }
      case 131:{
        n = jj_consume_token(131);
        break;
        }
      default:
        jj_la1[269] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
setValue(new CssIdent(), exp, ' ', n, IDENT);
      label_186:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[270] = jj_gen;
          break label_186;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[271] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
exp.setOperator(',');
      label_187:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[272] = jj_gen;
          break label_187;
        }
        jj_consume_token(S);
      }
      term(exp);
      break;
      }
    default:
      jj_la1[273] = jj_gen;
      ;
    }
    jj_consume_token(LPARAN);
v = new CssAttr();
       v.setValue(exp, ac);
       {if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssValue function() throws ParseException {Token n,p = null,q = null;
 CssExpression exp;
 CssColor color = new CssColor();
    n = jj_consume_token(FUNCTION);
    label_188:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[274] = jj_gen;
        break label_188;
      }
      jj_consume_token(S);
    }
    if (jj_2_13(2)) {
      exp = expr();
      jj_consume_token(LPARAN);
String funcname = n.image.toLowerCase();
        if (funcname.equals("rgb(")) {
            color.setRGBColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("rgba(")) {
            color.setRGBAColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("hsl(")) {
            color.setHSLColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("hsla(")) {
            color.setHSLColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("hwb(")) {
            color.setHWBColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("lab(")) {
            color.setLABColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("gray(")) {
            color.setGrayColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("lch(")) {
            color.setLCHColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("device-cmyk(")) {
            color.setDeviceCMYKColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("image(")) {
            CssImage img = new CssImage();
            img.setImageList(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("linear-gradient(")) {
            CssImage img = new CssImage();
            img.setLinearGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-linear-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingLinearGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRadialGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingRadialGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("atsc-rgba(")) {
            if (getAtRule().toString().equals("@media atsc-tv")) {
                color.setATSCRGBAColor(ac, exp);
                {if ("" != null) return color;}
            } else {
                addError(new InvalidParamException("onlyATSC", "", ac),
                                                 getAtRule().toString());
                {if ("" != null) return null;}
            }
        } else {
            CssFunction f = new CssFunction();
            f.set(n.image.substring(0, n.image.length() - 1), exp);
            if (funcname.charAt(0) == '-') {
                exp.markVendorExtension();
            }
            {if ("" != null) return f;}
        }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        p = ident();
        jj_consume_token(EQ);
        q = jj_consume_token(NUMBER);
        jj_consume_token(LPARAN);
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
// this one is for vendor extension like alpha(opacity=50);
        exp = new CssExpression();
        setValue(new CssIdent(), exp, ' ', p, IDENT);
        exp.setOperator(CssOperator.EQUAL);
        setValue(new CssNumber(), exp, ' ', q, NUMBER);
        exp.markVendorExtension();

        CssFunction f = new CssFunction();
        f.set(n.image.substring(0, n.image.length() - 1), exp);
        {if ("" != null) return f;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void hashident(CssExpression exp) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:{
      n = jj_consume_token(HASHIDENT);
      break;
      }
    case HASH:{
      n = jj_consume_token(HASH);
      break;
      }
    default:
      jj_la1[276] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
n.image = Util.strip(n.image);
     setValue(new CssHashIdent(), exp, ' ', n, HASH);
  }

  String skipStatement() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok = getToken(0);
    boolean first = true;

    if (tok.image != null) {
        s.append(tok.image);
    }
    /* FIXME here, two option, we skip during an error, or outside
       an error, currently both can fail with a TokenMgrError, should
       we catch all, or only when filling message for errors? 
       
       -> taking the "always skip" approach.
    */
    while (true) {
        try {
            tok = getToken(1);
            if (tok.kind == EOF) {
                if (first) {
                    return null;
                } else {
                    break;
                }
            }
            s.append(tok.image);
            if (tok.kind == LBRACE) {
                getNextToken();
                s.append(skip_to_matching_brace());
                getNextToken();
                tok = getToken(1);
                break;
            } else if ((tok.kind == RBRACE) || (tok.kind == SEMICOLON)) {
                getNextToken();
                tok = getToken(1);
                break;
            }
            getNextToken();
        } catch (TokenMgrError tokenerror) {
            // read one char at a time, and loop
            try {
                s.append(jj_input_stream.readChar());
                continue;
            } catch (java.io.IOException ioex) {
                return s.toString().trim();
            }
        }
        first = false;
    }

    // skip white space
    while (tok.kind == S) {
        getNextToken();
        tok = getToken(1);
    }
    String statement = s.toString().trim();
    return statement;
  }

  String skip_to_matching_brace() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok;
    int nesting = 1;
    /* FIXME
       same as above */
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            nesting++;
        } else if (tok.kind == RBRACE) {
            nesting--;
            if (nesting == 0) {
                break;
            }
        }
        getNextToken();
    }
    return s.toString();
  }

  void rejectToken(Token t) throws ParseException {Token fakeToken = new Token();
    t.next = token;
    fakeToken.next = t;
    token = fakeToken;
  }

  void skipAfterExpression(Exception e) throws ParseException {StringBuilder s = new StringBuilder();
    s.append(getToken(0).image);
    while (true) {
        try {
            Token t = getToken(1);
            if (t.kind == LBRACE) {
                s.append(t.image);
                getNextToken();
                s.append(skip_to_matching_brace());
                getNextToken();
                t = getToken(1);
                continue;
            }
            if ((t.kind == SEMICOLON) || (t.kind == RBRACE)
                                      || (t.kind == EOF)) {
                break;
            }
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        } catch (TokenMgrError tmerr) {
            try {
                s.append(jj_input_stream.readChar());
                continue;
            } catch (java.io.IOException ioex) {
                ioex.printStackTrace();
                break;
            }
        }
    }
    String statement = s.toString().trim();
    addError(e, s.toString());
  }

  String convertStringIndex(String s, int start, int len, boolean escapeFirst) throws ParseException {int index = start;
    int t;
    int maxCount = 0;
    if ((start == 0) && (len == s.length()) && (s.indexOf('\\') == -1)) {
        return s;
    }
    StringBuilder buf = new StringBuilder(len);

    while (index < len) {
        char c = s.charAt(index);
        if (c == '\\') {
            if (++index < len) {
                c = s.charAt(index);
                switch (c) {
                case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
                case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
                case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
                    int numValue = Character.digit(c, 16);
                    int count = 1;
                    if (maxCount == 0) {
                        maxCount = ((ac.getCssVersion() == CssVersion.CSS1) ?
                                    4 : 6);
                    }
                    while (index + 1 < len) {
                        c = s.charAt(index+1);
                        t = Character.digit(c, 16);
                        if (t != -1 && count++ < maxCount) {
                            numValue = (numValue<<4) | t;
                            index++;
                        } else {
                            if (c == ' ' || c == '\t' ||
                                c == '\n' || c == '\f' ) {
                                // skip the latest white space
                                index++;
                            } else if ( c == '\r' ) {
                                index++;
                                // special case for \r\n
                                if (index+1 < len) {
                                    if (s.charAt(index + 1) == '\n') {
                                        index++;
                                    }
                                }
                            }
                            break;
                        }
                    }
                    if (!escapeFirst && numValue < 255 && numValue>31) {
                        if (! ( (numValue>96 && numValue<123) // [a-z]
                                || (numValue>64 && numValue<91) // [A-Z]
                                || (numValue>47 && numValue<58) // [0-9]
                                || (numValue == 95) // _
                                || (numValue == 45) // -
                                )
                            ) {
                            buf.append('\\');
                        }
                        buf.append((char) numValue);
                        break;
                    }
                    char b[] = new char[maxCount];
                    t = maxCount;
                    while (t > 0) {
                        b[--t] = hexdigits[numValue & 0xF];
                        numValue >>>= 4;
                    }
                    buf.append('\\').append(b);
                    break;
                case '\n':
                case '\f':
                    break;
                case '\r':
                    if (index + 1 < len) {
                        if (s.charAt(index + 1) == '\n') {
                            index ++;
                        }
                    }
                    break;
                case '-' : case '_' : case 'g' : case 'G' :
                case 'h' : case 'H' : case 'i' : case 'I' :
                case 'j' : case 'J' : case 'k' : case 'K' :
                case 'l' : case 'L' : case 'm' : case 'M' :
                case 'n' : case 'N' : case 'o' : case 'O' :
                case 'p' : case 'P' : case 'q' : case 'Q' :
                case 'r' : case 'R' : case 's' : case 'S' :
                case 't' : case 'T' : case 'u' : case 'U' :
                case 'v' : case 'V' : case 'w' : case 'W' :
                case 'x' : case 'X' : case 'y' : case 'Y' :
                case 'z' : case 'Z' :
                    buf.append(c);
                    break;
                default:
                    buf.append('\\').append(c);
                }
            } else {
                throw new ParseException("invalid string");
            }
        } else {
            buf.append(c);
        }
        escapeFirst = false;
        index++;
    }
    return buf.toString();
  }

  String convertIdent(String s) throws ParseException {return convertStringIndex(s, 0, s.length(), false);
  }

  String convertClassIdent(String s) throws ParseException {return convertStringIndex(s, 0, s.length(), true);
  }

  String convertString(String s) throws ParseException {return convertStringIndex(s, 0, s.length(), false);
  }

  String hexEscapeFirst(String s) throws ParseException {StringBuilder sb = new StringBuilder();
    sb.append('\\').append(Integer.toString(s.charAt(0), 16));
    char c = s.charAt(1);
    if (((c >= '0') && (c <= '9')) ||
        ((c >= 'A') && (c <= 'F')) ||
        ((c >= 'a') && (c <= 'f'))) {
        sb.append(' ');
    }
    sb.append(s.substring(1));
    return sb.toString();
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_3R_322()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_scan_token(FUNCTIONCLAMP)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(COMMA)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_321()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_324()) jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_scan_token(RPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENT)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_317()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) return true;
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(RPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) return true;
    }
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_3R_317()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_scan_token(FUNCTIONMAX)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_322()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(NOT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(FUNCTIONMIN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_323()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_193()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_scan_token(NUMBER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DIV)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_212()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3R_268()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_scan_token(DIMEN_9)) return true;
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(IMPORTANT_NOT)) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_scan_token(NUMBER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_scan_token(SPL)) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_scan_token(ST)) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    if (jj_scan_token(RESOLUTION)) return true;
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) return true;
    }
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_252()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_197()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) return true;
    }
    return false;
  }

  private boolean jj_3R_291()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_3R_195()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) return true;
    }
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_scan_token(FUNCTIONVAR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CUSTOM_PROPERTY_NAME)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_326()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_210()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(DIMEN_9)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_scan_token(IMPORTANT_NOT)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_201()) return true;
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(PROGID)) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_scan_token(SPL)) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(ST)) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(RESOLUTION)) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) return true;
    }
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_193()) return true;
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_327()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) return true;
    }
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_3R_197()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_8()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_scan_token(FUNCTIONATTR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_195()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_327()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_328()) jj_scanpos = xsp;
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    }
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_scan_token(FUNCTIONVAR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CUSTOM_PROPERTY_NAME)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_325()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_scan_token(RPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_195()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_299()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_214()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_scan_token(FUNCTIONVAR)) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_215()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    }
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_3R_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_195()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_219()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(RPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(RPARAN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_193()) return true;
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_3R_214()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_3R_194()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_6()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(NOT)) return true;
    Token xsp;
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_3R_318()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_11()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_195()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_192()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_scan_token(FUNCTIONCALC)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_313()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_320()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_192()) jj_scanpos = xsp;
    if (jj_scan_token(136)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CssParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[277];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0xe00000,0xe00000,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0xc00000,0xc00000,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x80000000,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0xa8000000,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x0,0x200000,0x80000000,0x200000,0x0,0x0,0x0,0x200000,0x18000000,0x18000000,0x18000000,0x200000,0x200000,0x200000,0x200000,0x18000000,0x80000000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x80000000,0x28000000,0x200000,0x200000,0x28200000,0x18000000,0xa8000000,0xa8000000,0xa8000000,0x200000,0x0,0x200000,0xa8000000,0x80000000,0x200000,0x200000,0x200000,0xa8000000,0x0,0x200000,0xa8000000,0x200000,0x28200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x3000000,0x200000,0x0,0x200000,0x3000000,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x0,0x200000,0x18000000,0x200000,0x18000000,0x200000,0x200000,0x60000000,0x200000,0x60000000,0x200000,0x200000,0x60000000,0x200000,0x60000000,0x18000000,0x200000,0x18000000,0x0,0x200000,0x80000000,0x200000,0x200000,0x0,0x0,0x18000000,0x18000000,0x0,0x0,0x0,0x200000,0x0,0x200000,0x18000000,0x200000,0x200000,0x80000000,0x200000,0x200000,0x200000,0x200000,0x80000000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x18200000,0x200000,0x200000,0x200000,0x200000,0x18000000,0x200000,0x80000000,0x200000,0x200000,0x0,0x0,0x18000000,0x0,0x200000,0x200000,0x200000,0x80000000,0x200000,0x200000,0x18000000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x80000000,0x200000,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9e,0x0,0x0,0x0,0xba28039e,0x0,0x0,0x0,0x0,0x0,0x9e,0x4000020,0x0,0x0,0x0,0x4000020,0x0,0x1000098,0x0,0x0,0x1000098,0x0,0xba28039e,0xba28039e,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x18,0x0,0x0,0x2,0x98,0x0,0x0,0x2,0x0,0x4,0x6,0x6,0x1000010,0x0,0x2,0x0,0x1000010,0x0,0x0,0x1000000,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0xba28039e,0xba28039e,0x0,0x0,0x0,0x2,0x0,0x4,0x6,0x6,0x1000010,0x0,0x3bd099f,0x0,0x1000000,0x0,0x9e,0x0,0x0,0x0,0x0,0x200009e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x200009e,0x0,0x0,0x0,0x2000000,0x2000000,0x200009e,0x0,0x0,0x0,0x9e,0x0,0x0,0x0,0x0,0x9e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x3bd0001,0x3bd0001,0x3bd089f,0x0,0x100,0x0,0x3bd099f,0x0,0x0,0x0,0x0,0x3bd099f,0x20000,0x0,0x3bd099f,0x0,0x1,0x0,0x0,0xba080300,0xba080300,0xba080300,0xba080300,0xba28039e,0xb8000000,0xb8000000,0x20009e,0x20009e,0x20009e,0x0,0x0,0x1e000,0x0,0xbe,0x0,0x1e000,0x0,0xba28039e,0x0,0x0,0xbe,0x0,0x0,0x0,0x9e,0x2000000,0x300,0x0,0x0,0x2000000,0x0,0x0,0x0,0xbe,0x0,0xbe,0x0,0x0,0x10000,0x0,0x10000,0x0,0x0,0x10000,0x0,0x10000,0xfc0003be,0x0,0x0,0xf8000400,0x0,0x0,0x0,0x0,0x180000,0x41c03be,0xfc1c07be,0x0,0x0,0x0,0xf8000000,0x0,0x40003be,0x0,0xfc0003be,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x240000,0x0,0xf8000000,0x0,0x0,0x0,0x0,0x0,0x0,0xf9000000,0x0,0x0,0x9e,0x0,0x9e,0x0,0x0,0x0,0x9e,0x300,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x1000,0x0,0x0,0x40000000,0x80000000,0x0,0x0,0x0,0x2000,0x285c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x285c,0x285c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x285c,0x285c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fffc000,0x3fffc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x85c,0x85c,0x85c,0x85c,0x85c,0x5c,0x5c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x85c,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x1c0,0x0,0x1c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ff,0x0,0x0,0x5ff,0x0,0x0,0x0,0x0,0x0,0x0,0x5ff,0x0,0x100,0x0,0x5ff,0x0,0x0,0x0,0x5ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x18c,0x0,0x0,0x0,0x0,0x0,0x0,0x18c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7df,0xa007df,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa007df,0xa007df,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa007df,0xa007df,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200400,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200400,0x0,0x200400,0x0,0x0,0x0,0x0,0x200400,0x0,0x0,0x200400,0x0,0x0,0x0,0x0,0xa00000,0xa00000,0xa00000,0xa00000,0xa00000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x40400000,0x40400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4f100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f100000,0x7f100000,0x0,0x0,0x4f000000,0x4f000000,0x0,0x100000,0x0,0x4f100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fe,0x1fe,0x1fe,0x0,0x0,0x0,0x1fe,0x0,0x0,0x0,0x0,0x1fe,0x0,0x0,0x1fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x280,0x0,0x280,0x0,0x0,0x280,0x0,0x280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[13];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CssParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CssParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CssParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 277; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 277; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CssParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CssParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 277; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 277; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CssParser(CssParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 277; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CssParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 277; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[138];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 277; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 138; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 13; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
