/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.maven.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import nu.validator.maven.plugin.NVUValidatorConfiguration;
import nu.validator.maven.plugin.NVUValidatorMojo;
import nu.validator.maven.plugin.ValidationError;
import nu.validator.maven.plugin.XMLErrorHandler;
import nu.validator.maven.plugin.configuration.DocumentType;
import nu.validator.maven.plugin.configuration.FileSetCfg;
import nu.validator.maven.plugin.configuration.FilterCfg;
import nu.validator.maven.plugin.configuration.ValidatorCfg;
import nu.validator.validation.SimpleDocumentValidator;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class NVUValidator {
    private static final String SCHEMA_URL_HTML = "http://s.validator.nu/html5-all.rnc";
    private static final String SCHEMA_URL_SVG = "http://s.validator.nu/svg-xhtml5-rdf-mathml.rnc";
    private static final String SCHEMA_URL_XHTML = "http://s.validator.nu/xhtml5-all.rnc";
    private final XMLErrorHandler errorHandler;
    private final FileSystem fileSystem;
    private final Log log;
    private final NVUValidatorConfiguration configuration;
    private final String nvuVersion = SimpleDocumentValidator.class.getPackage().getImplementationVersion();

    NVUValidator(MavenProject project, FileSystem fileSystem, Log log, NVUValidatorConfiguration configuration) {
        log.info((CharSequence)("Running Nu HtmlChecker (v.Nu) v" + this.nvuVersion));
        this.fileSystem = fileSystem;
        this.log = log;
        this.errorHandler = new XMLErrorHandler(configuration.isAsciiquotes(), project.getBasedir());
        this.configuration = configuration;
    }

    private boolean trueOrFailIf(boolean fail) throws MojoFailureException {
        if (fail) {
            throw new MojoFailureException("Validation failed");
        }
        return true;
    }

    void validate() throws MojoFailureException {
        boolean failed = false;
        for (FileSetCfg fileset : this.configuration.getFilesets()) {
            this.errorHandler.clear();
            if (this.validateFileset(this.setupDocumentValidator(), fileset, this.configuration.getValidatorCfg())) continue;
            failed = this.trueOrFailIf(this.configuration.isFailfast());
        }
        if (failed) {
            throw new MojoFailureException("Validation failed");
        }
    }

    private SimpleDocumentValidator setupDocumentValidator() {
        SimpleDocumentValidator documentValidator = new SimpleDocumentValidator(true, false, true);
        this.setSchema(documentValidator, SCHEMA_URL_HTML);
        return documentValidator;
    }

    private void setSchema(SimpleDocumentValidator documentValidator, String schemaUrl) {
        if (!schemaUrl.equals(documentValidator.getMainSchemaUrl())) {
            try {
                documentValidator.setUpMainSchema(schemaUrl, (ErrorHandler)this.errorHandler);
                documentValidator.setUpValidatorAndParsers((ErrorHandler)this.errorHandler, false, false);
            }
            catch (SAXException ex) {
                Logger.getLogger(NVUValidatorMojo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(NVUValidatorMojo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private boolean validateFileset(SimpleDocumentValidator documentValidator, FileSetCfg fileset, ValidatorCfg validatorCfg) throws MojoFailureException {
        this.log.info((CharSequence)("Validating fileset " + fileset.getDirectory()));
        boolean validationFailed = false;
        SortedSet<String> files = this.getFiles(fileset);
        for (String file : files) {
            this.log.debug((CharSequence)("  Validating file " + file));
            try {
                this.checkFile(documentValidator, Paths.get(file, new String[0]).toFile(), validatorCfg);
            }
            catch (FileNotFoundException ex) {
                throw new MojoFailureException(String.format("File not found: %s", file));
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Error reading file: %s", file));
            }
            catch (SAXException ex) {
                this.errorHandler.addError(new ValidationError(ValidationError.Type.WARNING, file, -1, -1, ex.getMessage()));
            }
        }
        int warnings = 0;
        int errors = 0;
        for (ValidationError error : this.errorHandler.getErrors()) {
            block1 : switch (error.getType()) {
                case WARNING: {
                    switch (validatorCfg.getWarnings()) {
                        case WARN: {
                            if (this.isFiltered(error, validatorCfg.getFilters())) break block1;
                            this.log.warn((CharSequence)error.toString());
                            ++warnings;
                            break block1;
                        }
                        case ERROR: {
                            if (this.isFiltered(error, validatorCfg.getFilters())) break block1;
                            this.log.error((CharSequence)error.toString());
                            validationFailed = this.trueOrFailIf(this.configuration.isFailfast());
                            ++errors;
                            break block1;
                        }
                    }
                    break;
                }
                case FATAL: 
                case ERROR: {
                    if (this.isFiltered(error, validatorCfg.getFilters())) break;
                    this.log.error((CharSequence)error.toString());
                    validationFailed = this.trueOrFailIf(this.configuration.isFailfast());
                    ++errors;
                    break;
                }
            }
        }
        this.log.info((CharSequence)String.format("Found %d warnings and %d errors", warnings, errors));
        return !validationFailed;
    }

    private SortedSet<String> getFiles(FileSetCfg fileset) throws MojoFailureException {
        Path srcDirectory = this.getPath(fileset.getDirectory());
        if (!Files.exists(srcDirectory, new LinkOption[0])) {
            throw new MojoFailureException("Mojo error: directory " + fileset.getDirectory() + " does not exist.");
        }
        if (!Files.isDirectory(srcDirectory, new LinkOption[0])) {
            throw new MojoFailureException("Mojo error: " + fileset.getDirectory() + " is not a directory.");
        }
        TreeSet<String> files = new TreeSet<String>();
        PathMatcher pathMatcher = this.fileSystem.getPathMatcher("glob:" + fileset.getGlob());
        try {
            Files.walk(srcDirectory, FileVisitOption.FOLLOW_LINKS).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && pathMatcher.matches(srcDirectory.relativize((Path)path))).forEach(path -> files.add(path.toString()));
        }
        catch (IOException exception) {
            throw new MojoFailureException("Mojo execution failed due to I/O error (" + exception.getMessage() + ").");
        }
        return files;
    }

    private Path getPath(String source) {
        return this.fileSystem.getPath(source, new String[0]);
    }

    private void checkFile(SimpleDocumentValidator documentValidator, File file, ValidatorCfg validatorCfg) throws IOException, SAXException {
        DocumentType documentType;
        if (validatorCfg.getForceType() != null) {
            documentType = validatorCfg.getForceType();
            if (documentType == null) {
                documentType = DocumentType.HTML;
            }
        } else {
            String extension = this.getFileExtension(file.getName());
            documentType = Stream.of(DocumentType.values()).filter(type -> type.getExtensions().contains(extension)).findAny().orElse(null);
            if (documentType == null) {
                this.log.warn((CharSequence)("Unable to determine file type of file " + file.getAbsolutePath()));
            }
        }
        if (documentType != null) {
            switch (documentType) {
                case HTML: {
                    this.checkHtmlFile(documentValidator, file, true);
                    break;
                }
                case CSS: {
                    this.checkCssFile(documentValidator, file, true);
                    break;
                }
                case SVG: {
                    this.checkSvgFile(documentValidator, file);
                    break;
                }
                case XHTML: {
                    this.checkXHTMLFile(documentValidator, file);
                    break;
                }
            }
        }
    }

    private String getFileExtension(String filename) {
        String extension = "";
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            extension = filename.substring(i + 1);
        }
        return extension;
    }

    private boolean isFiltered(ValidationError error, List<FilterCfg> filters) {
        return filters.stream().anyMatch(filter -> (filter.getType() == FilterCfg.FilterType.ALL || filter.getType().getErrorType() == error.getType()) && filter.getPattern().matcher(error.getMessage()).find());
    }

    private void checkHtmlFile(SimpleDocumentValidator documentValidator, File file, boolean asUTF8) throws IOException, SAXException {
        this.setSchema(documentValidator, SCHEMA_URL_HTML);
        documentValidator.checkHtmlFile(file, asUTF8);
    }

    private void checkSvgFile(SimpleDocumentValidator documentValidator, File file) throws IOException, SAXException {
        this.setSchema(documentValidator, SCHEMA_URL_SVG);
        documentValidator.checkXmlFile(file);
    }

    private void checkCssFile(SimpleDocumentValidator documentValidator, File file, boolean asUTF8) throws IOException, SAXException {
        documentValidator.checkCssFile(file, asUTF8);
    }

    private void checkXHTMLFile(SimpleDocumentValidator documentValidator, File file) throws IOException, SAXException {
        this.setSchema(documentValidator, SCHEMA_URL_XHTML);
        documentValidator.checkXmlFile(file);
    }
}

