/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.maven.plugin;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.List;
import nu.validator.maven.plugin.NVUValidator;
import nu.validator.maven.plugin.NVUValidatorConfiguration;
import nu.validator.maven.plugin.configuration.FileSetCfg;
import nu.validator.maven.plugin.configuration.FilterCfg;
import nu.validator.maven.plugin.configuration.MojoInvalidConfigurationException;
import nu.validator.maven.plugin.configuration.ValidatorCfg;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class NVUValidatorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=true)
    private List<FileSetCfg> filesets;
    @Parameter
    private boolean failfast;
    @Parameter
    private boolean asciiquotes = true;
    @Parameter
    private ValidatorCfg validator = new ValidatorCfg();
    private final FileSystem fileSystem;

    NVUValidatorMojo(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public NVUValidatorMojo() {
        this(FileSystems.getDefault());
    }

    public final void execute() throws MojoFailureException {
        NVUValidatorConfiguration configuration = this.prepareConfiguration();
        NVUValidator nvuValidator = new NVUValidator(this.project, this.fileSystem, this.getLog(), configuration);
        nvuValidator.validate();
    }

    private NVUValidatorConfiguration prepareConfiguration() throws MojoFailureException {
        this.validateFilesetConfguration();
        this.compileRegexes(this.validator.getFilters());
        NVUValidatorConfiguration configuration = new NVUValidatorConfiguration();
        configuration.setFailfast(this.failfast);
        configuration.setAsciiquotes(this.asciiquotes);
        configuration.setValidatorCfg(this.validator);
        configuration.setFilesets(this.filesets);
        return configuration;
    }

    private void compileRegexes(List<FilterCfg> filters) throws MojoFailureException {
        for (FilterCfg filter : filters) {
            filter.compilePattern();
        }
    }

    private void validateFilesetConfguration() throws MojoInvalidConfigurationException {
        for (FileSetCfg fileset : this.filesets) {
            fileset.validate();
        }
    }

    public final void setProject(MavenProject project) {
        this.project = project;
    }

    public final void setFilesets(List<FileSetCfg> filesets) {
        this.filesets = filesets;
    }

    public final void setFailfast(boolean failfast) {
        this.failfast = failfast;
    }

    public final void setAsciiquotes(boolean asciiquotes) {
        this.asciiquotes = asciiquotes;
    }

    public final void setValidator(ValidatorCfg validator) {
        this.validator = validator;
    }
}

