/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.maven.plugin;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import nu.validator.maven.plugin.ValidationError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private final boolean asciiQuotes;
    private final Path basePath;
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public XMLErrorHandler(boolean asciiQuotes, File basedir) {
        this.asciiQuotes = asciiQuotes;
        this.basePath = Paths.get(basedir.getAbsolutePath(), new String[0]);
    }

    public void clear() {
        this.errors.clear();
    }

    @Override
    public void warning(SAXParseException e) {
        this.errors.add(this.createValidationError(ValidationError.Type.WARNING, e));
    }

    @Override
    public void error(SAXParseException e) {
        this.errors.add(this.createValidationError(ValidationError.Type.ERROR, e));
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.errors.add(this.createValidationError(ValidationError.Type.FATAL, e));
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    private ValidationError createValidationError(ValidationError.Type type, SAXParseException e) {
        return new ValidationError(type, this.toRelativePath(e.getSystemId()), e.getLineNumber(), e.getColumnNumber(), this.asciiQuotes ? this.quotesToAscii(e.getMessage()) : e.getMessage());
    }

    private String toRelativePath(String path) {
        return this.basePath.relativize(Paths.get(URI.create(path))).toString();
    }

    private String quotesToAscii(String message) {
        return message.replace('\u201c', '\"').replace('\u201d', '\"');
    }
}

