/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.maven.plugin.configuration;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import nu.validator.maven.plugin.ValidationError;
import nu.validator.maven.plugin.configuration.MojoInvalidConfigurationException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public class FilterCfg {
    @Parameter(defaultValue="ALL")
    private FilterType type = FilterType.ALL;
    @Parameter(required=true)
    private String regex;
    private Pattern pattern;

    public final FilterType getType() {
        return this.type;
    }

    public final void setType(FilterType type) {
        this.type = type;
    }

    public final String getRegex() {
        return this.regex;
    }

    public final void setRegex(String regex) throws MojoFailureException {
        this.regex = regex;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final void compilePattern() throws MojoInvalidConfigurationException {
        if (this.regex == null) {
            throw new MojoInvalidConfigurationException("Missing required <regex> in <filter>");
        }
        try {
            this.pattern = Pattern.compile(this.regex);
        }
        catch (PatternSyntaxException e) {
            throw new MojoInvalidConfigurationException("Invalid filter regex: " + e.getMessage());
        }
    }

    public final String toString() {
        return "filter{type=" + (Object)((Object)this.type) + ", regex=" + this.regex + '}';
    }

    public static enum FilterType {
        WARNING(ValidationError.Type.WARNING),
        ERROR(ValidationError.Type.ERROR),
        ALL;

        private final ValidationError.Type errorType;

        private FilterType() {
            this.errorType = null;
        }

        private FilterType(ValidationError.Type errorType) {
            this.errorType = errorType;
        }

        public final ValidationError.Type getErrorType() {
            return this.errorType;
        }
    }
}

