/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.beans.aem;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import nz.ac.auckland.aem.beans.aem.JCRProperty;

public abstract class AbstractJCRNode {
    Node thisNode;
    Node parentNode;
    private String name;
    public Map<String, AbstractJCRNode> widgets = new HashMap<String, AbstractJCRNode>();
    public Map<String, JCRProperty> jcrProperties = new HashMap<String, JCRProperty>();

    public Node getThisNode() {
        return this.thisNode;
    }

    public void setThisNode(Node thisNode) {
        this.thisNode = thisNode;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public Node getNewNode(Node parent, AbstractJCRNode widget) {
        Node retVal = null;
        try {
            retVal = parent.addNode(widget.getName(), widget.getPrimaryTypeValue());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public abstract String getPrimaryTypeValue();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, JCRProperty> getJcrProperties() {
        return this.jcrProperties;
    }

    public void setJcrProperties(Map<String, JCRProperty> jcrProperties) {
        this.jcrProperties = jcrProperties;
    }

    public Map<String, AbstractJCRNode> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(Map<String, AbstractJCRNode> widgets) {
        this.widgets = widgets;
    }

    public JCRProperty getPrimaryType() {
        return new JCRProperty("jcr:primaryType", "Name", this.getPrimaryTypeValue());
    }

    public Node addChildWidget(AbstractJCRNode widget) {
        this.widgets.put(widget.getName(), widget);
        Node retVal = this.getNewNode(this.thisNode, widget);
        widget.setThisNode(retVal);
        widget.cloneJCRProperties();
        return retVal;
    }

    public void cloneJCRProperties() {
        for (Map.Entry<String, JCRProperty> prop : this.getJcrProperties().entrySet()) {
            JCRProperty jcrProp = prop.getValue();
            try {
                this.thisNode.setProperty(jcrProp.getName(), jcrProp.getValue(), jcrProp.getJCRMappedType());
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    public void addJCRProperties(AbstractJCRNode jcrNode, Node node) throws RepositoryException {
        for (Map.Entry<String, JCRProperty> prop : jcrNode.getJcrProperties().entrySet()) {
            JCRProperty jcrProp = prop.getValue();
            node.setProperty(jcrProp.getName(), jcrProp.getValue(), jcrProp.getJCRMappedType());
        }
    }

    public void addProperty(String name, String type, String value) {
        this.addProperty(name, new JCRProperty(name, type, value));
    }

    public void addProperty(JCRProperty property) {
        this.addProperty(property.getName(), property);
    }

    public void addProperty(String name, JCRProperty property) {
        if (property.isValid()) {
            this.jcrProperties.put(name, property);
        }
    }
}

