/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.core;

import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import nz.ac.auckland.aem.lmz.core.ComponentBeanContext;
import nz.ac.auckland.aem.lmz.dto.UsageLocation;
import nz.ac.auckland.aem.lmz.helper.LMZCatalogHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMZCatalogUsage {
    private static final Logger LOG = LoggerFactory.getLogger(LMZCatalogUsage.class);
    private ComponentBeanContext context;
    private LMZCatalogHelper catHelper;
    private List<UsageLocation> locations;
    private QueryManager queryManager;
    private ResourceResolver resourceResolver;
    private Session jcrSession;

    public LMZCatalogUsage(ComponentBeanContext context) throws RepositoryException {
        this.context = context;
        this.catHelper = this.getHelperInstance(context);
        this.setQueryManagerInstance(this.context.getQueryManager());
        this.setResourceResolverInstance(this.context.getResourceResolver());
        this.setJcrSessionInstance(this.context.getCurrentNode().getSession());
    }

    public LMZCatalogUsage() {
        this.catHelper = this.getHelperInstance(null);
    }

    public boolean isInUse() throws RepositoryException {
        return this.getLocations() != null && this.getLocations().size() > 0;
    }

    public List<UsageLocation> getLocations() throws RepositoryException {
        return this.getLocations(this.catHelper.getCatalogResourceTypes());
    }

    public List<UsageLocation> getLocations(List<String> resourceTypes) throws RepositoryException {
        if (resourceTypes == null) {
            return null;
        }
        ArrayList<UsageLocation> locations = new ArrayList<UsageLocation>();
        for (String endpoint : resourceTypes) {
            List<UsageLocation> usages = this.getLocationsForResourceType(endpoint);
            if (usages == null) continue;
            locations.addAll(usages);
        }
        return locations;
    }

    protected List<UsageLocation> getLocationsForResourceType(String resourceType) throws RepositoryException {
        NodeIterator resultIterator = this.getNodeIteratorFromQueryFor(resourceType);
        if (resultIterator == null) {
            return null;
        }
        ArrayList<UsageLocation> usages = new ArrayList<UsageLocation>();
        while (resultIterator.hasNext()) {
            Node resultNode = resultIterator.nextNode();
            if (resultNode == null) continue;
            String nodePagePath = this.getPagePath(resultNode.getPath());
            Page page = (Page)this.getResourceResolverInstance().getResource(nodePagePath).adaptTo(Page.class);
            usages.add(new UsageLocation(resourceType, page.getPath() + ".html", this.getPageTitle(page)));
        }
        return usages;
    }

    protected String getPageTitle(Page page) {
        if (StringUtils.isNotBlank((String)page.getNavigationTitle())) {
            return page.getNavigationTitle();
        }
        if (StringUtils.isNotBlank((String)page.getPageTitle())) {
            return page.getPageTitle();
        }
        if (StringUtils.isNotBlank((String)page.getTitle())) {
            return page.getTitle();
        }
        return page.getName();
    }

    protected String getPagePath(String path) {
        return path.split("/jcr:content")[0];
    }

    protected NodeIterator getNodeIteratorFromQueryFor(String resourceType) throws RepositoryException {
        String queryText = "SELECT child.* FROM [nt:unstructured] as child WHERE child.[sling:resourceType] = '" + resourceType + "'";
        QueryManager qMgr = this.getQueryManagerInstance();
        Query query = qMgr.createQuery(queryText, "JCR-SQL2");
        QueryResult qResult = query.execute();
        return qResult.getNodes();
    }

    public LMZCatalogHelper getHelperInstance(ComponentBeanContext context) {
        return new LMZCatalogHelper(context);
    }

    protected QueryManager getQueryManagerInstance() throws RepositoryException {
        return this.queryManager;
    }

    public void setQueryManagerInstance(QueryManager qMgr) {
        this.queryManager = qMgr;
    }

    protected ResourceResolver getResourceResolverInstance() {
        return this.resourceResolver;
    }

    public void setResourceResolverInstance(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Session getJcrSessionInstance() {
        return this.jcrSession;
    }

    public void setJcrSessionInstance(Session jcrSession) {
        this.jcrSession = jcrSession;
    }
}

