/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.core;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nz.ac.auckland.aem.lmz.core.ComponentBeanContext;
import nz.ac.auckland.aem.lmz.helper.LMZCatalogHelper;
import nz.ac.auckland.aem.lmz.helper.UrlPruner;
import nz.ac.auckland.aem.lmz.lmzconfigdialog.LMZConfigDialogFactory;
import nz.ac.auckland.lmzwidget.configuration.model.WidgetConfiguration;
import nz.ac.auckland.lmzwidget.configuration.parser.WidgetConfigurationParser;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMZWidgetComponentCreator {
    public static final String PARAM_RESOURCETYPE = "sling:resourceType";
    private static Logger logger = LoggerFactory.getLogger(LMZWidgetComponentCreator.class);
    private HttpClient client = new HttpClient();
    private ComponentBeanContext context;
    private LMZCatalogHelper catHelper;

    public LMZWidgetComponentCreator(ComponentBeanContext context) {
        this.context = context;
        this.catHelper = this.getHelperInstance(context);
    }

    protected LMZCatalogHelper getHelperInstance(ComponentBeanContext context) {
        return new LMZCatalogHelper(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WidgetConfiguration fetchConfiguration(String endpoint) {
        String configurationUrl = this.getConfigurationUrl(endpoint);
        if (StringUtils.isBlank((CharSequence)configurationUrl)) {
            logger.info("No configuration URL was found, fetching skipped.");
            return null;
        }
        logger.info("Requesting configuration URL: " + configurationUrl);
        GetMethod method = null;
        try {
            method = new GetMethod(configurationUrl);
            method.setFollowRedirects(true);
            this.client.executeMethod((HttpMethod)method);
            String responseBody = method.getResponseBodyAsString();
            WidgetConfiguration widgetConfiguration = this.toWidgetConfiguration(responseBody);
            return widgetConfiguration;
        }
        catch (IOException ioEx) {
            logger.error("Could not finish the configuration request", (Throwable)ioEx);
        }
        catch (IllegalStateException isEx) {
            logger.error("This URL specified is incorrect, aborting.", (Throwable)isEx);
        }
        catch (IllegalArgumentException iaEx) {
            logger.error("This URL specified is incorrect, aborting.", (Throwable)iaEx);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    public void persistWidgetConfig(String endpointUrl, WidgetConfiguration widgetConfig) {
        String catalogName = this.catHelper.getUniqueCatalogIdentifier();
        LMZConfigDialogFactory dialogFactory = this.getDialogFactoryInstance();
        dialogFactory.setWidgetConfiguration(widgetConfig);
        dialogFactory.setWidgetURL(this.sanitizeRequestUrl(endpointUrl));
        try {
            Session session = (Session)this.context.getResourceResolver().adaptTo(Session.class);
            String componentName = this.getCamelcaseComponentName(widgetConfig);
            Node root = this.ensureCatalogExists(catalogName);
            if (root.hasNode(componentName)) {
                session.removeItem("/apps/lmzconfig/components/" + catalogName + "/" + componentName);
            }
            Node componentNode = root.addNode(componentName, "cq:Component");
            componentNode.setProperty("allowedParents", "*/parsys");
            componentNode.setProperty("componentGroup", this.getCatalogName());
            componentNode.setProperty("jcr:title", widgetConfig.getWidget().getDescription());
            componentNode.setProperty("requestUrl", this.sanitizeRequestUrl(endpointUrl));
            componentNode.setProperty("maintenanceMode", this.isInMaintenanceMode());
            componentNode.setProperty("maintenanceMessage", this.getMaintenanceMessage());
            componentNode.setProperty("sling:resourceSuperType", "/apps/lmz-integration/components/lmzwidget-base");
            dialogFactory.createCQDialog(componentNode);
            session.save();
            Node ed = session.getNode("/apps/lmz-integration/components/lmzwidget-base/cq:editConfig");
            session.getWorkspace().copy(ed.getPath(), componentNode.getPath() + "/cq:editConfig");
            Node newEditConfig = session.getNode(componentNode.getPath() + "/cq:editConfig");
            newEditConfig.setProperty("cq:actions", new String[]{"text:" + widgetConfig.getWidget().getDescription(), "-", "edit", "-", "delete"});
            session.save();
        }
        catch (RepositoryException rEx) {
            logger.error("A repository exception occured", (Throwable)rEx);
        }
    }

    protected LMZConfigDialogFactory getDialogFactoryInstance() {
        return new LMZConfigDialogFactory();
    }

    protected String getCamelcaseComponentName(WidgetConfiguration widgetConfig) {
        return LMZConfigDialogFactory.camelCaseString(widgetConfig.getWidget().getName());
    }

    protected Node ensureCatalogExists(String catalogName) throws RepositoryException {
        if (catalogName == null) {
            throw new IllegalArgumentException("Catalog name cannot be null, aborting.");
        }
        Node root = this.context.getCurrentNode().getSession().getNode("/apps");
        root = !root.hasNode("lmzconfig") ? root.addNode("lmzconfig", "nt:folder") : root.getNode("lmzconfig");
        root = !root.hasNode("components") ? root.addNode("components", "nt:folder") : root.getNode("components");
        root = !root.hasNode(catalogName) ? root.addNode(catalogName, "nt:folder") : root.getNode(catalogName);
        return root;
    }

    public String getCatalogName() {
        return (String)this.context.getProperties().get("name", (Object)"catalogName");
    }

    protected WidgetConfiguration toWidgetConfiguration(String configString) {
        WidgetConfigurationParser parser = new WidgetConfigurationParser();
        return parser.parse(configString);
    }

    protected String sanitizeRequestUrl(String reqUrl) {
        if (!reqUrl.endsWith("/")) {
            return reqUrl + "/";
        }
        return reqUrl;
    }

    protected String getConfigurationUrl(String reqUrl) {
        String requestUrl = this.sanitizeRequestUrl(reqUrl);
        if (StringUtils.isNotBlank((CharSequence)requestUrl)) {
            return requestUrl + "/configuration";
        }
        return null;
    }

    public <T> Map<String, T> pruneKeys(Map<String, T> original) {
        if (original == null) {
            return null;
        }
        UrlPruner pruner = this.getUrlPrunerInstance();
        LinkedHashMap<String, T> prunedResults = new LinkedHashMap<String, T>();
        for (Map.Entry<String, T> entry : original.entrySet()) {
            prunedResults.put(pruner.getPrunedUrl(entry.getKey()), entry.getValue());
        }
        return prunedResults;
    }

    public Map<String, WidgetConfiguration> updateAllWidgets() throws RepositoryException {
        Object[] widgetEndpoints = this.catHelper.getWidgetList();
        if (ArrayUtils.isEmpty((Object[])widgetEndpoints)) {
            return null;
        }
        LinkedHashMap<String, WidgetConfiguration> result = new LinkedHashMap<String, WidgetConfiguration>();
        for (Object endpoint : widgetEndpoints) {
            if (StringUtils.isBlank((CharSequence)endpoint)) continue;
            WidgetConfiguration widgetConfig = this.fetchConfiguration((String)endpoint);
            if (widgetConfig != null) {
                this.persistWidgetConfig((String)endpoint, widgetConfig);
            }
            result.put((String)endpoint, widgetConfig);
        }
        return result;
    }

    public boolean isInMaintenanceMode() {
        return (Boolean)this.context.getProperties().get("maintenanceMode", (Object)false);
    }

    public String getMaintenanceMessage() {
        return (String)this.context.getProperties().get("maintenanceMessage", (Object)null);
    }

    public boolean shouldSynchronize() {
        return this.context.isAuthor();
    }

    public boolean isFirstCatalogComponent() throws RepositoryException {
        Node parsys = this.getParsysNode();
        try {
            NodeIterator nIterator = parsys.getNodes();
            while (nIterator.hasNext()) {
                Node childNode = nIterator.nextNode();
                if (childNode == null || !this.isCatalogComponent(childNode)) continue;
                return childNode.isSame((Item)this.context.getCurrentNode());
            }
        }
        catch (RepositoryException rEx) {
            logger.error("An error occured retrieving child nodes", (Throwable)rEx);
        }
        return false;
    }

    protected Node getParsysNode() throws RepositoryException {
        return ((Node)this.context.getCurrentPage().getContentResource().adaptTo(Node.class)).getNode("par");
    }

    protected boolean isCatalogComponent(Node childNode) throws RepositoryException {
        return childNode.hasProperty(PARAM_RESOURCETYPE) && this.sameResourceType(childNode);
    }

    protected boolean sameResourceType(Node childNode) throws RepositoryException {
        return childNode.getProperty(PARAM_RESOURCETYPE).getString().equals(this.getCatalogResourceType());
    }

    protected String getCatalogResourceType() throws RepositoryException {
        Node current = this.context.getCurrentNode();
        return current.hasProperty(PARAM_RESOURCETYPE) ? current.getProperty(PARAM_RESOURCETYPE).getString() : null;
    }

    protected UrlPruner getUrlPrunerInstance() {
        return new UrlPruner();
    }
}

