/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetRenderContext {
    private HttpClient client = new HttpClient();
    private static final Logger LOG = LoggerFactory.getLogger(WidgetRenderContext.class);
    private String html;
    private String widgetUrl;
    private String viewUrl;
    private String viewQueryString;
    private int responseStatusCode;
    private String lmzBase;

    public WidgetRenderContext(String widgetUrl, Map<String, String> confMap, String version) {
        this.widgetUrl = widgetUrl;
        this.viewQueryString = this.buildViewQueryString(confMap, version);
    }

    public boolean isFetchedContent() {
        return this.html != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fetchWidgetContent() {
        GetMethod method = null;
        try {
            boolean bl;
            LOG.info("Requesting URL " + this.getViewUrl());
            method = new GetMethod(this.getViewUrl() + this.getViewQueryString());
            method.setFollowRedirects(true);
            this.client.executeMethod((HttpMethod)method);
            for (Header header : method.getResponseHeaders()) {
                LOG.info("response Header: " + header.toExternalForm());
            }
            StatusLine status = method.getStatusLine();
            this.responseStatusCode = status.getStatusCode();
            LOG.info("statusResponse: valid? " + this.isValidResponse() + " : code: " + this.getResponseStatusCode());
            String responseBody = method.getResponseBodyAsString();
            if (!this.isValidResponse()) {
                LOG.info("Not a valid response, server response body: " + responseBody);
                bl = false;
                return bl;
            }
            this.html = responseBody;
            bl = true;
            return bl;
        }
        catch (IOException ioEx) {
            LOG.error("An IO Exception occured", (Throwable)ioEx);
        }
        catch (Exception ex) {
            LOG.error("An exception occurred", (Throwable)ex);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return false;
    }

    protected String buildViewQueryString(Map<String, String> confMap, String version) {
        String queryString = "";
        queryString = queryString + "?version=" + version;
        queryString = queryString + "&configuration=" + this.jsonifyAndEncodeConfiguration(confMap);
        return queryString;
    }

    protected String getViewUrl() {
        if (this.viewUrl == null) {
            this.viewUrl = this.widgetUrl;
            if (!this.viewUrl.endsWith("/")) {
                this.viewUrl = this.viewUrl + "/";
            }
            if (!this.viewUrl.endsWith("view")) {
                this.viewUrl = this.viewUrl + "view";
            }
        }
        return this.viewUrl;
    }

    protected String jsonifyAndEncodeConfiguration(Map<String, String> confMap) {
        JSONObject configParams = new JSONObject(confMap);
        String configString = configParams.toString();
        LOG.info("config params: " + configString);
        Base64 b64Enc = new Base64();
        try {
            return b64Enc.encodeToString(configString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ueEx) {
            LOG.error("Cannot generate utf-8 base64 encoded configuration, aborting", (Throwable)ueEx);
            return null;
        }
    }

    public String getLmzBase() {
        if (this.lmzBase == null) {
            try {
                URI uri = new URI(this.widgetUrl);
                String base = uri.getScheme() + "://" + uri.getHost();
                if (uri.getPort() > 0 && uri.getPort() != 443 && uri.getPort() != 80) {
                    base = base + ":" + uri.getPort();
                }
                this.lmzBase = base;
                return this.lmzBase;
            }
            catch (URISyntaxException useEx) {
                LOG.error("Something went wrong while parsing the URI", (Throwable)useEx);
            }
        }
        return this.lmzBase;
    }

    public String getUrlContextPath() {
        try {
            URI uri = new URI(this.widgetUrl);
            return uri.getPath();
        }
        catch (URISyntaxException useEx) {
            LOG.error("Something went wrong while parsing the URI", (Throwable)useEx);
            return null;
        }
    }

    public String getHtml() {
        return this.html;
    }

    public boolean isValidResponse() {
        return 200 <= this.responseStatusCode && 300 > this.responseStatusCode;
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public String getWidgetUrl() {
        return this.widgetUrl;
    }

    public String getViewQueryString() {
        return this.viewQueryString;
    }
}

