/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RandomSearch
extends ASSearch
implements StartSetHandler,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 7479392617377425484L;
    private int[] m_starting;
    private Range m_startRange;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private boolean m_onlyConsiderBetterAndSmaller;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_seed;
    private double m_searchSize;
    private int m_iterations;
    private Random m_random;
    private boolean m_verbose;

    public String globalInfo() {
        return "RandomSearch : \n\nPerforms a Random search in the space of attribute subsets. If no start set is supplied, Random search starts from a random point and reports the best subset found. If a start set is supplied, Random searches randomly for subsets that are as good or better than the start point with the same or or fewer attributes. Using RandomSearch in conjunction with a start set containing all attributes equates to the LVF algorithm of Liu and Setiono (ICML-96).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "H. Liu and R. Setiono");
        result.setValue(TechnicalInformation.Field.TITLE, "A probabilistic approach to feature selection - A filter solution");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "13th International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1996");
        result.setValue(TechnicalInformation.Field.PAGES, "319-327");
        return result;
    }

    public RandomSearch() {
        this.resetOptions();
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.\n\tIf a start point is supplied,\n\trandom search evaluates the start\n\tpoint and then randomly looks for\n\tsubsets that are as good as or better\n\tthan the start point with the same\n\tor lower cardinality.", "P", 1, "-P <start set>"));
        newVector.addElement(new Option("\tPercent of search space to consider.\n\t(default = 25%).", "F", 1, "-F <percent> "));
        newVector.addElement(new Option("\tOutput subsets as the search progresses.\n\t(default = false).", "V", 0, "-V"));
        newVector.addElement(new Option("\tRandom seed\n\t(default = 1)", "seed", 1, "-seed <num>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption((char)'P', (String[])options);
        if (optionString.length() != 0) {
            this.setStartSet(optionString);
        }
        if ((optionString = Utils.getOption((char)'F', (String[])options)).length() != 0) {
            this.setSearchPercent(new Double(optionString));
        }
        if ((optionString = Utils.getOption((String)"seed", (String[])options)).length() > 0) {
            this.setSeed(Integer.parseInt(optionString));
        }
        this.setVerbose(Utils.getFlag((char)'V', (String[])options));
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.m_verbose) {
            options.add("-V");
        }
        if (!this.getStartSet().equals("")) {
            options.add("-P");
            options.add("" + this.startSetToString());
        }
        options.add("-F");
        options.add("" + this.getSearchPercent());
        options.add("-seed");
        options.add("" + this.getSeed());
        return options.toArray(new String[0]);
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17. If specified, Random searches for subsets of attributes that are as good as or better than the start set with the same or lower cardinality.";
    }

    public void setStartSet(String startSet) throws Exception {
        this.m_startRange.setRanges(startSet);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String verboseTipText() {
        return "Print progress information. Sends progress info to the terminal as the search progresses.";
    }

    public void setVerbose(boolean v) {
        this.m_verbose = v;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String searchPercentTipText() {
        return "Percentage of the search space to explore.";
    }

    public void setSearchPercent(double p) {
        if ((p = Math.abs(p)) == 0.0) {
            p = 25.0;
        }
        if (p > 100.0) {
            p = 100.0;
        }
        this.m_searchSize = p / 100.0;
    }

    public double getSearchPercent() {
        return this.m_searchSize * 100.0;
    }

    public String seedTipText() {
        return "Seed for the random number generator";
    }

    public void setSeed(int seed) {
        this.m_seed = seed;
    }

    public int getSeed() {
        return this.m_seed;
    }

    private String startSetToString() {
        StringBuffer FString = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean didPrint = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                FString.append(this.m_starting[i] + 1);
                didPrint = true;
            }
            if (i == this.m_starting.length - 1) {
                FString.append("");
                continue;
            }
            if (!didPrint) continue;
            FString.append(",");
        }
        return FString.toString();
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("\tRandom search.\n\tStart set: ");
        if (this.m_starting == null) {
            text.append("no attributes\n");
        } else {
            text.append(this.startSetToString() + "\n");
        }
        text.append("\tNumber of iterations: " + this.m_iterations + " (" + this.m_searchSize * 100.0 + "% of the search space)\n");
        text.append("\tMerit of best subset found: " + Utils.doubleToString((double)Math.abs(this.m_bestMerit), (int)8, (int)3) + "\n");
        return text.toString();
    }

    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        double best_merit;
        int sizeOfBest = this.m_numAttribs;
        this.m_bestGroup = new BitSet(this.m_numAttribs);
        this.m_onlyConsiderBetterAndSmaller = false;
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        this.m_random = new Random(this.m_seed);
        if (ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = data.classIndex();
        }
        SubsetEvaluator ASEvaluator = (SubsetEvaluator)ASEval;
        this.m_numAttribs = data.numAttributes();
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            for (int element : this.m_starting) {
                if (element == this.m_classIndex) continue;
                this.m_bestGroup.set(element);
            }
            this.m_onlyConsiderBetterAndSmaller = true;
            best_merit = ASEvaluator.evaluateSubset(this.m_bestGroup);
            sizeOfBest = this.countFeatures(this.m_bestGroup);
        } else {
            this.m_bestGroup = this.generateRandomSubset();
            best_merit = ASEvaluator.evaluateSubset(this.m_bestGroup);
        }
        if (this.m_verbose) {
            System.out.println("Initial subset (" + Utils.doubleToString((double)Math.abs(best_merit), (int)8, (int)5) + "): " + this.printSubset(this.m_bestGroup));
        }
        int i = this.m_hasClass ? this.m_numAttribs - 1 : this.m_numAttribs;
        this.m_iterations = (int)(this.m_searchSize * Math.pow(2.0, i));
        for (i = 0; i < this.m_iterations; ++i) {
            BitSet temp = this.generateRandomSubset();
            if (this.m_onlyConsiderBetterAndSmaller) {
                double tempMerit;
                int tempSize = this.countFeatures(temp);
                if (tempSize > sizeOfBest || !((tempMerit = ASEvaluator.evaluateSubset(temp)) >= best_merit)) continue;
                sizeOfBest = tempSize;
                this.m_bestGroup = temp;
                best_merit = tempMerit;
                if (!this.m_verbose) continue;
                System.out.print("New best subset (" + Utils.doubleToString((double)Math.abs(best_merit), (int)8, (int)5) + "): " + this.printSubset(this.m_bestGroup) + " :");
                System.out.println(Utils.doubleToString((double)((double)i / (double)this.m_iterations * 100.0), (int)5, (int)1) + "% done");
                continue;
            }
            double tempMerit = ASEvaluator.evaluateSubset(temp);
            if (!(tempMerit > best_merit)) continue;
            this.m_bestGroup = temp;
            best_merit = tempMerit;
            if (!this.m_verbose) continue;
            System.out.print("New best subset (" + Utils.doubleToString((double)Math.abs(best_merit), (int)8, (int)5) + "): " + this.printSubset(this.m_bestGroup) + " :");
            System.out.println(Utils.doubleToString((double)((double)i / (double)this.m_iterations * 100.0), (int)5, (int)1) + "% done");
        }
        this.m_bestMerit = best_merit;
        return this.attributeList(this.m_bestGroup);
    }

    private String printSubset(BitSet temp) {
        StringBuffer text = new StringBuffer();
        for (int j = 0; j < this.m_numAttribs; ++j) {
            if (!temp.get(j)) continue;
            text.append(j + 1 + " ");
        }
        return text.toString();
    }

    private int[] attributeList(BitSet group) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            list[count++] = i;
        }
        return list;
    }

    private BitSet generateRandomSubset() {
        BitSet temp = new BitSet(this.m_numAttribs);
        for (int i = 0; i < this.m_numAttribs; ++i) {
            double r = this.m_random.nextDouble();
            if (!(r <= 0.5) || this.m_hasClass && i == this.m_classIndex) continue;
            temp.set(i);
        }
        return temp;
    }

    private int countFeatures(BitSet featureSet) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!featureSet.get(i)) continue;
            ++count;
        }
        return count;
    }

    private void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_searchSize = 0.25;
        this.m_seed = 1;
        this.m_onlyConsiderBetterAndSmaller = false;
        this.m_verbose = false;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10325 $");
    }
}

