/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RankSearch
extends ASSearch
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -7992268736874353755L;
    private int m_numAttribs;
    private ASEvaluation m_ASEval;
    private ASEvaluation m_SubsetEval;
    private Instances m_Instances;
    private double m_bestMerit;
    private int[] m_Ranking;
    protected double m_improvementThreshold = 0.0;
    protected boolean m_excludeNonImproving = false;
    protected int m_add = 1;
    protected int m_startPoint = 0;
    protected boolean m_debug;
    protected int m_nonImprovingAdditions = 0;

    public String globalInfo() {
        return "RankSearch : \n\nUses an attribute/subset evaluator to rank all attributes. If a subset evaluator is specified, then a forward selection search is used to generate a ranked list. From the ranked list of attributes, subsets of increasing size are evaluated, ie. The best attribute, the best attribute plus the next best attribute, etc.... The best attribute set is reported. RankSearch is linear in the number of attributes if a simple attribute evaluator is used such as GainRatioAttributeEval. For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hall and Geoffrey Holmes");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.TITLE, "Benchmarking attribute selection techniques for discrete class data mining");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        result.setValue(TechnicalInformation.Field.VOLUME, "15");
        result.setValue(TechnicalInformation.Field.NUMBER, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "1437-1447");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "IEEE Computer Society");
        return result;
    }

    public RankSearch() {
        this.resetOptions();
    }

    public String attributeEvaluatorTipText() {
        return "Attribute evaluator to use for generating a ranking.";
    }

    public void setAttributeEvaluator(ASEvaluation newEvaluator) {
        this.m_ASEval = newEvaluator;
    }

    public ASEvaluation getAttributeEvaluator() {
        return this.m_ASEval;
    }

    public String stepSizeTipText() {
        return "Add this many attributes from the ranking in each iteration.";
    }

    public void setStepSize(int ss) {
        if (ss > 0) {
            this.m_add = ss;
        }
    }

    public int getStepSize() {
        return this.m_add;
    }

    public String startPointTipText() {
        return "Start evaluating from this point in the ranking.";
    }

    public void setStartPoint(int sp) {
        if (sp >= 0) {
            this.m_startPoint = sp;
        }
    }

    public int getStartPoint() {
        return this.m_startPoint;
    }

    public String debuggingOutputTipText() {
        return "Output debugging information to the console";
    }

    public void setDebuggingOutput(boolean d) {
        this.m_debug = d;
    }

    public boolean getDebuggingOutput() {
        return this.m_debug;
    }

    public String improvementThresholdTipText() {
        return "Threshold on improvement in merit by which to accept additional attributes from the ranked list";
    }

    public void setImprovementThreshold(double t) {
        this.m_improvementThreshold = t;
    }

    public double getImprovementThreshold() {
        return this.m_improvementThreshold;
    }

    public String excludeNonImprovingAttributesTipText() {
        return "As more attributes are considered from the ranked list, don't include any prior ones that did not improve merit";
    }

    public void setExcludeNonImprovingAttributes(boolean b) {
        this.m_excludeNonImproving = b;
    }

    public boolean getExcludeNonImprovingAttributes() {
        return this.m_excludeNonImproving;
    }

    public String nonImprovingAdditionsTipText() {
        return "Terminate the evaluation of the ranking after this many non-improving additions to the best subset seen (0 = don't terminate early)";
    }

    public void setNonImprovingAdditions(int t) {
        this.m_nonImprovingAdditions = t;
    }

    public int getNonImprovingAdditions() {
        return this.m_nonImprovingAdditions;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> newVector = new Vector<Object>(7);
        newVector.addElement(new Option("\tclass name of attribute evaluator to use for ranking. Place any\n\tevaluator options LAST on the command line following a \"--\".\n\teg.:\n\t\t-A weka.attributeSelection.GainRatioAttributeEval ... -- -M\n\t(default: weka.attributeSelection.GainRatioAttributeEval)", "A", 1, "-A <attribute evaluator>"));
        newVector.addElement(new Option("\tnumber of attributes to be added from the\n\tranking in each iteration (default = 1).", "S", 1, "-S <step size>"));
        newVector.addElement(new Option("\tpoint in the ranking to start evaluating from. \n\t(default = 0, ie. the head of the ranking).", "R", 1, "-R <start point>"));
        newVector.addElement(new Option("\tThreshold on improvement in merit by which to accept\n\tadditional attributes from the ranked list \n\t(default = 0).", "I", 1, "-I <threshold>"));
        newVector.addElement(new Option("\tNumber of non-improving additions to the best subset seen\n\tto tolerate before terminating the search (default = 0, i.e.\n\tdon't terminate early).", "N", 1, "-N <number of non-improving additions>"));
        newVector.addElement(new Option("\tExclude non improving attributes when\n\tconsidering more attributes from the ranked list", "X", 0, "-X"));
        newVector.addElement(new Option("\tPrint debugging output", "D", 0, "-D"));
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_ASEval.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)this.m_ASEval).listOptions()));
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption((char)'S', (String[])options);
        if (optionString.length() != 0) {
            this.setStepSize(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption((char)'R', (String[])options)).length() != 0) {
            this.setStartPoint(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption((char)'I', (String[])options)).length() > 0) {
            this.setImprovementThreshold(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption((char)'N', (String[])options)).length() > 0) {
            this.setNonImprovingAdditions(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption((char)'A', (String[])options)).length() == 0) {
            optionString = GainRatioAttributeEval.class.getName();
        }
        this.setAttributeEvaluator(ASEvaluation.forName((String)optionString, (String[])Utils.partitionOptions((String[])options)));
        this.setExcludeNonImprovingAttributes(Utils.getFlag((char)'X', (String[])options));
        this.setDebuggingOutput(Utils.getFlag((char)'D', (String[])options));
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        String[] evaluatorOptions;
        Vector<String> options = new Vector<String>();
        options.add("-S");
        options.add("" + this.getStepSize());
        options.add("-R");
        options.add("" + this.getStartPoint());
        options.add("-N");
        options.add("" + this.getNonImprovingAdditions());
        options.add("-I");
        options.add("" + this.getImprovementThreshold());
        if (this.getExcludeNonImprovingAttributes()) {
            options.add("-X");
        }
        if (this.getDebuggingOutput()) {
            options.add("-D");
        }
        if (this.getAttributeEvaluator() != null) {
            options.add("-A");
            options.add(this.getAttributeEvaluator().getClass().getName());
        }
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler && (evaluatorOptions = ((OptionHandler)this.m_ASEval).getOptions()).length > 0) {
            options.add("--");
            Collections.addAll(options, evaluatorOptions);
        }
        return options.toArray(new String[0]);
    }

    protected void resetOptions() {
        this.m_ASEval = new GainRatioAttributeEval();
        this.m_Ranking = null;
    }

    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        double best_merit = -1.7976931348623157E308;
        BitSet best_group = null;
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        this.m_SubsetEval = ASEval;
        this.m_Instances = data;
        this.m_numAttribs = this.m_Instances.numAttributes();
        if (this.m_debug) {
            System.err.println("Ranking...");
        }
        if (this.m_ASEval instanceof AttributeEvaluator) {
            Ranker ranker = new Ranker();
            this.m_ASEval.buildEvaluator(this.m_Instances);
            if (this.m_ASEval instanceof AttributeTransformer) {
                this.m_Instances = ((AttributeTransformer)this.m_ASEval).transformedData(this.m_Instances);
                this.m_SubsetEval.buildEvaluator(this.m_Instances);
            }
            this.m_Ranking = ranker.search(this.m_ASEval, this.m_Instances);
        } else {
            GreedyStepwise fs = new GreedyStepwise();
            fs.setGenerateRanking(true);
            this.m_ASEval.buildEvaluator(this.m_Instances);
            fs.search(this.m_ASEval, this.m_Instances);
            double[][] rankres = fs.rankedAttributes();
            this.m_Ranking = new int[rankres.length];
            for (int i = 0; i < rankres.length; ++i) {
                this.m_Ranking[i] = (int)rankres[i][0];
            }
        }
        boolean[] dontAdd = null;
        if (this.m_excludeNonImproving) {
            dontAdd = new boolean[this.m_Ranking.length];
        }
        if (this.m_debug) {
            System.err.println("Done ranking. Evaluating ranking...");
        }
        int additions = 0;
        int tenPercent = (this.m_Ranking.length - this.m_startPoint) / 10;
        int count = 0;
        int i = this.m_startPoint;
        while (i < this.m_Ranking.length) {
            int j;
            if ((i += this.m_add) > this.m_Ranking.length) {
                i = this.m_Ranking.length;
            }
            BitSet temp_group = new BitSet(this.m_numAttribs);
            for (j = 0; j < i; ++j) {
                if (this.m_excludeNonImproving) {
                    if (dontAdd[j]) continue;
                    temp_group.set(this.m_Ranking[j]);
                    continue;
                }
                temp_group.set(this.m_Ranking[j]);
            }
            ++additions;
            double temp_merit = ((SubsetEvaluator)this.m_SubsetEval).evaluateSubset(temp_group);
            if (this.m_debug && tenPercent > 0 && (count += this.m_add) >= tenPercent) {
                System.err.println("" + (double)(i - this.m_startPoint) / (double)(this.m_Ranking.length - this.m_startPoint) * 100.0 + " percent complete");
                count = 0;
            }
            if (temp_merit - best_merit > this.m_improvementThreshold) {
                best_merit = temp_merit;
                best_group = temp_group;
                additions = 0;
                if (this.m_debug) {
                    int[] atts = this.attributeList(best_group);
                    System.err.print("Best subset found so far (" + atts.length + " features): ");
                    for (int a : atts) {
                        System.err.print("" + (a + 1) + " ");
                    }
                    System.err.println("\nMerit: " + best_merit);
                }
            } else if (this.m_excludeNonImproving && i > 0) {
                if (this.m_debug) {
                    System.err.println("Skipping atts ranked " + (i - this.m_add) + " to " + i + " as there is no improvement");
                }
                for (j = i - this.m_add; j < i; ++j) {
                    dontAdd[j] = true;
                }
            }
            if (this.m_nonImprovingAdditions <= 0 || additions <= this.m_nonImprovingAdditions) continue;
            if (!this.m_debug) break;
            System.err.println("Terminating the search after " + this.m_nonImprovingAdditions + " non-improving additions");
            break;
        }
        this.m_bestMerit = best_merit;
        return this.attributeList(best_group);
    }

    private int[] attributeList(BitSet group) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            list[count++] = i;
        }
        return list;
    }

    public String toString() {
        int n;
        StringBuffer text = new StringBuffer();
        text.append("\tRankSearch :\n");
        text.append("\tAttribute evaluator : " + this.getAttributeEvaluator().getClass().getName() + " ");
        if (this.m_ASEval instanceof OptionHandler) {
            String[] evaluatorOptions = new String[]{};
            for (String evaluatorOption : evaluatorOptions = ((OptionHandler)this.m_ASEval).getOptions()) {
                text.append(evaluatorOption + ' ');
            }
        }
        text.append("\n");
        text.append("\tAttribute ranking : \n");
        int rlength = (int)(Math.log(this.m_Ranking.length) / Math.log(10.0) + 1.0);
        for (int element : this.m_Ranking) {
            text.append("\t " + Utils.doubleToString((double)(element + 1), (int)rlength, (int)0) + " " + this.m_Instances.attribute(element).name() + '\n');
        }
        text.append("\tMerit of best subset found : ");
        int n2 = 3;
        double precision = this.m_bestMerit - (double)((int)this.m_bestMerit);
        if (Math.abs(this.m_bestMerit) > 0.0) {
            n = (int)Math.abs(Math.log(Math.abs(this.m_bestMerit)) / Math.log(10.0)) + 2;
        }
        precision = Math.abs(precision) > 0.0 ? Math.abs(Math.log(Math.abs(precision)) / Math.log(10.0)) + 3.0 : 2.0;
        text.append(Utils.doubleToString((double)Math.abs(this.m_bestMerit), (int)(n + (int)precision), (int)((int)precision)) + "\n");
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10325 $");
    }
}

