/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.text.DecimalFormat;
import java.util.Random;
import weka.classifiers.functions.pace.ChisqMixture;
import weka.classifiers.functions.pace.NormalMixture;
import weka.core.RevisionUtils;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.FlexibleDecimalFormat;
import weka.core.matrix.IntVector;
import weka.core.matrix.Maths;
import weka.core.matrix.Matrix;

public class PaceMatrix
extends Matrix {
    static final long serialVersionUID = 2699925616857843973L;

    public PaceMatrix(int m, int n) {
        super(m, n);
    }

    public PaceMatrix(int m, int n, double s) {
        super(m, n, s);
    }

    public PaceMatrix(double[][] A) {
        super(A);
    }

    public PaceMatrix(double[][] A, int m, int n) {
        super(A, m, n);
    }

    public PaceMatrix(double[] vals, int m) {
        super(vals, m);
    }

    public PaceMatrix(DoubleVector v) {
        this(v.size(), 1);
        this.setMatrix(0, v.size() - 1, 0, v);
    }

    public PaceMatrix(Matrix X) {
        super(X.getRowDimension(), X.getColumnDimension());
        this.A = X.getArray();
    }

    public void setRowDimension(int rowDimension) {
        this.m = rowDimension;
    }

    public void setColumnDimension(int columnDimension) {
        this.n = columnDimension;
    }

    public Object clone() {
        PaceMatrix X = new PaceMatrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j];
            }
        }
        return X;
    }

    public void setPlus(int i, int j, double s) {
        double[] dArray = this.A[i];
        int n = j;
        dArray[n] = dArray[n] + s;
    }

    public void setTimes(int i, int j, double s) {
        double[] dArray = this.A[i];
        int n = j;
        dArray[n] = dArray[n] * s;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, double s) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.A[i][j] = s;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
    }

    public void setMatrix(int i0, int i1, int j, DoubleVector v) {
        for (int i = i0; i <= i1; ++i) {
            this.A[i][j] = v.get(i - i0);
        }
    }

    public void setMatrix(double[] v, boolean columnFirst) {
        try {
            if (v.length != this.m * this.n) {
                throw new IllegalArgumentException("sizes not match.");
            }
            int count = 0;
            if (columnFirst) {
                for (int i = 0; i < this.m; ++i) {
                    for (int j = 0; j < this.n; ++j) {
                        this.A[i][j] = v[count];
                        ++count;
                    }
                }
            } else {
                for (int j = 0; j < this.n; ++j) {
                    for (int i = 0; i < this.m; ++i) {
                        this.A[i][j] = v[count];
                        ++count;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public double maxAbs() {
        double ma = Math.abs(this.A[0][0]);
        for (int j = 0; j < this.n; ++j) {
            for (int i = 0; i < this.m; ++i) {
                ma = Math.max(ma, Math.abs(this.A[i][j]));
            }
        }
        return ma;
    }

    public double maxAbs(int i0, int i1, int j) {
        double m = Math.abs(this.A[i0][j]);
        for (int i = i0 + 1; i <= i1; ++i) {
            m = Math.max(m, Math.abs(this.A[i][j]));
        }
        return m;
    }

    public double minAbs(int i0, int i1, int column) {
        double m = Math.abs(this.A[i0][column]);
        for (int i = i0 + 1; i <= i1; ++i) {
            m = Math.min(m, Math.abs(this.A[i][column]));
        }
        return m;
    }

    public boolean isEmpty() {
        if (this.m == 0 || this.n == 0) {
            return true;
        }
        return this.A == null;
    }

    public DoubleVector getColumn(int j) {
        DoubleVector v = new DoubleVector(this.m);
        double[] a = v.getArray();
        for (int i = 0; i < this.m; ++i) {
            a[i] = this.A[i][j];
        }
        return v;
    }

    public DoubleVector getColumn(int i0, int i1, int j) {
        DoubleVector v = new DoubleVector(i1 - i0 + 1);
        double[] a = v.getArray();
        int count = 0;
        for (int i = i0; i <= i1; ++i) {
            a[count] = this.A[i][j];
            ++count;
        }
        return v;
    }

    public double times(int i, int j0, int j1, PaceMatrix B, int l) {
        double s = 0.0;
        for (int j = j0; j <= j1; ++j) {
            s += this.A[i][j] * B.A[j][l];
        }
        return s;
    }

    protected DecimalFormat[] format() {
        return this.format(0, this.m - 1, 0, this.n - 1, 7, false);
    }

    protected DecimalFormat[] format(int digits) {
        return this.format(0, this.m - 1, 0, this.n - 1, digits, false);
    }

    protected DecimalFormat[] format(int digits, boolean trailing) {
        return this.format(0, this.m - 1, 0, this.n - 1, digits, trailing);
    }

    protected DecimalFormat format(int i0, int i1, int j, int digits, boolean trailing) {
        FlexibleDecimalFormat df = new FlexibleDecimalFormat(digits, trailing);
        df.grouping(true);
        for (int i = i0; i <= i1; ++i) {
            df.update(this.A[i][j]);
        }
        return df;
    }

    protected DecimalFormat[] format(int i0, int i1, int j0, int j1, int digits, boolean trailing) {
        DecimalFormat[] f = new DecimalFormat[j1 - j0 + 1];
        for (int j = j0; j <= j1; ++j) {
            f[j] = this.format(i0, i1, j, digits, trailing);
        }
        return f;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int digits, boolean trailing) {
        if (this.isEmpty()) {
            return "null matrix";
        }
        StringBuffer text = new StringBuffer();
        DecimalFormat[] nf = this.format(digits, trailing);
        int numCols = 0;
        int count = 0;
        int width = 80;
        int[] nCols = new int[this.n];
        int nk = 0;
        for (int j = 0; j < this.n; ++j) {
            int lenNumber = nf[j].format(this.A[0][j]).length();
            if (count + 1 + lenNumber > width - 1) {
                nCols[nk++] = numCols;
                count = 0;
                numCols = 0;
            }
            count += 1 + lenNumber;
            ++numCols;
        }
        nCols[nk] = numCols;
        nk = 0;
        int k = 0;
        while (k < this.n) {
            for (int i = 0; i < this.m; ++i) {
                for (int j = k; j < k + nCols[nk]; ++j) {
                    text.append(" " + nf[j].format(this.A[i][j]));
                }
                text.append("\n");
            }
            k += nCols[nk];
            ++nk;
            text.append("\n");
        }
        return text.toString();
    }

    public double sum2(int j, int i0, int i1, boolean col) {
        double s2 = 0.0;
        if (col) {
            for (int i = i0; i <= i1; ++i) {
                s2 += this.A[i][j] * this.A[i][j];
            }
        } else {
            for (int i = i0; i <= i1; ++i) {
                s2 += this.A[j][i] * this.A[j][i];
            }
        }
        return s2;
    }

    public double[] sum2(boolean col) {
        int l = col ? this.n : this.m;
        int p = col ? this.m : this.n;
        double[] s2 = new double[l];
        for (int i = 0; i < l; ++i) {
            s2[i] = this.sum2(i, 0, p - 1, col);
        }
        return s2;
    }

    public double[] h1(int j, int k) {
        double[] dq = new double[2];
        double s2 = this.sum2(j, k, this.m - 1, true);
        dq[0] = this.A[k][j] >= 0.0 ? -Math.sqrt(s2) : Math.sqrt(s2);
        double[] dArray = this.A[k];
        int n = j;
        dArray[n] = dArray[n] - dq[0];
        dq[1] = this.A[k][j] * dq[0];
        return dq;
    }

    public void h2(int j, int k, double q, PaceMatrix b, int l) {
        int i;
        double s = 0.0;
        for (i = k; i < this.m; ++i) {
            s += this.A[i][j] * b.A[i][l];
        }
        double alpha = s / q;
        for (i = k; i < this.m; ++i) {
            double[] dArray = b.A[i];
            int n = l;
            dArray[n] = dArray[n] + alpha * this.A[i][j];
        }
    }

    public double[] g1(double a, double b) {
        double[] cs = new double[2];
        double r = Maths.hypot((double)a, (double)b);
        if (r == 0.0) {
            cs[0] = 1.0;
            cs[1] = 0.0;
        } else {
            cs[0] = a / r;
            cs[1] = b / r;
        }
        return cs;
    }

    public void g2(double[] cs, int i0, int i1, int j) {
        double w = cs[0] * this.A[i0][j] + cs[1] * this.A[i1][j];
        this.A[i1][j] = -cs[1] * this.A[i0][j] + cs[0] * this.A[i1][j];
        this.A[i0][j] = w;
    }

    public void forward(PaceMatrix b, IntVector pvt, int k0) {
        for (int j = k0; j < Math.min(pvt.size(), this.m); ++j) {
            this.steplsqr(b, pvt, j, this.mostExplainingColumn(b, pvt, j), true);
        }
    }

    public int mostExplainingColumn(PaceMatrix b, IntVector pvt, int ks) {
        int[] p = pvt.getArray();
        double ma = this.columnResponseExplanation(b, pvt, ks, ks);
        int jma = ks;
        for (int i = ks + 1; i < pvt.size(); ++i) {
            double val = this.columnResponseExplanation(b, pvt, i, ks);
            if (!(val > ma)) continue;
            ma = val;
            jma = i;
        }
        return jma;
    }

    public void backward(PaceMatrix b, IntVector pvt, int ks, int k0) {
        for (int j = ks; j > k0; --j) {
            this.steplsqr(b, pvt, j, this.leastExplainingColumn(b, pvt, j, k0), false);
        }
    }

    public int leastExplainingColumn(PaceMatrix b, IntVector pvt, int ks, int k0) {
        int[] p = pvt.getArray();
        double mi = this.columnResponseExplanation(b, pvt, ks - 1, ks);
        int jmi = ks - 1;
        for (int i = k0; i < ks - 1; ++i) {
            double val = this.columnResponseExplanation(b, pvt, i, ks);
            if (!(val <= mi)) continue;
            mi = val;
            jmi = i;
        }
        return jmi;
    }

    public double columnResponseExplanation(PaceMatrix b, IntVector pvt, int j, int ks) {
        double val;
        double[] xxx = new double[this.n];
        int[] p = pvt.getArray();
        if (j == ks - 1) {
            val = b.A[j][0];
        } else if (j > ks - 1) {
            int jm = Math.min(this.n - 1, j);
            DoubleVector u = this.getColumn(ks, jm, p[j]);
            DoubleVector v = b.getColumn(ks, jm, 0);
            val = v.innerProduct(u) / u.norm2();
        } else {
            int k;
            for (k = j + 1; k < ks; ++k) {
                xxx[k] = this.A[j][p[k]];
            }
            val = b.A[j][0];
            for (k = j + 1; k < ks; ++k) {
                double[] cs = this.g1(xxx[k], this.A[k][p[k]]);
                for (int l = k + 1; l < ks; ++l) {
                    xxx[l] = -cs[1] * xxx[l] + cs[0] * this.A[k][p[l]];
                }
                val = -cs[1] * val + cs[0] * b.A[k][0];
            }
        }
        return val * val;
    }

    public void lsqr(PaceMatrix b, IntVector pvt, int k0) {
        int j;
        double TINY = 1.0E-15;
        int[] p = pvt.getArray();
        int ks = 0;
        for (j = 0; j < k0; ++j) {
            if (this.sum2(p[j], ks, this.m - 1, true) > 1.0E-15) {
                this.steplsqr(b, pvt, ks, j, true);
                ++ks;
                continue;
            }
            pvt.shiftToEnd(j);
            pvt.setSize(pvt.size() - 1);
            --k0;
            --j;
        }
        for (j = k0; j < Math.min(pvt.size(), this.m); ++j) {
            if (this.sum2(p[j], ks, this.m - 1, true) > 1.0E-15) {
                this.steplsqr(b, pvt, ks, j, true);
                ++ks;
                continue;
            }
            pvt.shiftToEnd(j);
            pvt.setSize(pvt.size() - 1);
            --j;
        }
        b.m = this.m = ks;
        pvt.setSize(ks);
    }

    public void lsqrSelection(PaceMatrix b, IntVector pvt, int k0) {
        int numObs = this.m;
        int numXs = pvt.size();
        this.lsqr(b, pvt, k0);
        if (numXs > 200 || numXs > numObs) {
            this.forward(b, pvt, k0);
        }
        this.backward(b, pvt, pvt.size(), k0);
    }

    public void positiveDiagonal(PaceMatrix Y, IntVector pvt) {
        int[] p = pvt.getArray();
        for (int i = 0; i < pvt.size(); ++i) {
            if (!(this.A[i][p[i]] < 0.0)) continue;
            for (int j = i; j < pvt.size(); ++j) {
                this.A[i][p[j]] = -this.A[i][p[j]];
            }
            Y.A[i][0] = -Y.A[i][0];
        }
    }

    public void steplsqr(PaceMatrix b, IntVector pvt, int ks, int j, boolean adjoin) {
        int kp = pvt.size();
        int[] p = pvt.getArray();
        if (adjoin) {
            int k;
            int pj = p[j];
            pvt.swap(ks, j);
            double[] dq = this.h1(pj, ks);
            for (k = ks + 1; k < kp; ++k) {
                int pk = p[k];
                this.h2(pj, ks, dq[1], this, pk);
            }
            this.h2(pj, ks, dq[1], b, 0);
            this.A[ks][pj] = dq[0];
            for (k = ks + 1; k < this.m; ++k) {
                this.A[k][pj] = 0.0;
            }
        } else {
            int pj = p[j];
            for (int i = j; i < ks - 1; ++i) {
                p[i] = p[i + 1];
            }
            p[ks - 1] = pj;
            for (int i = j; i < ks - 1; ++i) {
                int l;
                double[] cs = this.g1(this.A[i][p[i]], this.A[i + 1][p[i]]);
                for (l = i; l < kp; ++l) {
                    this.g2(cs, i, i + 1, p[l]);
                }
                for (l = 0; l < b.n; ++l) {
                    b.g2(cs, i, i + 1, l);
                }
            }
        }
    }

    public void rsolve(PaceMatrix b, IntVector pvt, int kp) {
        if (kp == 0) {
            b.m = 0;
        }
        int[] p = pvt.getArray();
        double[][] ba = b.getArray();
        for (int k = 0; k < b.n; ++k) {
            double[] dArray = ba[kp - 1];
            int n = k;
            dArray[n] = dArray[n] / this.A[kp - 1][p[kp - 1]];
            for (int i = kp - 2; i >= 0; --i) {
                double s = 0.0;
                for (int j = i + 1; j < kp; ++j) {
                    s += this.A[i][p[j]] * ba[j][k];
                }
                double[] dArray2 = ba[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] - s;
                double[] dArray3 = ba[i];
                int n3 = k;
                dArray3[n3] = dArray3[n3] / this.A[i][p[i]];
            }
        }
        b.m = kp;
    }

    public PaceMatrix rbind(PaceMatrix b) {
        if (this.n != b.n) {
            throw new IllegalArgumentException("unequal numbers of rows.");
        }
        PaceMatrix c = new PaceMatrix(this.m + b.m, this.n);
        c.setMatrix(0, this.m - 1, 0, this.n - 1, this);
        c.setMatrix(this.m, this.m + b.m - 1, 0, this.n - 1, b);
        return c;
    }

    public PaceMatrix cbind(PaceMatrix b) {
        if (this.m != b.m) {
            throw new IllegalArgumentException("unequal numbers of rows: " + this.m + " and " + b.m);
        }
        PaceMatrix c = new PaceMatrix(this.m, this.n + b.n);
        c.setMatrix(0, this.m - 1, 0, this.n - 1, this);
        c.setMatrix(0, this.m - 1, this.n, this.n + b.n - 1, b);
        return c;
    }

    /*
     * Exception decompiling
     */
    public DoubleVector nnls(PaceMatrix b, IntVector pvt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DoubleVector nnlse(PaceMatrix b, PaceMatrix c, PaceMatrix d, IntVector pvt) {
        double eps = 1.0E-10 * Math.max(c.maxAbs(), d.maxAbs()) / Math.max(this.maxAbs(), b.maxAbs());
        PaceMatrix e = c.rbind(new PaceMatrix(this.times(eps)));
        PaceMatrix f = d.rbind(new PaceMatrix(b.times(eps)));
        return e.nnls(f, pvt);
    }

    public DoubleVector nnlse1(PaceMatrix b, IntVector pvt) {
        PaceMatrix c = new PaceMatrix(1, this.n, 1.0);
        PaceMatrix d = new PaceMatrix(1, b.n, 1.0);
        return this.nnlse(b, c, d, pvt);
    }

    public static Matrix randomNormal(int m, int n) {
        Random random = new Random();
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = random.nextGaussian();
            }
        }
        return A;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 8109 $");
    }

    public static void main(String[] args) {
        System.out.println("===========================================================");
        System.out.println("To test the pace estimators of linear model\ncoefficients.\n");
        double sd = 2.0;
        int n = 200;
        double beta0 = 100.0;
        int k1 = 20;
        double beta1 = 0.0;
        int k2 = 20;
        double beta2 = 5.0;
        int k = 1 + k1 + k2;
        DoubleVector beta = new DoubleVector(1 + k1 + k2);
        beta.set(0, beta0);
        beta.set(1, k1, beta1);
        beta.set(k1 + 1, k1 + k2, beta2);
        System.out.println("The data set contains " + n + " observations plus " + (k1 + k2) + " variables.\n\nThe coefficients of the true model" + " are:\n\n" + beta);
        System.out.println("\nThe standard deviation of the error term is " + sd);
        System.out.println("===========================================================");
        PaceMatrix X = new PaceMatrix(n, k1 + k2 + 1);
        X.setMatrix(0, n - 1, 0, 0, 1.0);
        X.setMatrix(0, n - 1, 1, k1 + k2, PaceMatrix.random((int)n, (int)(k1 + k2)));
        PaceMatrix Y = new PaceMatrix(X.times(new PaceMatrix(beta)).plusEquals(PaceMatrix.randomNormal(n, 1).times(sd)));
        IntVector pvt = IntVector.seq((int)0, (int)(k1 + k2));
        X.lsqrSelection(Y, pvt, 1);
        X.positiveDiagonal(Y, pvt);
        PaceMatrix sol = (PaceMatrix)((Object)Y.clone());
        X.rsolve(sol, pvt, pvt.size());
        DoubleVector betaHat = sol.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe OLS estimate (through lsqr()) is: \n\n" + betaHat);
        System.out.println("\nQuadratic loss of the OLS estimate (||X b - X bHat||^2) = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaHat)))).getColumn(0).sum2());
        System.out.println("===========================================================");
        System.out.println("             *** Pace estimation *** \n");
        DoubleVector r = Y.getColumn(pvt.size(), n - 1, 0);
        double sde = Math.sqrt(r.sum2() / (double)r.size());
        System.out.println("Estimated standard deviation = " + sde);
        DoubleVector aHat = Y.getColumn(0, pvt.size() - 1, 0).times(1.0 / sde);
        System.out.println("\naHat = \n" + aHat);
        System.out.println("\n========= Based on chi-square mixture ============");
        ChisqMixture d2 = new ChisqMixture();
        int method = 1;
        DoubleVector AHat = aHat.square();
        d2.fit(AHat, method);
        System.out.println("\nEstimated mixing distribution is:\n" + d2);
        DoubleVector ATilde = d2.pace2(AHat);
        DoubleVector aTilde = ATilde.sqrt().times(aHat.sign());
        PaceMatrix YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        DoubleVector betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe pace2 estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        ATilde = d2.pace4(AHat);
        aTilde = ATilde.sqrt().times(aHat.sign());
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe pace4 estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        ATilde = d2.pace6(AHat);
        aTilde = ATilde.sqrt().times(aHat.sign());
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe pace6 estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        System.out.println("\n========= Based on normal mixture ============");
        NormalMixture d = new NormalMixture();
        d.fit(aHat, method);
        System.out.println("\nEstimated mixing distribution is:\n" + d);
        aTilde = d.nestedEstimate(aHat);
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("The nested estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        aTilde = d.subsetEstimate(aHat);
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe subset estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
        aTilde = d.empiricalBayesEstimate(aHat);
        YTilde = new PaceMatrix(new PaceMatrix(aTilde).times(sde));
        X.rsolve(YTilde, pvt, pvt.size());
        betaTilde = YTilde.getColumn(0).unpivoting(pvt, k);
        System.out.println("\nThe empirical Bayes estimate of coefficients = \n" + betaTilde);
        System.out.println("Quadratic loss = " + new PaceMatrix(X.times(new PaceMatrix(beta.minus(betaTilde)))).getColumn(0).sum2());
    }
}

