/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;
import weka.core.AbstractInstance;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.mathematicalexpression.Parser;
import weka.core.mathematicalexpression.Scanner;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class MathExpression
extends PotentialClassIgnorer
implements UnsupervisedFilter {
    static final long serialVersionUID = -3713222714671997901L;
    protected Range m_SelectCols = new Range();
    public static final String m_defaultExpression = "(A-MIN)/(MAX-MIN)";
    private String m_expression = "(A-MIN)/(MAX-MIN)";
    private AttributeStats[] m_attStats;

    public MathExpression() {
        this.setInvertSelection(false);
    }

    public String globalInfo() {
        return "Modify numeric attributes according to a given expression ";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        this.m_SelectCols.setUpper(instanceInfo.numAttributes() - 1);
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_attStats = null;
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_attStats == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_attStats == null) {
            int i;
            Instances input = this.getInputFormat();
            this.m_attStats = new AttributeStats[input.numAttributes()];
            for (i = 0; i < input.numAttributes(); ++i) {
                if (!input.attribute(i).isNumeric() || input.classIndex() == i) continue;
                this.m_attStats[i] = input.attributeStats(i);
            }
            for (i = 0; i < input.numInstances(); ++i) {
                this.convertInstance(input.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected double eval(HashMap<String, Double> symbols) {
        double result;
        try {
            DefaultSymbolFactory sf = new DefaultSymbolFactory();
            ByteArrayInputStream parserInput = new ByteArrayInputStream(this.m_expression.getBytes());
            Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
            parser.setSymbols(symbols);
            parser.parse();
            result = parser.getResult();
        }
        catch (Exception e) {
            result = Double.NaN;
            e.printStackTrace();
        }
        return result;
    }

    private void convertInstance(Instance instance) throws Exception {
        AbstractInstance inst = null;
        HashMap<String, Double> symbols = new HashMap<String, Double>(5);
        if (instance instanceof SparseInstance) {
            double[] newVals = new double[instance.numAttributes()];
            int[] newIndices = new int[instance.numAttributes()];
            double[] vals = instance.toDoubleArray();
            double[] valsCopy = instance.toDoubleArray();
            for (int z = 0; z < this.getInputFormat().numAttributes(); ++z) {
                if (!instance.attribute(z).isNumeric() || z == this.getInputFormat().classIndex()) continue;
                symbols.put("A" + (z + 1), new Double(valsCopy[z]));
            }
            int ind = 0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                double value;
                if (this.m_SelectCols.isInRange(j)) {
                    if (!instance.attribute(j).isNumeric() || Utils.isMissingValue(vals[j]) || this.getInputFormat().classIndex() == j) continue;
                    symbols.put("A", new Double(vals[j]));
                    symbols.put("MAX", new Double(this.m_attStats[j].numericStats.max));
                    symbols.put("MIN", new Double(this.m_attStats[j].numericStats.min));
                    symbols.put("MEAN", new Double(this.m_attStats[j].numericStats.mean));
                    symbols.put("SD", new Double(this.m_attStats[j].numericStats.stdDev));
                    symbols.put("COUNT", new Double(this.m_attStats[j].numericStats.count));
                    symbols.put("SUM", new Double(this.m_attStats[j].numericStats.sum));
                    symbols.put("SUMSQUARED", new Double(this.m_attStats[j].numericStats.sumSq));
                    value = this.eval(symbols);
                    if (Double.isNaN(value) || Double.isInfinite(value)) {
                        System.err.println("WARNING:Error in evaluating the expression: missing value set");
                        value = Utils.missingValue();
                    }
                    if (value == 0.0) continue;
                    newVals[ind] = value;
                    newIndices[ind] = j;
                    ++ind;
                    continue;
                }
                value = vals[j];
                if (value == 0.0) continue;
                newVals[ind] = value;
                newIndices[ind] = j;
                ++ind;
            }
            double[] tempVals = new double[ind];
            int[] tempInd = new int[ind];
            System.arraycopy(newVals, 0, tempVals, 0, ind);
            System.arraycopy(newIndices, 0, tempInd, 0, ind);
            inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
        } else {
            double[] vals = instance.toDoubleArray();
            double[] valsCopy = instance.toDoubleArray();
            for (int z = 0; z < this.getInputFormat().numAttributes(); ++z) {
                if (!instance.attribute(z).isNumeric() || z == this.getInputFormat().classIndex()) continue;
                symbols.put("A" + (z + 1), new Double(valsCopy[z]));
            }
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                if (!this.m_SelectCols.isInRange(j) || !instance.attribute(j).isNumeric() || Utils.isMissingValue(vals[j]) || this.getInputFormat().classIndex() == j) continue;
                symbols.put("A", new Double(vals[j]));
                symbols.put("MAX", new Double(this.m_attStats[j].numericStats.max));
                symbols.put("MIN", new Double(this.m_attStats[j].numericStats.min));
                symbols.put("MEAN", new Double(this.m_attStats[j].numericStats.mean));
                symbols.put("SD", new Double(this.m_attStats[j].numericStats.stdDev));
                symbols.put("COUNT", new Double(this.m_attStats[j].numericStats.count));
                symbols.put("SUM", new Double(this.m_attStats[j].numericStats.sum));
                symbols.put("SUMSQUARED", new Double(this.m_attStats[j].numericStats.sumSq));
                vals[j] = this.eval(symbols);
                if (!Double.isNaN(vals[j]) && !Double.isInfinite(vals[j])) continue;
                System.err.println("WARNING:Error in Evaluation the Expression: missing value set");
                vals[j] = Utils.missingValue();
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String expString = Utils.getOption('E', options);
        if (expString.length() != 0) {
            this.setExpression(expString);
        } else {
            this.setExpression(m_defaultExpression);
        }
        String ignoreList = Utils.getOption('R', options);
        if (ignoreList.length() != 0) {
            this.setIgnoreRange(ignoreList);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add(this.getExpression());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        if (!this.getIgnoreRange().equals("")) {
            result.add("-R");
            result.add(this.getIgnoreRange());
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify the expression to apply. Eg. pow(A,6)/(MEAN+MAX)\n\tSupported operators are +, -, *, /, pow, log,\n\tabs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ), \n\tMEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse. The 'A'\n\tletter refers to the value of the attribute being processed.\n\tOther attribute values (numeric only) can be accessed through\n\tthe variables A1, A2, A3, ...", "E", 1, "-E <expression>"));
        result.addElement(new Option("\tSpecify list of columns to ignore. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        result.addElement(new Option("\tInvert matching sense (i.e. only modify specified columns)", "V", 0, "-V"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String expressionTipText() {
        return "Specify the expression to apply. The 'A' letterrefers to the value of the attribute being processed. MIN,MAX,MEAN,SDrefer respectively to minimum, maximum, mean andstandard deviation of the attribute being processed. Other attribute values (numeric only) can be accessed through the variables A1, A2, A3, ...\n\tSupported operators are +, -, *, /, pow, log,abs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ),A,MEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse\n\tEg. pow(A,6)/(MEAN+MAX)*ifelse(A<0,0,sqrt(A))+ifelse(![A>9 && A<15])";
    }

    public void setExpression(String expr) {
        this.m_expression = expr;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or unselect. If set to true, only the specified attributes will be modified; If set to false, specified attributes will not be modified.";
    }

    public boolean getInvertSelection() {
        return !this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_SelectCols.setInvert(!invert);
    }

    public String ignoreRangeTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getIgnoreRange() {
        return this.m_SelectCols.getRanges();
    }

    public void setIgnoreRange(String rangeList) {
        this.m_SelectCols.setRanges(rangeList);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        MathExpression.runFilter(new MathExpression(), argv);
    }
}

