/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.OptionHandler;
import weka.core.SerializationHelper;
import weka.core.stopwords.StopwordsHandler;
import weka.test.Regression;

public abstract class AbstractStopwordsTest
extends TestCase {
    protected String[] m_Data;
    protected StopwordsHandler m_Stopwords;
    protected CheckOptionHandler m_OptionTester;
    protected CheckGOE m_GOETester;

    public AbstractStopwordsTest(String name) {
        super(name);
    }

    public String getTmpDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getTmpLocationFromResource(String resource) {
        File file = new File(resource);
        String result = this.getTmpDirectory() + File.separator + file.getName();
        return result;
    }

    protected String getDataDirectory() {
        return "weka/core/stopwords";
    }

    public boolean copyResourceToTmp(String resource) {
        boolean result;
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        resource = this.getDataDirectory() + "/" + resource;
        try {
            int read;
            input = new BufferedInputStream(ClassLoader.getSystemResourceAsStream(resource));
            output = new BufferedOutputStream(new FileOutputStream(this.getTmpLocationFromResource(resource)));
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer)) != -1) {
                ((BufferedOutputStream)output).write(buffer, 0, read);
                if (read >= buffer.length) continue;
            }
            result = true;
        }
        catch (IOException e) {
            if (e.getMessage().equals("Stream closed")) {
                System.err.println("Resource '" + resource + "' not available?");
            }
            e.printStackTrace();
            result = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean deleteFileFromTmp(String filename) {
        boolean result = true;
        File file = new File(this.getTmpDirectory() + File.separator + filename);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }

    protected String[] getData() {
        return new String[]{"Humpty Dumpty was sitting, with his legs crossed like a Turk, on the top of a high wall -- such a narrow one that Alice quite wondered how he could keep his balance -- and, as his eyes were steadily fixed in the opposite direction, and he didn't take the least notice of her, she thought he must be a stuffed figure, after all.", "The planet Mars, I scarcely need remind the reader, revolves about the sun at a mean distance of 140,000,000 miles, and the light and heat it receives from the sun is barely half of that received by this world.", "I've studied now Philosophy And Jurisprudence, Medicine, And even, alas! Theology All through and through with ardour keen! Here now I stand, poor fool, and see I'm just as wise as formerly."};
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        if (this.getStopwords() instanceof OptionHandler) {
            result.setOptionHandler((OptionHandler)this.getStopwords());
        } else {
            result.setOptionHandler(null);
        }
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject((Object)this.getStopwords());
        result.setSilent(true);
        return result;
    }

    protected void setUp() throws Exception {
        this.m_Stopwords = this.getStopwords();
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_Data = this.getData();
    }

    protected void tearDown() {
        this.m_Stopwords = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_Data = null;
    }

    public abstract StopwordsHandler getStopwords();

    public void testSerialVersionUID() {
        boolean result;
        boolean bl = result = !SerializationHelper.needsUID(this.m_Stopwords.getClass());
        if (!result) {
            AbstractStopwordsTest.fail((String)"Doesn't declare serialVersionUID!");
        }
    }

    protected String[] tokenize(String s) {
        StringTokenizer tok = new StringTokenizer(s, " \t\n\r\f,.!?");
        String[] data = new String[tok.countTokens()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = tok.nextToken();
        }
        return data;
    }

    public void testBuildInitialization() {
        int i;
        int n;
        boolean[][][] processed = new boolean[2][this.m_Data.length][];
        for (n = 0; n < 2; ++n) {
            for (i = 0; i < this.m_Data.length; ++i) {
                try {
                    String[] data = this.tokenize(this.m_Data[i]);
                    processed[n][i] = new boolean[data.length];
                    for (int m = 0; m < data.length; ++m) {
                        processed[n][i][m] = this.m_Stopwords.isStopword(data[m]);
                    }
                    continue;
                }
                catch (Exception e) {
                    processed[n][i] = new boolean[]{false};
                }
            }
        }
        boolean result = true;
        String msg = "";
        block5: for (i = 0; i < this.m_Data.length; ++i) {
            if (processed[0].length == processed[1].length) {
                for (n = 0; n < processed[0][i].length; ++n) {
                    if (processed[0][i][n] == processed[1][i][n]) continue;
                    result = false;
                    msg = "different stopwords results";
                    continue block5;
                }
                continue;
            }
            result = false;
            msg = "different number of stopwords";
            break;
        }
        if (!result) {
            AbstractStopwordsTest.fail((String)("Incorrect build initialization (" + msg + ")!"));
        }
    }

    protected Boolean[] useStopwords(String[] tokens) throws Exception {
        Boolean[] result = new Boolean[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = this.m_Stopwords.isStopword(tokens[i]);
        }
        return result;
    }

    protected String predictionsToString(String[] tokens, Boolean[] results) {
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.length).append(" words\n");
        for (int i = 0; i < tokens.length; ++i) {
            sb.append(tokens[i]).append(" --> ").append(results[i]).append('\n');
        }
        return sb.toString();
    }

    public void testRegression() {
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        boolean succeeded = false;
        for (int i = 0; i < this.m_Data.length; ++i) {
            Boolean[] results;
            try {
                String[] tokens = this.tokenize(this.m_Data[i]);
                results = this.useStopwords(tokens);
                succeeded = true;
                reg.println(this.predictionsToString(tokens, results));
                continue;
            }
            catch (Exception e) {
                results = new Boolean[]{};
            }
        }
        if (!succeeded) {
            AbstractStopwordsTest.fail((String)"Problem during regression testing: no successful results generated for any string");
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractStopwordsTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractStopwordsTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }

    public void testListOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
            AbstractStopwordsTest.fail((String)"Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractStopwordsTest.fail((String)"setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkDefaultOptions()) {
            AbstractStopwordsTest.fail((String)"Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
            AbstractStopwordsTest.fail((String)"There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractStopwordsTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractStopwordsTest.fail((String)"Resetting of options failed");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractStopwordsTest.fail((String)"No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractStopwordsTest.fail((String)"Tool tips inconsistent");
        }
    }
}

