/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.stopwords.AbstractStopwordsTest;
import weka.core.stopwords.MultiStopwords;
import weka.core.stopwords.Rainbow;
import weka.core.stopwords.RegExpFromFile;
import weka.core.stopwords.StopwordsHandler;
import weka.core.stopwords.WordsFromFile;

public class MultiStopwordsTest
extends AbstractStopwordsTest {
    public MultiStopwordsTest(String name) {
        super(name);
    }

    @Override
    public StopwordsHandler getStopwords() {
        MultiStopwords result = new MultiStopwords();
        StopwordsHandler[] handlers = new StopwordsHandler[3];
        handlers[0] = new Rainbow();
        handlers[1] = new WordsFromFile();
        ((WordsFromFile)handlers[1]).setStopwords(new File(this.getTmpDirectory() + File.separator + "WordsFromFile.txt"));
        handlers[2] = new RegExpFromFile();
        ((RegExpFromFile)handlers[2]).setStopwords(new File(this.getTmpDirectory() + File.separator + "RegExpFromFile.txt"));
        result.setStopwords(handlers);
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.copyResourceToTmp("WordsFromFile.txt");
        this.copyResourceToTmp("RegExpFromFile.txt");
    }

    @Override
    protected void tearDown() {
        this.deleteFileFromTmp("WordsFromFile.txt");
        this.deleteFileFromTmp("RegExpFromFile.txt");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(MultiStopwordsTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiStopwordsTest.suite());
    }
}

