/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.MergeNominalValues;

public class MergeNominalValuesTest
extends AbstractFilterTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    public MergeNominalValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        MergeNominalValues f = new MergeNominalValues();
        return f;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MergeNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        Attribute mergedAtt = result.attribute(4);
        MergeNominalValuesTest.assertTrue((String)"Attribute 5 has all values merged in result", (boolean)mergedAtt.value(0).equals("a_or_b_or_c_or_d"));
    }

    public void testDifferentRange() {
        ((MergeNominalValues)this.m_Filter).setAttributeIndices("1,3");
        ((MergeNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        MergeNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public void testAttributeWithMissing() {
        ((MergeNominalValues)this.m_Filter).setAttributeIndices("5");
        Instances result = this.useFilter();
        MergeNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int i = 0; i < result.numInstances(); ++i) {
            if (!this.m_Instances.instance(i).isMissing(4)) continue;
            MergeNominalValuesTest.assertTrue((String)"Missing in input should give missing in result", (boolean)result.instance(i).isMissing(4));
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i || !data.attribute(i).isNominal()) continue;
                ((MergeNominalValues)this.m_FilteredClassifier.getFilter()).setAttributeIndices("" + (i + 1));
                break;
            }
        }
        catch (Exception e) {
            MergeNominalValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MergeNominalValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MergeNominalValuesTest.suite());
    }
}

