/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RandomProjection;

public class RandomProjectionTest
extends AbstractFilterTest {
    public RandomProjectionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.deleteAttributeType(2);
        this.m_Instances.setClassIndex(1);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter(new RandomProjection().getNumberOfAttributes());
    }

    protected Filter getFilter(int numAtts) {
        RandomProjection f = new RandomProjection();
        f.setNumberOfAttributes(numAtts);
        return f;
    }

    protected void checkResult(Instances result) {
        RandomProjectionTest.assertEquals((int)(((RandomProjection)this.m_Filter).getNumberOfAttributes() + 1), (int)result.numAttributes());
        RandomProjectionTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    protected void checkDistributionType(int type) {
        this.m_Filter = this.getFilter();
        ((RandomProjection)this.m_Filter).setDistribution(new SelectedTag(type, RandomProjection.TAGS_DSTRS_TYPE));
        Instances result = this.useFilter();
        this.checkResult(result);
    }

    public void testSparse1() {
        this.checkDistributionType(1);
    }

    public void testSparse2() {
        this.checkDistributionType(2);
    }

    public void testGaussian() {
        this.checkDistributionType(3);
    }

    public void testNumberOfAttributes() {
        this.m_Filter = this.getFilter(5);
        Instances result = this.useFilter();
        this.checkResult(result);
    }

    public static Test suite() {
        return new TestSuite(RandomProjectionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RandomProjectionTest.suite());
    }
}

