/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class OneRAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    static final long serialVersionUID = 4386514823886856980L;
    private Instances m_trainInstances;
    private int m_randomSeed;
    private int m_folds;
    private boolean m_evalUsingTrainingData;
    private int m_minBucketSize;

    public String globalInfo() {
        return "OneRAttributeEval :\n\nEvaluates the worth of an attribute by using the OneR classifier.\n";
    }

    public String seedTipText() {
        return "Set the seed for use in cross validation.";
    }

    public void setSeed(int seed) {
        this.m_randomSeed = seed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String foldsTipText() {
        return "Set the number of folds for cross validation.";
    }

    public void setFolds(int folds) {
        this.m_folds = folds;
        if (this.m_folds < 2) {
            this.m_folds = 2;
        }
    }

    public int getFolds() {
        return this.m_folds;
    }

    public String evalUsingTrainingDataTipText() {
        return "Use the training data to evaluate attributes rather than cross validation.";
    }

    public void setEvalUsingTrainingData(boolean e) {
        this.m_evalUsingTrainingData = e;
    }

    public String minimumBucketSizeTipText() {
        return "The minimum number of objects in a bucket (passed to OneR).";
    }

    public void setMinimumBucketSize(int minB) {
        this.m_minBucketSize = minB;
    }

    public int getMinimumBucketSize() {
        return this.m_minBucketSize;
    }

    public boolean getEvalUsingTrainingData() {
        return this.m_evalUsingTrainingData;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tRandom number seed for cross validation\n\t(default = 1)", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tNumber of folds for cross validation\n\t(default = 10)", "F", 1, "-F <folds>"));
        newVector.addElement(new Option("\tUse training data for evaluation rather than cross validaton", "D", 0, "-D"));
        newVector.addElement(new Option("\tMinimum number of objects in a bucket\n\t(passed on to OneR, default = 6)", "B", 1, "-B <minimum bucket size>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String temp = Utils.getOption('S', options);
        if (temp.length() != 0) {
            this.setSeed(Integer.parseInt(temp));
        }
        if ((temp = Utils.getOption('F', options)).length() != 0) {
            this.setFolds(Integer.parseInt(temp));
        }
        if ((temp = Utils.getOption('B', options)).length() != 0) {
            this.setMinimumBucketSize(Integer.parseInt(temp));
        }
        this.setEvalUsingTrainingData(Utils.getFlag('D', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getEvalUsingTrainingData()) {
            options.add("-D");
        }
        options.add("-S");
        options.add("" + this.getSeed());
        options.add("-F");
        options.add("" + this.getFolds());
        options.add("-B");
        options.add("" + this.getMinimumBucketSize());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public OneRAttributeEval() {
        this.resetOptions();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = data;
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_randomSeed = 1;
        this.m_folds = 10;
        this.m_evalUsingTrainingData = false;
        this.m_minBucketSize = 6;
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        int[] featArray = new int[2];
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        Instances trainCopy = new Instances(this.m_trainInstances);
        featArray[0] = attribute;
        featArray[1] = trainCopy.classIndex();
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        trainCopy = Filter.useFilter(trainCopy, delTransform);
        Evaluation o_Evaluation = new Evaluation(trainCopy);
        String[] oneROpts = new String[]{"-B", "" + this.getMinimumBucketSize()};
        Classifier oneR = AbstractClassifier.forName("weka.classifiers.rules.OneR", oneROpts);
        if (this.m_evalUsingTrainingData) {
            oneR.buildClassifier(trainCopy);
            o_Evaluation.evaluateModel(oneR, trainCopy, new Object[0]);
        } else {
            o_Evaluation.crossValidateModel(oneR, trainCopy, this.m_folds, new Random(this.m_randomSeed));
        }
        double errorRate = o_Evaluation.errorRate();
        return (1.0 - errorRate) * 100.0;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("\tOneR feature evaluator has not been built yet");
        } else {
            text.append("\tOneR feature evaluator.\n\n");
            text.append("\tUsing ");
            if (this.m_evalUsingTrainingData) {
                text.append("training data for evaluation of attributes.");
            } else {
                text.append("" + this.getFolds() + " fold cross validation for evaluating attributes.");
            }
            text.append("\n\tMinimum bucket size for OneR: " + this.getMinimumBucketSize());
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15519 $");
    }

    @Override
    public int[] postProcess(int[] attributeSet) {
        this.m_trainInstances = new Instances(this.m_trainInstances, 0);
        return attributeSet;
    }

    public static void main(String[] args) {
        OneRAttributeEval.runEvaluator(new OneRAttributeEval(), args);
    }
}

