/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import java.util.LinkedList;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ClassifierTree
implements Drawable,
Serializable,
RevisionHandler,
CapabilitiesHandler {
    static final long serialVersionUID = -8722249377542734193L;
    protected ModelSelection m_toSelectModel;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierTree[] m_sons;
    protected boolean m_isLeaf;
    protected boolean m_isEmpty;
    protected Instances m_train;
    protected Distribution m_test;
    protected int m_id;
    private static long PRINTED_NODES = 0L;

    public ClassifierSplitModel getLocalModel() {
        return this.m_localModel;
    }

    public ClassifierTree[] getSons() {
        return this.m_sons;
    }

    public boolean isLeaf() {
        return this.m_isLeaf;
    }

    public Instances getTrainingData() {
        return this.m_train;
    }

    protected static long nextID() {
        return PRINTED_NODES++;
    }

    protected static void resetID() {
        PRINTED_NODES = 0L;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    public ClassifierTree(ModelSelection toSelectLocModel) {
        this.m_toSelectModel = toSelectLocModel;
    }

    public void buildClassifier(Instances data) throws Exception {
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.buildTree(data, false);
    }

    public void buildTree(Instances data, boolean keepData) throws Exception {
        if (keepData) {
            this.m_train = data;
        }
        this.m_test = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.m_localModel = this.m_toSelectModel.selectModel(data);
        if (this.m_localModel.numSubsets() > 1) {
            Instances[] localInstances = this.m_localModel.split(data);
            data = null;
            this.m_sons = new ClassifierTree[this.m_localModel.numSubsets()];
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i] = this.getNewTree(localInstances[i]);
                localInstances[i] = null;
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(data.sumOfWeights(), 0.0)) {
                this.m_isEmpty = true;
            }
            data = null;
        }
    }

    public void buildTree(Instances train, Instances test, boolean keepData) throws Exception {
        if (keepData) {
            this.m_train = train;
        }
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.m_localModel = this.m_toSelectModel.selectModel(train, test);
        this.m_test = new Distribution(test, this.m_localModel);
        if (this.m_localModel.numSubsets() > 1) {
            Instances[] localTrain = this.m_localModel.split(train);
            Instances[] localTest = this.m_localModel.split(test);
            train = null;
            test = null;
            this.m_sons = new ClassifierTree[this.m_localModel.numSubsets()];
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i] = this.getNewTree(localTrain[i], localTest[i]);
                localTrain[i] = null;
                localTest[i] = null;
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(train.sumOfWeights(), 0.0)) {
                this.m_isEmpty = true;
            }
            train = null;
            test = null;
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double maxProb = -1.0;
        int maxIndex = 0;
        for (int j = 0; j < instance.numClasses(); ++j) {
            double currentProb = this.getProbs(j, instance, 1.0);
            if (!Utils.gr(currentProb, maxProb)) continue;
            maxIndex = j;
            maxProb = currentProb;
        }
        return maxIndex;
    }

    public final void cleanup(Instances justHeaderInfo) {
        this.m_train = justHeaderInfo;
        this.m_test = null;
        if (!this.m_isLeaf) {
            for (ClassifierTree m_son : this.m_sons) {
                m_son.cleanup(justHeaderInfo);
            }
        }
    }

    public double[] distributionForInstance(Instance instance, boolean useLaplace) throws Exception {
        double[] doubles = new double[instance.numClasses()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = !useLaplace ? this.getProbs(i, instance, 1.0) : this.getProbsLaplace(i, instance, 1.0);
        }
        return doubles;
    }

    public int assignIDs(int lastID) {
        int currLastID;
        this.m_id = currLastID = lastID + 1;
        if (this.m_sons != null) {
            for (ClassifierTree m_son : this.m_sons) {
                currLastID = m_son.assignIDs(currLastID);
            }
        }
        return currLastID;
    }

    @Override
    public int graphType() {
        return 1;
    }

    @Override
    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        this.assignIDs(-1);
        text.append("digraph J48Tree {\n");
        if (this.m_isLeaf) {
            text.append("N" + this.m_id + " [label=\"" + Utils.backQuoteChars(this.m_localModel.dumpLabel(0, this.m_train)) + "\" shape=box style=filled ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                text.append("data =\n" + this.m_train + "\n");
                text.append(",\n");
            }
            text.append("]\n");
        } else {
            text.append("N" + this.m_id + " [label=\"" + Utils.backQuoteChars(this.m_localModel.leftSide(this.m_train)) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                text.append("data =\n" + this.m_train + "\n");
                text.append(",\n");
            }
            text.append("]\n");
            this.graphTree(text);
        }
        return text.toString() + "}\n";
    }

    public String prefix() throws Exception {
        StringBuffer text = new StringBuffer();
        if (this.m_isLeaf) {
            text.append("[" + this.m_localModel.dumpLabel(0, this.m_train) + "]");
        } else {
            this.prefixTree(text);
        }
        return text.toString();
    }

    public StringBuffer[] toSource(String className) throws Exception {
        StringBuffer[] result = new StringBuffer[2];
        if (this.m_isLeaf) {
            result[0] = new StringBuffer("    p = " + this.m_localModel.distribution().maxClass(0) + ";\n");
            result[1] = new StringBuffer("");
        } else {
            StringBuffer text = new StringBuffer();
            StringBuffer atEnd = new StringBuffer();
            long printID = ClassifierTree.nextID();
            text.append("  static double N").append(Integer.toHexString(this.m_localModel.hashCode()) + printID).append("(Object []i) {\n").append("    double p = Double.NaN;\n");
            text.append("    if (").append(this.m_localModel.sourceExpression(-1, this.m_train)).append(") {\n");
            text.append("      p = ").append(this.m_localModel.distribution().maxClass(0)).append(";\n");
            text.append("    } ");
            for (int i = 0; i < this.m_sons.length; ++i) {
                text.append("else if (" + this.m_localModel.sourceExpression(i, this.m_train) + ") {\n");
                if (this.m_sons[i].m_isLeaf) {
                    text.append("      p = " + this.m_localModel.distribution().maxClass(i) + ";\n");
                } else {
                    StringBuffer[] sub = this.m_sons[i].toSource(className);
                    text.append(sub[0]);
                    atEnd.append(sub[1]);
                }
                text.append("    } ");
                if (i != this.m_sons.length - 1) continue;
                text.append('\n');
            }
            text.append("    return p;\n  }\n");
            result[0] = new StringBuffer("    p = " + className + ".N");
            result[0].append(Integer.toHexString(this.m_localModel.hashCode()) + printID).append("(i);\n");
            result[1] = text.append(atEnd);
        }
        return result;
    }

    public int numLeaves() {
        int num = 0;
        if (this.m_isLeaf) {
            return 1;
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            num += this.m_sons[i].numLeaves();
        }
        return num;
    }

    public int numNodes() {
        int no = 1;
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                no += this.m_sons[i].numNodes();
            }
        }
        return no;
    }

    public String toString() {
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf) {
                text.append(": ");
                text.append(this.m_localModel.dumpLabel(0, this.m_train));
            } else {
                this.dumpTree(0, text);
            }
            text.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            text.append("\nSize of the tree : \t" + this.numNodes() + "\n");
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print classification tree.";
        }
    }

    protected ClassifierTree getNewTree(Instances data) throws Exception {
        ClassifierTree newTree = new ClassifierTree(this.m_toSelectModel);
        newTree.buildTree(data, false);
        return newTree;
    }

    protected ClassifierTree getNewTree(Instances train, Instances test) throws Exception {
        ClassifierTree newTree = new ClassifierTree(this.m_toSelectModel);
        newTree.buildTree(train, test, false);
        return newTree;
    }

    private void dumpTree(int depth, StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("\n");
            for (int j = 0; j < depth; ++j) {
                text.append("|   ");
            }
            text.append(this.m_localModel.leftSide(this.m_train));
            text.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                text.append(": ");
                text.append(this.m_localModel.dumpLabel(i, this.m_train));
                continue;
            }
            this.m_sons[i].dumpTree(depth + 1, text);
        }
    }

    private void graphTree(StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("N" + this.m_id + "->N" + this.m_sons[i].m_id + " [label=\"" + Utils.backQuoteChars(this.m_localModel.rightSide(i, this.m_train).trim()) + "\"]\n");
            if (this.m_sons[i].m_isLeaf) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"" + Utils.backQuoteChars(this.m_localModel.dumpLabel(i, this.m_train)) + "\" shape=box style=filled ");
                if (this.m_train != null && this.m_train.numInstances() > 0) {
                    text.append("data =\n" + this.m_sons[i].m_train + "\n");
                    text.append(",\n");
                }
                text.append("]\n");
                continue;
            }
            text.append("N" + this.m_sons[i].m_id + " [label=\"" + Utils.backQuoteChars(this.m_sons[i].m_localModel.leftSide(this.m_train)) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                text.append("data =\n" + this.m_sons[i].m_train + "\n");
                text.append(",\n");
            }
            text.append("]\n");
            this.m_sons[i].graphTree(text);
        }
    }

    private void prefixTree(StringBuffer text) throws Exception {
        int i;
        text.append("[");
        text.append(this.m_localModel.leftSide(this.m_train) + ":");
        for (i = 0; i < this.m_sons.length; ++i) {
            if (i > 0) {
                text.append(",\n");
            }
            text.append(this.m_localModel.rightSide(i, this.m_train));
        }
        for (i = 0; i < this.m_sons.length; ++i) {
            if (this.m_sons[i].m_isLeaf) {
                text.append("[");
                text.append(this.m_localModel.dumpLabel(i, this.m_train));
                text.append("]");
                continue;
            }
            this.m_sons[i].prefixTree(text);
        }
        text.append("]");
    }

    private double getProbsLaplace(int classIndex, Instance instance, double weight) throws Exception {
        double prob = 0.0;
        if (this.m_isLeaf) {
            return weight * this.localModel().classProbLaplace(classIndex, instance, -1);
        }
        int treeIndex = this.localModel().whichSubset(instance);
        if (treeIndex == -1) {
            double[] weights = this.localModel().weights(instance);
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.son((int)i).m_isEmpty) continue;
                prob += this.son(i).getProbsLaplace(classIndex, instance, weights[i] * weight);
            }
            return prob;
        }
        if (this.son((int)treeIndex).m_isEmpty) {
            return weight * this.localModel().classProbLaplace(classIndex, instance, treeIndex);
        }
        return this.son(treeIndex).getProbsLaplace(classIndex, instance, weight);
    }

    private double getProbs(int classIndex, Instance instance, double weight) throws Exception {
        double prob = 0.0;
        if (this.m_isLeaf) {
            return weight * this.localModel().classProb(classIndex, instance, -1);
        }
        int treeIndex = this.localModel().whichSubset(instance);
        if (treeIndex == -1) {
            double[] weights = this.localModel().weights(instance);
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.son((int)i).m_isEmpty) continue;
                prob += this.son(i).getProbs(classIndex, instance, weights[i] * weight);
            }
            return prob;
        }
        if (this.son((int)treeIndex).m_isEmpty) {
            return weight * this.localModel().classProb(classIndex, instance, treeIndex);
        }
        return this.son(treeIndex).getProbs(classIndex, instance, weight);
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private ClassifierTree son(int index) {
        return this.m_sons[index];
    }

    public double[] getMembershipValues(Instance instance) throws Exception {
        double[] a = new double[this.numNodes()];
        LinkedList<Double> queueOfWeights = new LinkedList<Double>();
        LinkedList<ClassifierTree> queueOfNodes = new LinkedList<ClassifierTree>();
        queueOfWeights.add(instance.weight());
        queueOfNodes.add(this);
        int index = 0;
        while (!queueOfNodes.isEmpty()) {
            a[index++] = (Double)queueOfWeights.poll();
            ClassifierTree node = (ClassifierTree)queueOfNodes.poll();
            if (node.m_isLeaf) continue;
            int treeIndex = node.localModel().whichSubset(instance);
            double[] weights = new double[node.m_sons.length];
            if (treeIndex == -1) {
                weights = node.localModel().weights(instance);
            } else {
                weights[treeIndex] = 1.0;
            }
            for (int i = 0; i < node.m_sons.length; ++i) {
                queueOfNodes.add(node.son(i));
                queueOfWeights.add(a[index - 1] * weights[i]);
            }
        }
        return a;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15122 $");
    }
}

