/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;

public class MedianOfWidestDimension
extends BallSplitter
implements OptionHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = 3054842574468790421L;
    protected boolean m_NormalizeDimWidths = true;

    public MedianOfWidestDimension() {
    }

    public MedianOfWidestDimension(int[] instList, Instances insts, EuclideanDistance e) {
        super(instList, insts, e);
    }

    public String globalInfo() {
        return "Class that splits a BallNode of a ball tree based on the median value of the widest dimension of the points in the ball. It essentially implements Omohundro's  KD construction algorithm.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        result.setValue(TechnicalInformation.Field.YEAR, "1989");
        result.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        result.setValue(TechnicalInformation.Field.MONTH, "December");
        result.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        return result;
    }

    @Override
    public void splitNode(BallNode node, int numNodesCreated) throws Exception {
        this.correctlyInitialized();
        double[][] ranges = this.m_DistanceFunction.initializeRanges(this.m_Instlist, node.m_Start, node.m_End);
        int splitAttrib = this.widestDim(ranges, this.m_DistanceFunction.getRanges());
        int medianIdxIdx = node.m_Start + (node.m_End - node.m_Start) / 2;
        int medianIdx = this.select(splitAttrib, this.m_Instlist, node.m_Start, node.m_End, (node.m_End - node.m_Start) / 2 + 1);
        node.m_SplitAttrib = splitAttrib;
        node.m_SplitVal = this.m_Instances.instance(this.m_Instlist[medianIdx]).value(splitAttrib);
        Instance pivot = BallNode.calcCentroidPivot(node.m_Start, medianIdxIdx, this.m_Instlist, this.m_Instances);
        node.m_Left = new BallNode(node.m_Start, medianIdxIdx, numNodesCreated + 1, pivot, BallNode.calcRadius(node.m_Start, medianIdxIdx, this.m_Instlist, this.m_Instances, pivot, this.m_DistanceFunction));
        pivot = BallNode.calcCentroidPivot(medianIdxIdx + 1, node.m_End, this.m_Instlist, this.m_Instances);
        node.m_Right = new BallNode(medianIdxIdx + 1, node.m_End, numNodesCreated + 2, pivot, BallNode.calcRadius(medianIdxIdx + 1, node.m_End, this.m_Instlist, this.m_Instances, pivot, this.m_DistanceFunction));
    }

    protected int partition(int attIdx, int[] index, int l, int r) {
        double pivot = this.m_Instances.instance(index[(l + r) / 2]).value(attIdx);
        while (l < r) {
            while (this.m_Instances.instance(index[l]).value(attIdx) < pivot && l < r) {
                ++l;
            }
            while (this.m_Instances.instance(index[r]).value(attIdx) > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && this.m_Instances.instance(index[r]).value(attIdx) > pivot) {
            --r;
        }
        return r;
    }

    public int select(int attIdx, int[] indices, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(attIdx, indices, left, right);
        if (middle - left + 1 >= k) {
            return this.select(attIdx, indices, left, middle, k);
        }
        return this.select(attIdx, indices, middle + 1, right, k - (middle - left + 1));
    }

    protected int widestDim(double[][] nodeRanges, double[][] universe) {
        int classIdx = this.m_Instances.classIndex();
        double widest = 0.0;
        int w = -1;
        if (this.m_NormalizeDimWidths) {
            for (int i = 0; i < nodeRanges.length; ++i) {
                double newWidest = nodeRanges[i][2] / universe[i][2];
                if (!(newWidest > widest) || i == classIdx) continue;
                widest = newWidest;
                w = i;
            }
        } else {
            for (int i = 0; i < nodeRanges.length; ++i) {
                if (!(nodeRanges[i][2] > widest) || i == classIdx) continue;
                widest = nodeRanges[i][2];
                w = i;
            }
        }
        return w;
    }

    public String normalizeDimWidthsTipText() {
        return "Whether to normalize the widths(ranges) of the dimensions (attributes) before selecting the widest one.";
    }

    public void setNormalizeDimWidths(boolean normalize) {
        this.m_NormalizeDimWidths = normalize;
    }

    public boolean getNormalizeDimWidths() {
        return this.m_NormalizeDimWidths;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tNormalize dimensions' widths.", "N", 0, "-N"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setNormalizeDimWidths(Utils.getFlag('N', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getNormalizeDimWidths()) {
            result.add("-N");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

