/*
 * Decompiled with CFR 0.152.
 */
package nz.co.senanque.jndi;

import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.Queue;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WebLogicJndiStartup {
    public static void main(String[] args) {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            for (String arg : args) {
                WebLogicJndiStartup.parseArg(ic, arg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseArg(InitialContext ic, String arg) {
        System.out.println("Found argument: " + arg);
        int i = arg.indexOf(61);
        if (i == -1) {
            throw new RuntimeException("Bad argument: " + arg);
        }
        String name = arg.substring(0, i);
        String value = arg.substring(i + 1);
        i = name.indexOf(60);
        if (i != -1) {
            String type = name.substring(i + 1, name.length() - 1);
            name = name.substring(0, i);
            try {
                Class<?> clazz = Class.forName(type);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                value = constructor.newInstance(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        WebLogicJndiStartup.bindParam(ic, name, value);
    }

    private static void bindParam(InitialContext ic, String name, Object value) {
        System.out.println("Creating JNDI entry: " + name + " " + String.valueOf(value));
        try {
            Queue<String> n = WebLogicJndiStartup.split(name);
            Context nc = ic;
            while (n.size() > 1) {
                nc = WebLogicJndiStartup.checkAndCreateContext(n, nc);
            }
            WebLogicJndiStartup.bind(value, n.remove(), nc);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void bind(Object value, String name, Context nc) throws NamingException {
        nc.bind(name, value);
    }

    private static Context checkAndCreateContext(Queue<String> n, Context nc) throws NamingException {
        String s = n.remove();
        nc = WebLogicJndiStartup.checkContext(nc, s) ? (Context)nc.lookup(s) : nc.createSubcontext(s);
        return nc;
    }

    private static Queue<String> split(String name) {
        LinkedList<String> retVal = new LinkedList<String>();
        for (String s : name.split("/")) {
            for (String ss : s.split("\\.")) {
                retVal.add(ss);
            }
        }
        return retVal;
    }

    private static boolean checkContext(Context nc, String name) {
        boolean retVal = true;
        try {
            retVal = nc.lookup(name) != null;
        }
        catch (NamingException e) {
            retVal = false;
        }
        return retVal;
    }
}

