/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.commonshttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import oauth.signpost.AbstractOAuthProvider;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.HttpRequestAdapter;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.http.HttpRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class CommonsHttpOAuthProvider
extends AbstractOAuthProvider {
    private static final long serialVersionUID = 1L;
    private HttpClient httpClient = new DefaultHttpClient();

    public CommonsHttpOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        super(requestTokenEndpointUrl, accessTokenEndpointUrl, authorizationWebsiteUrl);
    }

    protected void retrieveToken(OAuthConsumer consumer, String endpointUrl) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException {
        Map defaultHeaders = this.getRequestHeaders();
        if (consumer.getConsumerKey() == null || consumer.getConsumerSecret() == null) {
            throw new OAuthExpectationFailedException("Consumer key or secret not set");
        }
        HttpGet request = new HttpGet(endpointUrl);
        for (String header : defaultHeaders.keySet()) {
            request.setHeader(header, (String)defaultHeaders.get(header));
        }
        HttpResponse response = null;
        try {
            consumer.sign((HttpRequest)new HttpRequestAdapter((HttpUriRequest)request));
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                throw new OAuthNotAuthorizedException();
            }
            Map responseParams = OAuth.decodeForm((InputStream)response.getEntity().getContent());
            String token = (String)responseParams.get("oauth_token");
            String secret = (String)responseParams.get("oauth_token_secret");
            responseParams.remove("oauth_token");
            responseParams.remove("oauth_token_secret");
            this.setResponseParameters(responseParams);
            if (token == null || secret == null) {
                throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
            }
            consumer.setTokenWithSecret(token, secret);
        }
        catch (OAuthNotAuthorizedException e) {
            throw e;
        }
        catch (OAuthExpectationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAuthCommunicationException(e);
        }
        finally {
            HttpEntity entity;
            if (response != null && (entity = response.getEntity()) != null) {
                try {
                    entity.consumeContent();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

