/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.basic;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import oauth.signpost.AbstractOAuthProvider;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.HttpURLConnectionRequestAdapter;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;

public class DefaultOAuthProvider
extends AbstractOAuthProvider {
    private static final long serialVersionUID = 1L;
    private HttpURLConnection connection;

    public DefaultOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        super(requestTokenEndpointUrl, accessTokenEndpointUrl, authorizationWebsiteUrl);
    }

    protected void retrieveToken(OAuthConsumer consumer, String endpointUrl) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException {
        Map<String, String> defaultHeaders = this.getRequestHeaders();
        if (consumer.getConsumerKey() == null || consumer.getConsumerSecret() == null) {
            throw new OAuthExpectationFailedException("Consumer key or secret not set");
        }
        try {
            if (this.connection == null) {
                this.connection = (HttpURLConnection)new URL(endpointUrl).openConnection();
                this.connection.setRequestMethod("GET");
            }
            HttpURLConnectionRequestAdapter request = new HttpURLConnectionRequestAdapter(this.connection);
            for (String header : defaultHeaders.keySet()) {
                request.setHeader(header, defaultHeaders.get(header));
            }
            consumer.sign(request);
            this.connection.connect();
            int statusCode = this.connection.getResponseCode();
            if (statusCode == 401) {
                throw new OAuthNotAuthorizedException();
            }
            Map<String, String> responseParams = OAuth.decodeForm(this.connection.getInputStream());
            String token = responseParams.get("oauth_token");
            String secret = responseParams.get("oauth_token_secret");
            responseParams.remove("oauth_token");
            responseParams.remove("oauth_token_secret");
            this.setResponseParameters(responseParams);
            if (token == null || secret == null) {
                throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
            }
            consumer.setTokenWithSecret(token, secret);
        }
        catch (OAuthNotAuthorizedException e) {
            throw e;
        }
        catch (OAuthExpectationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAuthCommunicationException(e);
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
                this.connection = null;
            }
        }
    }

    void setHttpUrlConnection(HttpURLConnection connection) {
        this.connection = connection;
    }
}

