/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.ObjectCache;

public class CacheFilterClassImpl
implements CacheFilter {
    public static final String CACHEABLE = "cacheable";
    private PersistenceBroker broker;
    private ObjectCache cache;

    public CacheFilterClassImpl(PersistenceBroker broker, ObjectCache cache) {
        this.broker = broker;
        this.cache = cache;
    }

    public boolean beforeCache(Identity oid, Object obj) {
        String cacheable = this.broker.getClassDescriptor(oid.getObjectsRealClass()).getAttribute(CACHEABLE);
        return cacheable == null || Boolean.valueOf(cacheable) != false;
    }

    public boolean beforeLookup(Identity oid) {
        return true;
    }

    public boolean beforeRemove(Identity oid) {
        return true;
    }

    public ObjectCache getObjectCache() {
        return this.cache;
    }
}

