/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCache,
PBStateListener {
    public static final String TIMEOUT_PROP = "timeout";
    public static final String AUTOSYNC_PROP = "autoSync";
    public static final String CACHING_KEY_TYPE_PROP = "cachingKeyType";
    protected static Map objectTable = new Hashtable();
    private static ReferenceQueue queue = new ReferenceQueue();
    private static long hitCount = 0L;
    private static long failCount = 0L;
    private static long gcCount = 0L;
    protected PersistenceBroker broker;
    private List identitiesInWork;
    private boolean useAutoSync;
    private long timeout = 900000L;
    private int cachingKeyType;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;

    public ObjectCacheDefaultImpl(PersistenceBroker broker, Properties prop) {
        this.broker = broker;
        this.timeout = prop == null ? this.timeout : Long.parseLong(prop.getProperty(TIMEOUT_PROP, "900")) * 1000L;
        this.cachingKeyType = prop == null ? 0 : Integer.parseInt(prop.getProperty(CACHING_KEY_TYPE_PROP, "0"));
        boolean bl = this.useAutoSync = prop == null ? false : Boolean.valueOf(prop.getProperty(AUTOSYNC_PROP, "false").trim());
        if (this.useAutoSync && broker != null) {
            broker.addListener(this, true);
        }
        if (this.useAutoSync && broker == null) {
            LoggerFactory.getDefaultLogger().info("[" + (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheDefaultImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl).getName() + "] Can't enable " + AUTOSYNC_PROP + ", because given PB instance is null");
        }
        this.identitiesInWork = new ArrayList();
    }

    public void clear() {
        this.processQueue();
        objectTable.clear();
        this.identitiesInWork.clear();
    }

    public void cache(Identity oid, Object obj) {
        this.processQueue();
        if (obj != null) {
            this.traceIdentity(oid);
            objectTable.put(this.buildKey(oid), new CacheEntry(obj, oid, queue));
        }
    }

    public Object lookup(Identity oid) {
        this.processQueue();
        ++hitCount;
        Object result = null;
        CacheEntry entry = (CacheEntry)objectTable.get(this.buildKey(oid));
        if (entry != null && entry.oid.getObjectsTopLevelClass().equals(oid.getObjectsTopLevelClass())) {
            result = entry.get();
            if (result == null || entry.lifetime < System.currentTimeMillis()) {
                ++gcCount;
                this.remove(oid);
                result = null;
            } else {
                this.traceIdentity(oid);
            }
        } else {
            ++failCount;
        }
        return result;
    }

    public void remove(Identity oid) {
        this.processQueue();
        if (oid != null) {
            this.removeTracedIdentity(oid);
            objectTable.remove(this.buildKey(oid));
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("Count of cached objects", objectTable.keySet().size());
        buf.append("Lookup hits", hitCount);
        buf.append("Failures", failCount);
        buf.append("Reclaimed", gcCount);
        return buf.toString();
    }

    protected void finalize() {
        LoggerFactory.getDefaultLogger().debug("Finalize ObjectCache: " + this.toString());
    }

    private void traceIdentity(Identity oid) {
        if (this.useAutoSync && this.broker != null && this.broker.isInTransaction()) {
            this.identitiesInWork.add(oid);
        }
    }

    private void removeTracedIdentity(Identity oid) {
        this.identitiesInWork.remove(oid);
    }

    private void synchronizeWithTracedObjects() {
        LoggerFactory.getDefaultLogger().info("[" + this.getClass().getName() + "] tx was aborted," + " remove " + this.identitiesInWork.size() + " traced (potentially modified) objects from cache");
        Iterator iterator = this.identitiesInWork.iterator();
        while (iterator.hasNext()) {
            Identity oid = (Identity)iterator.next();
            objectTable.remove(this.buildKey(oid));
        }
    }

    private Integer buildKey(Identity oid) {
        int key = 0;
        switch (this.cachingKeyType) {
            case 0: {
                key = oid.hashCode();
                break;
            }
            case 1: {
                key = new HashCodeBuilder().append(this.broker.getPBKey().getAlias().hashCode()).append(oid.hashCode()).toHashCode();
                break;
            }
            case 2: {
                key = new HashCodeBuilder().append(this.broker.getDescriptorRepository().hashCode()).append(oid.hashCode()).toHashCode();
                break;
            }
            case 3: {
                key = new HashCodeBuilder().append(this.broker.getDescriptorRepository().hashCode()).append(this.broker.getPBKey().getAlias().hashCode()).append(oid.hashCode()).toHashCode();
                break;
            }
            default: {
                throw new OJBRuntimeException("Unexpected error, 'cacheType =" + this.cachingKeyType + "' was not supported");
            }
        }
        return new Integer(key);
    }

    public void beforeRollback(PBStateEvent event) {
        this.synchronizeWithTracedObjects();
    }

    public void beforeCommit(PBStateEvent event) {
        this.identitiesInWork.clear();
    }

    public void beforeClose(PBStateEvent event) {
        this.identitiesInWork.clear();
    }

    public void afterRollback(PBStateEvent event) {
    }

    public void afterCommit(PBStateEvent event) {
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void afterOpen(PBStateEvent event) {
    }

    private void processQueue() {
        CacheEntry sv;
        while ((sv = (CacheEntry)queue.poll()) != null) {
            this.removeTracedIdentity(sv.oid);
            objectTable.remove(this.buildKey(sv.oid));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CacheEntry
    extends SoftReference {
        private final long lifetime;
        private final Identity oid;

        public CacheEntry(Object object, Identity k, ReferenceQueue q) {
            super(object, q);
            this.oid = k;
            this.lifetime = ObjectCacheDefaultImpl.this.timeout < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ObjectCacheDefaultImpl.this.timeout;
        }
    }
}

