/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class ObjectCachePerBrokerImpl
implements ObjectCache,
PBStateListener {
    protected Map objectTable = new HashMap();

    public ObjectCachePerBrokerImpl(PersistenceBroker broker, Properties prop) {
        broker.addListener(this, true);
    }

    public void clear() {
        this.objectTable.clear();
    }

    public void cache(Identity oid, Object obj) {
        if (obj != null) {
            SoftReference<Object> ref = new SoftReference<Object>(obj);
            this.objectTable.put(oid, ref);
        }
    }

    public Object lookup(Identity oid) {
        Object obj = null;
        SoftReference ref = (SoftReference)this.objectTable.get(oid);
        if (ref != null && (obj = ref.get()) == null) {
            this.objectTable.remove(oid);
        }
        return obj;
    }

    public void remove(Identity oid) {
        if (oid != null) {
            this.objectTable.remove(oid);
        }
    }

    public void beforeClose(PBStateEvent event) {
        this.clear();
    }

    public void afterOpen(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void beforeCommit(PBStateEvent event) {
    }

    public void afterCommit(PBStateEvent event) {
    }

    public void beforeRollback(PBStateEvent event) {
    }

    public void afterRollback(PBStateEvent event) {
        this.clear();
    }
}

