/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.query.Query;

public class CollectionProxyDefaultImpl
implements Collection,
ManageableCollection,
CollectionProxy {
    private transient PersistenceBroker _broker;
    private PBKey _brokerKey;
    private Query _query;
    private Collection _data;
    private Class _collectionClass;
    private int _size = -1;
    private boolean _needsClose;
    private transient ArrayList _listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection;

    public CollectionProxyDefaultImpl(PBKey brokerKey, Query query) {
        this(brokerKey, class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = CollectionProxyDefaultImpl.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query);
    }

    public CollectionProxyDefaultImpl(PBKey brokerKey, Class collClass, Query query) {
        this.setBrokerKey(brokerKey);
        this.setCollectionClass(collClass);
        this.setQuery(query);
    }

    public boolean isLoaded() {
        return this._data != null;
    }

    protected synchronized int loadSize() throws PersistenceBrokerException {
        try {
            int n = this.getBroker().getCount(this.getQuery());
            return n;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected synchronized void setSize(int size) {
        this._size = size;
    }

    protected Collection loadData() throws PersistenceBrokerException {
        try {
            Collection result = this._data != null ? this._data : (this._size != 0 ? (Collection)((Object)this.getBroker().getCollectionByQuery(this.getCollectionClass(), this.getQuery())) : (Collection)this.getCollectionClass().newInstance());
            Collection collection = result;
            return collection;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected void beforeLoading() {
        if (this._listeners != null) {
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                CollectionProxyListener listener = (CollectionProxyListener)this._listeners.get(idx);
                listener.beforeLoading(this);
            }
        }
    }

    protected void afterLoading() {
        if (this._listeners != null) {
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                CollectionProxyListener listener = (CollectionProxyListener)this._listeners.get(idx);
                listener.afterLoading(this);
            }
        }
    }

    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        if (this._size < 0) {
            this._size = this.loadSize();
        }
        return this._size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        return this.getData().contains(o);
    }

    public Iterator iterator() {
        return this.getData().iterator();
    }

    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getData().toArray(a);
    }

    public boolean add(Object o) {
        return this.getData().add(o);
    }

    public boolean remove(Object o) {
        return this.getData().remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.getData().containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.getData().addAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.getData().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.getData().retainAll(c);
    }

    public void clear() {
        Class collClass;
        if ((class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection = CollectionProxyDefaultImpl.class$("org.apache.ojb.broker.util.collections.IRemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection).isAssignableFrom(collClass = this.getCollectionClass())) {
            this.getData().clear();
        } else {
            ArrayList coll;
            try {
                coll = (ArrayList)collClass.newInstance();
            }
            catch (Exception e) {
                coll = new ArrayList();
            }
            this.setData(coll);
        }
        this._size = 0;
    }

    public Query getQuery() {
        return this._query;
    }

    protected void setQuery(Query query) {
        this._query = query;
    }

    protected synchronized void releaseBroker() {
        if (this._broker != null && this._needsClose) {
            this._needsClose = false;
            this._broker.close();
            this._broker = null;
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker broker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (broker == null && this._broker == null) {
            this._broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this._needsClose = true;
            broker = this._broker;
        }
        return broker;
    }

    public synchronized Collection getData() {
        if (!this.isLoaded()) {
            this.beforeLoading();
            this.setData(this.loadData());
            this.afterLoading();
        }
        return this._data;
    }

    public void setData(Collection data) {
        this._data = data;
    }

    public Class getCollectionClass() {
        return this._collectionClass;
    }

    protected void setCollectionClass(Class collClass) {
        this._collectionClass = collClass;
    }

    public void ojbAdd(Object anObject) {
        this.add(anObject);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        this.addAll((Collection)((CollectionProxyDefaultImpl)otherCollection));
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
        Collection c = this.getData();
        if (c instanceof ManageableCollection) {
            ((ManageableCollection)((Object)c)).afterStore(broker);
        }
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey brokerKey) {
        this._brokerKey = brokerKey;
    }

    public synchronized void addListener(CollectionProxyListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(CollectionProxyListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

