/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public class DeleteProcedureDescriptor
extends ProcedureDescriptor
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -1265854095889157172L;
    private boolean includePkFieldsOnly;

    public DeleteProcedureDescriptor(ClassDescriptor classDescriptor, String name, boolean includePkFieldsOnly) {
        super(classDescriptor, name);
        this.includePkFieldsOnly = includePkFieldsOnly;
        if (this.includePkFieldsOnly) {
            this.addArguments(this.getClassDescriptor().getPkFields());
            this.addArguments(this.getClassDescriptor().getLockingFields());
        }
    }

    public boolean getIncludePkFieldsOnly() {
        return this.includePkFieldsOnly;
    }

    public final void addArgument(ArgumentDescriptor argument) {
        if (!this.getIncludePkFieldsOnly()) {
            super.addArgument(argument);
        }
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(1024);
        result.append(eol);
        result.append("   ");
        result.append(" ");
        result.append(tags.getOpeningTagNonClosingById(105));
        result.append(" ");
        result.append(tags.getAttribute(97, this.getName()));
        if (this.hasReturnValue()) {
            result.append(" ");
            result.append(tags.getAttribute(108, this.getReturnValueFieldRefName()));
        }
        result.append(" ");
        result.append(tags.getAttribute(110, String.valueOf(this.getIncludePkFieldsOnly())));
        result.append(">");
        result.append(eol);
        if (!this.getIncludePkFieldsOnly()) {
            Iterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                result.append(((ArgumentDescriptor)args.next()).toXML());
            }
        }
        result.append("    ");
        result.append(tags.getClosingTagById(105));
        result.append(eol);
        return result.toString();
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append("name", (Object)this.getName());
        buf.append("includePkFieldsOnly", this.getIncludePkFieldsOnly());
        if (this.hasReturnValue()) {
            buf.append("returnFieldRefName", (Object)this.getReturnValueFieldRefName());
        }
        return buf.toString();
    }
}

