/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import org.apache.ojb.broker.metadata.FieldDescriptor;

public class TorqueFieldGenerator {
    private boolean ignoreAutoIncrement;

    public TorqueFieldGenerator(boolean ignoreAutoIncrement) {
        this.ignoreAutoIncrement = ignoreAutoIncrement;
    }

    public void generateFieldDescriptors(FieldDescriptor[] descriptors, StringBuffer buffer) {
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                FieldDescriptor descriptor = descriptors[i];
                this.generateFieldDescriptor(descriptor, descriptor.getColumnName(), descriptor.isRequired(), descriptor.isAutoIncrement(), descriptor.isPrimaryKey(), buffer);
            }
        }
    }

    public void generateMappingFieldDescriptors(FieldDescriptor[] descriptors, StringBuffer buffer) {
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                FieldDescriptor descriptor = descriptors[i];
                StringBuffer fieldBuffer = new StringBuffer();
                this.generateFieldDescriptor(descriptor, descriptor.getColumnName(), true, false, true, fieldBuffer);
                buffer.append(fieldBuffer);
            }
        }
    }

    private void generateFieldDescriptor(FieldDescriptor descriptor, String fieldName, boolean isRequired, boolean isAutoIncrement, boolean isPrimaryKey, StringBuffer buffer) {
        buffer.append("        <column name=\"");
        buffer.append(fieldName);
        buffer.append("\" required=\"");
        buffer.append(isRequired || isPrimaryKey);
        if (!this.ignoreAutoIncrement) {
            buffer.append("\" autoIncrement=\"");
            buffer.append(isAutoIncrement);
        }
        buffer.append("\" primaryKey=\"");
        buffer.append(isPrimaryKey);
        buffer.append("\" type=\"");
        buffer.append(descriptor.getColumnType());
        this.generateConstraints(descriptor, buffer);
        buffer.append("\"/>\n");
    }

    private void generateConstraints(FieldDescriptor descriptor, StringBuffer buffer) {
        int jdbcType = descriptor.getJdbcType().getType();
        switch (jdbcType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (descriptor.isPrecisionSpecified()) {
                    buffer.append("\" precision=\"");
                    buffer.append(descriptor.getPrecision());
                }
                if (!descriptor.isScaleSpecified()) break;
                buffer.append("\" scale=\"");
                buffer.append(descriptor.getScale());
                break;
            }
            default: {
                if (!descriptor.isLengthSpecified()) break;
                buffer.append("\" size=\"");
                buffer.append(descriptor.getLength());
            }
        }
    }
}

